/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.SvnConfigType;
import com.cenqua.fisheye.svn.util.SvnLoader;
import com.cenqua.fisheye.svn.util.SvnLoaderConfiguration;
import com.cenqua.fisheye.web.admin.actions.EditRepoConfigAction;
import com.google.common.base.Strings;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.annotation.PostConstruct;

public class EditSvnConfigAction
extends EditRepoConfigAction {
    private SvnConfigType svnConfig;

    @PostConstruct
    public void init() {
        try {
            SvnLoader.checkLoaded();
        }
        catch (ConfigException e2) {
            this.addActionError(e2.getMessage());
        }
    }

    private SvnConfigType getSvnConfig() {
        if (this.svnConfig == null) {
            ConfigDocument.Config cfg = AppConfig.getsConfig().getConfig();
            if (!cfg.isSetSvnConfig()) {
                cfg.addNewSvnConfig();
            }
            this.svnConfig = (SvnConfigType)cfg.getSvnConfig().copy();
        }
        return this.svnConfig;
    }

    public String execute() throws Exception {
        SvnConfigType editing = this.getSvnConfig();
        if (editing.isSetJar() && Strings.isNullOrEmpty((String)editing.getJar())) {
            editing.unsetJar();
        } else {
            try {
                JarFile jarFile;
                JarEntry entry;
                if (this.checkFileExists(editing.getJar()) && (entry = (jarFile = new JarFile(editing.getJar())).getJarEntry("org/apache/subversion/javahl/ISVNClient.class")) == null) {
                    this.addActionError("The jar " + editing.getJar() + " does not appear to be a 1.7 compatible JavaHL jar as it does not contain the JavaHL" + " interface class.");
                }
            }
            catch (Exception e2) {
                this.addActionError("Error loading jar - " + editing.getJar());
            }
        }
        if (editing.isSetJnilib() && Strings.isNullOrEmpty((String)editing.getJnilib())) {
            editing.unsetJnilib();
        } else {
            this.checkFileExists(editing.getJnilib());
        }
        if (!this.hasErrors()) {
            ConfigDocument.Config cfg = AppConfig.getsConfig().getConfig();
            if (!cfg.isSetSvnConfig() || !cfg.getSvnConfig().equals(editing)) {
                SvnLoader.getConfiguration().setChanged(true);
            }
            cfg.setSvnConfig(editing);
            AppConfig.getsConfig().saveConfig();
            return "success";
        }
        return "input";
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    public SvnLoaderConfiguration getSvnConfiguration() {
        return SvnLoader.getConfiguration();
    }

    public String getJar() {
        return this.getSvnConfig().getJar();
    }

    public void setJar(String jar) {
        this.getSvnConfig().setJar(jar);
    }

    public String getJnilib() {
        return this.getSvnConfig().getJnilib();
    }

    public void setJnilib(String jnilib) {
        this.getSvnConfig().setJnilib(jnilib);
    }
}

