/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.SmtpType;
import com.cenqua.fisheye.mail.Mailer;
import com.cenqua.fisheye.web.admin.util.AdminActionUtils;
import com.opensymphony.xwork.ActionSupport;
import java.math.BigInteger;
import javax.annotation.Resource;

public class EditSmtpConfigAction
extends ActionSupport {
    @Resource
    private Mailer mailer;
    @Resource
    protected RootConfig rootConfig;
    @Resource
    private EffectiveUserProvider effectiveUserProvider;
    private SmtpType smtp = SmtpType.Factory.newInstance();
    private boolean debug;

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public final ConfigDocument.Config getCfg() {
        return AdminActionUtils.getCfg(this, this.effectiveUserProvider, this.rootConfig);
    }

    private SmtpType getSmtp() {
        return this.smtp;
    }

    public String execute() throws Exception {
        ConfigDocument.Config cfg = this.getCfg();
        if (this.smtp.isSetPort() && this.smtp.getPort() == null) {
            this.smtp.unsetPort();
        }
        if (this.smtp.isSetUsername() && EditSmtpConfigAction.nullOrEmpty(this.smtp.getUsername())) {
            this.smtp.unsetUsername();
        }
        if (this.smtp.isSetPassword() && EditSmtpConfigAction.nullOrEmpty(this.smtp.getPassword())) {
            this.smtp.unsetPassword();
        }
        this.smtp.setDebug(this.debug);
        cfg.setSmtp(this.smtp);
        AppConfig.getsConfig().saveConfig();
        this.mailer.reload(this.smtp);
        return "success";
    }

    public String deleteConfig() throws Exception {
        ConfigDocument.Config cfg = this.getCfg();
        if (cfg.isSetSmtp()) {
            cfg.unsetSmtp();
        }
        AppConfig.getsConfig().saveConfig();
        this.mailer.reload(null);
        return "success";
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        if (this.getCfg().isSetSmtp()) {
            this.smtp = (SmtpType)this.getCfg().getSmtp().copy();
            this.debug = this.smtp.isSetDebug() && this.smtp.getDebug();
        }
        return "success";
    }

    private static boolean nullOrEmpty(String s2) {
        return s2 == null || s2.trim().length() == 0;
    }

    public String getUsername() {
        return this.getSmtp().getUsername();
    }

    public void setUsername(String username) {
        this.getSmtp().setUsername(username);
    }

    public boolean getSendEmailsAsActioner() {
        return this.getSmtp().getSendEmailsAsActioner();
    }

    public void setSendEmailsAsActioner(boolean sendEmailsAsActioner) {
        this.getSmtp().setSendEmailsAsActioner(sendEmailsAsActioner);
    }

    public boolean getStarttls() {
        return this.getSmtp().getStarttls();
    }

    public void setStarttls(boolean starttls) {
        this.getSmtp().setStarttls(starttls);
    }

    public String getFrom() {
        return this.getSmtp().getFrom();
    }

    public void setFrom(String from) {
        this.getSmtp().setFrom(from);
    }

    public String getHost() {
        return this.getSmtp().getHost();
    }

    public void setHost(String host) {
        this.getSmtp().setHost(host);
    }

    public BigInteger getPort() {
        return this.getSmtp().getPort();
    }

    public void setPort(BigInteger port) {
        this.getSmtp().setPort(port);
    }

    public BigInteger getTimeout() {
        return this.getSmtp().getTimeout();
    }

    public void setTimeout(BigInteger timeout) {
        this.getSmtp().setTimeout(timeout);
    }

    public String getPassword() {
        return this.getSmtp().getPassword();
    }

    public void setPassword(String password) {
        this.getSmtp().setPassword(password);
    }

    public BigInteger getConnectionTimeout() {
        return this.getSmtp().getConnectionTimeout();
    }

    public void setConnectionTimeout(BigInteger connectionTimeout) {
        this.getSmtp().setConnectionTimeout(connectionTimeout);
    }
}

