/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.atlassian.extras.common.LicenseException;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.Ajp13ServerType;
import com.cenqua.fisheye.config1.CheckForUpdatesType;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.HttpServerType;
import com.cenqua.fisheye.config1.ProxyInfoType;
import com.cenqua.fisheye.config1.SslServerType;
import com.cenqua.fisheye.config1.WebServerType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.svn.util.SvnLoader;
import com.cenqua.fisheye.svn.util.SvnLoaderConfiguration;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.util.ProductUpdateHttpException;
import com.cenqua.fisheye.util.ProductUpdateInfo;
import com.cenqua.fisheye.util.ProductUpdateParseException;
import com.cenqua.fisheye.util.ProductUpdatePoller;
import com.cenqua.fisheye.web.admin.actions.filedownload.PolicyDescription;
import com.cenqua.fisheye.web.admin.util.AdminActionUtils;
import com.cenqua.fisheye.web.admin.util.SSLUtils;
import com.cenqua.fisheye.web.mime.FisheyeDownloadPolicyProvider;
import com.google.common.base.Strings;
import com.opensymphony.xwork.ActionSupport;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.Resource;
import org.eclipse.jetty.util.security.Password;
import org.springframework.beans.factory.annotation.Autowired;

public class EditServerSettingsAction
extends ActionSupport {
    private static final String PROXY_PORT_NOT_A_VALID_NUMBER_MSG = "Proxy port must be an integer between 1 and 65535";
    private HttpServerType http;
    private Ajp13ServerType ajp13;
    private SslServerType ssl;
    private String webContext;
    private ProductUpdatePoller updatePoller;
    private String checkNowError = null;
    @Resource
    private FisheyeDownloadPolicyProvider downloadPolicyProvider;
    @Resource
    private EffectiveUserProvider effectiveUserProvider;
    private String timezone;
    private String siteUrl;
    private String keystorePasswordConfirm;
    private String truststorePasswordConfirm;
    private RootConfig rootConfig;
    private boolean showProxyError;

    @Autowired
    public void setUpdatePoller(ProductUpdatePoller updatePoller) {
        this.updatePoller = updatePoller;
    }

    @Autowired
    public void setRootConfig(RootConfig rootConfig) {
        this.rootConfig = rootConfig;
        ConfigDocument.Config config = rootConfig.getConfig();
        this.http = config.getWebServer().isSetHttp() ? (HttpServerType)config.getWebServer().getHttp().copy() : HttpServerType.Factory.newInstance();
        this.ajp13 = config.getWebServer().isSetAjp13() ? (Ajp13ServerType)config.getWebServer().getAjp13().copy() : Ajp13ServerType.Factory.newInstance();
        if (config.getWebServer().isSetSsl()) {
            this.ssl = (SslServerType)config.getWebServer().getSsl().copy();
            if (this.ssl.isSetKeystorePassword()) {
                this.ssl.setKeystorePassword(new Password(this.ssl.getKeystorePassword()).toString());
            }
            if (this.ssl.isSetTruststorePassword()) {
                this.ssl.setTruststorePassword(new Password(this.ssl.getTruststorePassword()).toString());
            }
            if (!this.http.isSetProxyScheme() && !this.http.isSetProxyHost() && !this.http.isSetProxyPort() && this.ssl.isSetProxyInfo()) {
                if (this.ssl.getProxyInfo().isSetProxyScheme()) {
                    this.http.setProxyScheme(this.ssl.getProxyInfo().getProxyScheme());
                }
                if (this.ssl.getProxyInfo().isSetProxyHost()) {
                    this.http.setProxyHost(this.ssl.getProxyInfo().getProxyHost());
                }
                if (this.ssl.getProxyInfo().isSetProxyPort()) {
                    this.http.setProxyPort(this.ssl.getProxyInfo().getProxyPort());
                }
            }
        } else {
            this.ssl = SslServerType.Factory.newInstance();
        }
    }

    public void setDownloadPolicyProvider(FisheyeDownloadPolicyProvider downloadPolicyProvider) {
        this.downloadPolicyProvider = downloadPolicyProvider;
    }

    public final ConfigDocument.Config getCfg() {
        return AdminActionUtils.getCfg(this, this.effectiveUserProvider, this.rootConfig);
    }

    public String getWebContext() {
        return this.webContext;
    }

    public void setWebContext(String webContext) {
        this.webContext = webContext;
    }

    public String getCheckNowError() {
        return this.checkNowError;
    }

    private HttpServerType getHttp() {
        return this.http;
    }

    public void setHttpBind(String bind) {
        this.getHttp().setBind(bind);
    }

    public String getHttpBind() {
        return this.getHttp().getBind();
    }

    public String getHttpProxyHost() {
        return this.getHttp().getProxyHost();
    }

    public void setHttpProxyHost(String proxyHost) {
        this.getHttp().setProxyHost(proxyHost);
    }

    public boolean isSetHttpProxyScheme() {
        return this.getHttp().isSetProxyScheme();
    }

    public boolean isSetHttpProxyPort() {
        return this.getHttp().isSetProxyPort();
    }

    public boolean isSetHttpProxyHost() {
        return this.getHttp().isSetProxyHost();
    }

    public String getHttpProxyScheme() {
        return this.getHttp().getProxyScheme();
    }

    public void setHttpProxyScheme(String proxyScheme) {
        this.getHttp().setProxyScheme(proxyScheme);
    }

    private Ajp13ServerType getAjp13() {
        return this.ajp13;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String getDefaultTimezone() {
        return AppConfig.getsConfig().getTimezone().getID();
    }

    public String getSiteUrl() {
        return this.siteUrl;
    }

    public void setSiteUrl(String siteUrl) {
        this.siteUrl = siteUrl;
    }

    public Collection getTimezones() {
        ArrayList<String> l2 = new ArrayList<String>(DateHelper.AVAILABLE_TIMEZONE_IDS.size() + 1);
        l2.add("");
        l2.addAll(DateHelper.AVAILABLE_TIMEZONE_IDS);
        return l2;
    }

    public boolean isDebugMode() {
        return Logs.isDebugMode();
    }

    public Date getUpdateLastChecked() {
        return this.updatePoller.getLastChecked();
    }

    public boolean isUpdateAvailable() {
        return this.updatePoller.isUpdateAvailable();
    }

    public ProductUpdateInfo getLatestUpdate() {
        return this.updatePoller.getLatestVersion();
    }

    public boolean isShowProxyError() {
        return this.showProxyError;
    }

    @RequireSecurityToken(value=false)
    public String checkNow() {
        String url = this.getCfg().getCheckForUpdates().getEnabled() ? this.getCfg().getCheckForUpdates().getUrl() : CheckForUpdatesType.Factory.newInstance().getUrl();
        try {
            this.updatePoller.checkForUpdates(url);
        }
        catch (IOException ioe) {
            this.checkNowError = "Problem communicating with the server: " + ioe.getMessage();
            Logs.APP_LOG.warn((Object)this.checkNowError, (Throwable)ioe);
        }
        catch (ProductUpdateHttpException hte) {
            this.checkNowError = "Problem establishing connection with the server: " + hte.getMessage();
            Logs.APP_LOG.warn((Object)this.checkNowError, (Throwable)hte);
            this.showProxyError = hte.isProxyError();
        }
        catch (LicenseException le) {
            this.checkNowError = "There is a problem with you license: " + le.getMessage();
            Logs.APP_LOG.warn((Object)this.checkNowError, (Throwable)le);
        }
        catch (ProductUpdateParseException pe) {
            this.checkNowError = "The server sent an invalid response: " + pe.getMessage();
            Logs.APP_LOG.warn((Object)this.checkNowError, (Throwable)pe);
        }
        return "success";
    }

    public String checkNowError() {
        return "success";
    }

    public String execute() throws Exception {
        ConfigDocument.Config cfg = this.getCfg();
        WebServerType ws = cfg.getWebServer();
        this.configureHttp(ws);
        this.configureAjp13(ws);
        this.configureSsl(ws);
        if (!(ws.isSetAjp13() || ws.isSetHttp() || ws.isSetSsl())) {
            throw new ConfigException("Neither ajp13 nor http Bind Address set.");
        }
        if (Strings.isNullOrEmpty((String)this.webContext)) {
            if (ws.isSetContext()) {
                ws.unsetContext();
            }
        } else {
            ws.setContext(this.webContext);
        }
        if (this.timezone == null || this.timezone.trim().length() == 0) {
            if (cfg.isSetTimezone()) {
                cfg.unsetTimezone();
            }
        } else {
            TimeZone tz = TimeZone.getTimeZone(this.timezone);
            cfg.setTimezone(tz.getID());
        }
        if (Strings.isNullOrEmpty((String)this.siteUrl)) {
            if (ws.isSetSiteUrl()) {
                ws.unsetSiteUrl();
            }
        } else {
            ws.setSiteUrl(this.siteUrl);
        }
        AppConfig.getsConfig().saveConfig();
        AppConfig.getsConfig().reload();
        return "success";
    }

    private void configureSsl(WebServerType ws) {
        if (Strings.isNullOrEmpty((String)this.ssl.getBind())) {
            if (ws.isSetSsl()) {
                ws.unsetSsl();
            }
            return;
        }
        ProxyInfoType proxyInfo = ProxyInfoType.Factory.newInstance();
        if (this.http.isSetProxyHost()) {
            proxyInfo.setProxyHost(this.http.getProxyHost());
        }
        if (this.http.isSetProxyPort()) {
            proxyInfo.setProxyPort(this.http.getProxyPort());
        }
        if (this.http.isSetProxyScheme()) {
            proxyInfo.setProxyScheme(this.http.getProxyScheme());
        }
        this.ssl.setProxyInfo(proxyInfo);
        if (this.ssl.isSetTruststorePassword()) {
            this.ssl.setTruststorePassword(Password.obfuscate((String)new Password(this.ssl.getTruststorePassword()).toString()));
        }
        if (this.ssl.isSetKeystorePassword()) {
            this.ssl.setKeystorePassword(Password.obfuscate((String)new Password(this.ssl.getKeystorePassword()).toString()));
        }
        ws.setSsl(this.ssl);
    }

    public BigInteger getHttpProxyPort() {
        return this.http.isSetProxyPort() ? this.http.getProxyPort() : null;
    }

    public void setHttpProxyPort(String value) {
        if (Strings.nullToEmpty((String)value).trim().isEmpty()) {
            this.http.unsetProxyPort();
        } else {
            try {
                this.http.setProxyPort(BigInteger.valueOf(Long.parseLong(value)));
            }
            catch (NumberFormatException e2) {
                this.addFieldError("httpProxyPort", PROXY_PORT_NOT_A_VALID_NUMBER_MSG);
            }
        }
    }

    private void configureAjp13(WebServerType ws) {
        if (Strings.isNullOrEmpty((String)this.ajp13.getBind())) {
            if (ws.isSetAjp13()) {
                ws.unsetAjp13();
            }
            return;
        }
        ws.setAjp13(this.ajp13);
    }

    private void configureHttp(WebServerType ws) {
        if (this.http.isSetProxyHost() && Strings.nullToEmpty((String)this.http.getProxyHost()).trim().isEmpty()) {
            this.http.unsetProxyHost();
        }
        if (this.http.isSetProxyScheme() && Strings.nullToEmpty((String)this.http.getProxyScheme()).trim().isEmpty()) {
            this.http.unsetProxyScheme();
        }
        if (this.http.isSetProxyPort() && this.http.getProxyPort() == null) {
            this.http.unsetProxyPort();
        }
        if (Strings.isNullOrEmpty((String)this.http.getBind())) {
            if (ws.isSetHttp()) {
                ws.unsetHttp();
            }
            return;
        }
        ws.setHttp(this.http);
    }

    private SslServerType getSsl() {
        return this.ssl;
    }

    public String getSslBind() {
        return this.getSsl().getBind();
    }

    public void setSslBind(String bind) {
        this.getSsl().setBind(bind);
    }

    public String getSslKeystore() {
        return this.getSsl().getKeystore();
    }

    public void setSslKeystore(String keystore) {
        this.getSsl().setKeystore(keystore);
    }

    public String getSslKeystorePassword() {
        return this.getSsl().getKeystorePassword();
    }

    public void setSslKeystorePassword(String keystorePassword) {
        this.getSsl().setKeystorePassword(keystorePassword);
    }

    public String getSslTruststore() {
        return this.getSsl().getTruststore();
    }

    public void setSslTruststore(String truststore) {
        this.getSsl().setTruststore(truststore);
    }

    public String getSslTruststorePassword() {
        return this.getSsl().getTruststorePassword();
    }

    public void setSslTruststorePassword(String truststorePassword) {
        this.getSsl().setTruststorePassword(truststorePassword);
    }

    public String getKeystorePasswordConfirm() {
        return this.keystorePasswordConfirm;
    }

    public void setKeystorePasswordConfirm(String keystorePasswordConfirm) {
        this.keystorePasswordConfirm = keystorePasswordConfirm;
    }

    public String getTruststorePasswordConfirm() {
        return this.truststorePasswordConfirm;
    }

    public void setTruststorePasswordConfirm(String truststorePasswordConfirm) {
        this.truststorePasswordConfirm = truststorePasswordConfirm;
    }

    public boolean isCorrectKeystorePassword() {
        return SSLUtils.isCorrectKeystorePassword(this.ssl.getKeystore(), this.ssl.getKeystorePassword());
    }

    public boolean isCorrectTruststorePassword() {
        if (this.ssl.isSetTruststore()) {
            return SSLUtils.isCorrectKeystorePassword(this.ssl.getTruststore(), this.ssl.getTruststorePassword());
        }
        return true;
    }

    public PolicyDescription getDownloadPolicyDescription() {
        return PolicyDescription.forName(this.downloadPolicyProvider.getPolicy());
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        this.webContext = this.getCfg().getWebServer().getContext();
        this.timezone = this.getCfg().getTimezone();
        this.siteUrl = "";
        if (this.getCfg().getWebServer().isSetSiteUrl()) {
            this.siteUrl = this.getCfg().getWebServer().getSiteUrl();
        }
        return "success";
    }

    public SvnLoaderConfiguration getSvnConfiguration() {
        return SvnLoader.getConfiguration();
    }

    public void setAjp13Bind(String bind) {
        this.getAjp13().setBind(bind);
    }

    public String getAjp13Bind() {
        return this.getAjp13().getBind();
    }
}

