/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.P4ConfigType;
import com.cenqua.fisheye.perforce.client.P4Exec;
import com.cenqua.fisheye.web.admin.actions.EditRepoConfigAction;
import org.apache.commons.lang.StringUtils;

public class EditP4ConfigAction
extends EditRepoConfigAction {
    private P4ConfigType p4Config;

    private P4ConfigType getP4Config() {
        if (this.p4Config == null) {
            ConfigDocument.Config cfg = AppConfig.getsConfig().getConfig();
            if (!cfg.isSetP4Config()) {
                cfg.addNewP4Config();
            }
            this.p4Config = (P4ConfigType)cfg.getP4Config().copy();
        }
        return this.p4Config;
    }

    public String execute() throws Exception {
        P4ConfigType editing = this.getP4Config();
        if (editing.isSetP4Location() && StringUtils.isEmpty((String)editing.getP4Location())) {
            editing.unsetP4Location();
        } else {
            try {
                this.checkFileExists(editing.getP4Location());
            }
            catch (Exception e2) {
                this.addActionError("Could not find P4 executable at " + editing.getP4Location());
            }
        }
        ConfigDocument.Config cfg = AppConfig.getsConfig().getConfig();
        cfg.setP4Config(editing);
        try {
            P4Exec.setupExecutable(editing.getP4Location());
        }
        catch (ConfigException e3) {
            this.addActionError(e3.getMessage());
        }
        AppConfig.getsConfig().saveConfig();
        return this.hasErrors() ? "input" : "success";
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    public String getP4Location() {
        return this.getP4Config().getP4Location();
    }

    public void setP4Location(String p4Location) {
        this.getP4Config().setP4Location(p4Location);
    }
}

