/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.common.LicenseException;
import com.atlassian.fecru.license.LicenseManager;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.LicenseType;
import com.cenqua.fisheye.license.LicenseHolder;
import com.cenqua.fisheye.license.LicenseUtils;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.opensymphony.xwork.ActionSupport;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;

public class EditLicenseAction
extends ActionSupport {
    public static final String CRU_FIELD = "cruLicense";
    public static final String FE_FIELD = "feLicense";
    private String feLicenseString;
    private String cruLicenseString;
    private boolean cruEvalOnly = false;
    @Resource
    private RootConfig rootConfig;
    @Resource
    private LicenseManager licenseManager;

    @VisibleForTesting
    EditLicenseAction(RootConfig rootConfig, LicenseManager licenseManager) {
        this.rootConfig = rootConfig;
        this.licenseManager = licenseManager;
        this.init();
    }

    public EditLicenseAction() {
    }

    @PostConstruct
    public void init() {
        LicenseType licenseType = this.rootConfig.getConfig().getLicense();
        if (licenseType.isSetFisheye()) {
            this.feLicenseString = licenseType.getFisheye();
        }
        if (licenseType.isSetCrucible()) {
            this.cruLicenseString = licenseType.getCrucible();
        }
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        LicenseHolder holder = LicenseHolder.makeFishEyeCrucibleLicense(this.feLicenseString, this.cruLicenseString);
        ProductLicense crucibleLicense = holder.getCrucibleLicense();
        ProductLicense fisheyeLicense = holder.getFishEyeLicense();
        this.cruEvalOnly = crucibleLicense != null && crucibleLicense.getExpiryDate() != null && fisheyeLicense != null && fisheyeLicense.getExpiryDate() != null && (this.feLicenseString == null || Strings.isNullOrEmpty((String)this.feLicenseString.trim()));
        return super.doDefault();
    }

    public boolean isCruEvalOnly() {
        return this.cruEvalOnly;
    }

    public String getFeLicense() {
        return this.feLicenseString;
    }

    public void setFeLicense(String feLicense) {
        this.feLicenseString = feLicense == null ? null : feLicense.trim();
    }

    public String getCruLicense() {
        return this.cruLicenseString;
    }

    public void setCruLicense(String cruLicense) {
        this.cruLicenseString = cruLicense == null ? null : cruLicense.trim();
    }

    public void validate() {
        LicenseHolder holder = LicenseHolder.makeFishEyeCrucibleLicense(this.feLicenseString, this.cruLicenseString);
        if (holder.isFishEyeDisabled() && holder.isCrucibleDisabled()) {
            this.addActionError("You must enter at least one license.");
            return;
        }
        if (holder.isFishEyeDisabled()) {
            this.feLicenseString = "Disabled";
        } else if (!holder.hasFishEye() || !holder.canDecodeFishEye()) {
            this.addFieldError(FE_FIELD, "The FishEye license key you have entered is invalid.");
        } else if (holder.isFishEyeGracePeriodExpired()) {
            this.addFieldError(FE_FIELD, this.terminatedLicenseMessage(holder.getFishEyeLicense().getGracePeriodEndDate()));
        } else if (!holder.isFishEyeValidForCurrentBuild()) {
            this.addFieldError(FE_FIELD, LicenseUtils.getInvalidBuildMessage(holder.getFishEyeLicense()));
        }
        if (holder.isCrucibleDisabled()) {
            this.cruLicenseString = "Disabled";
        } else if (!holder.hasCrucible() || !holder.canDecodeCrucible()) {
            this.addFieldError(CRU_FIELD, "The Crucible license key you have entered is invalid.");
        } else if (holder.isCrucibleGracePeriodExpired()) {
            this.addFieldError(CRU_FIELD, this.terminatedLicenseMessage(holder.getCrucibleLicense().getGracePeriodEndDate()));
        } else if (!holder.isCrucibleValidForCurrentBuild()) {
            this.addFieldError(CRU_FIELD, LicenseUtils.getInvalidBuildMessage(holder.getCrucibleLicense()));
        }
    }

    public String execute() throws Exception {
        try {
            this.licenseManager.updateLicenses(this.feLicenseString, this.cruLicenseString);
        }
        catch (LicenseException e2) {
            Logs.APP_LOG.warn((Object)("Failed to reload licenses: " + e2.getMessage()));
            this.addActionError("There was a problem updating your licenses. See log for details.");
            return "input";
        }
        return "success";
    }

    private String terminatedLicenseMessage(Date expiredDate) {
        return "The license key you have entered terminated on " + new SimpleDateFormat("MMMM dd, yyyy").format(expiredDate.getTime()) + ". Please enter a current license key.";
    }
}

