/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.atlassian.fisheye.hg.HgRepositoryEngine;
import com.atlassian.fisheye.hg.client.HgContext;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.HgConfigType;
import com.cenqua.fisheye.rep.Version;
import com.cenqua.fisheye.web.admin.actions.EditRepoConfigAction;
import org.apache.commons.lang.StringUtils;

public class EditHgConfigAction
extends EditRepoConfigAction {
    private static final long serialVersionUID = -2687083468286520904L;
    private HgConfigType hgConfig;

    private HgConfigType getHgConfig() {
        if (this.hgConfig == null) {
            ConfigDocument.Config cfg = AppConfig.getsConfig().getConfig();
            this.hgConfig = cfg.isSetHgConfig() ? (HgConfigType)cfg.getHgConfig().copy() : HgConfigType.Factory.newInstance();
        }
        return this.hgConfig;
    }

    public String execute() throws Exception {
        HgConfigType editing = this.getHgConfig();
        ConfigDocument.Config cfg = AppConfig.getsConfig().getConfig();
        if (StringUtils.isEmpty((String)editing.getHgExecutable())) {
            if (cfg.isSetHgConfig()) {
                cfg.unsetHgConfig();
            }
        } else if (this.checkFileExists(editing.getHgExecutable())) {
            try {
                Version hgVersion = HgContext.determineHgVersion(editing.getHgExecutable());
                HgRepositoryEngine.validateHgVersion(hgVersion);
                cfg.setHgConfig(editing);
                AppConfig.getsConfig().saveConfig();
            }
            catch (ConfigException ex) {
                this.addFieldError("hgExecutable", "Bad hg executable: " + ex.getMessage());
            }
        }
        return this.hasErrors() ? "input" : "success";
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    public String getHgExecutable() {
        return this.getHgConfig().getHgExecutable();
    }

    public void setHgExecutable(String hgExecutable) {
        this.getHgConfig().setHgExecutable(hgExecutable);
    }
}

