/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.atlassian.fisheye.git.GitRepositoryEngine;
import com.atlassian.fisheye.git.client.GitContext;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.GitConfigType;
import com.cenqua.fisheye.rep.Version;
import com.cenqua.fisheye.web.admin.actions.EditRepoConfigAction;
import org.apache.commons.lang.StringUtils;

public class EditGitConfigAction
extends EditRepoConfigAction {
    private GitConfigType gitConfig;

    private GitConfigType getGitConfig() {
        if (this.gitConfig == null) {
            ConfigDocument.Config cfg = AppConfig.getsConfig().getConfig();
            this.gitConfig = cfg.isSetGitConfig() ? (GitConfigType)cfg.getGitConfig().copy() : GitConfigType.Factory.newInstance();
        }
        return this.gitConfig;
    }

    public String execute() throws Exception {
        GitConfigType editing = this.getGitConfig();
        ConfigDocument.Config cfg = AppConfig.getsConfig().getConfig();
        if (StringUtils.isEmpty((String)editing.getGitExecutable())) {
            if (cfg.isSetGitConfig()) {
                cfg.unsetGitConfig();
            }
        } else if (this.checkFileExists(editing.getGitExecutable())) {
            try {
                Version gitVersion = GitContext.determineGitVersion(editing.getGitExecutable());
                GitRepositoryEngine.validateGitVersion(gitVersion);
                cfg.setGitConfig(editing);
                AppConfig.getsConfig().saveConfig();
            }
            catch (ConfigException ex) {
                this.addFieldError("gitExecutable", "Invalid git executable: " + ex.getMessage());
            }
        }
        return this.hasErrors() ? "input" : "success";
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    public String getGitExecutable() {
        return this.getGitConfig().getGitExecutable();
    }

    public void setGitExecutable(String gitExecutable) {
        this.getGitConfig().setGitExecutable(gitExecutable);
    }
}

