/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.RawPolicyType;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.web.admin.actions.filedownload.PolicyDescription;
import com.cenqua.fisheye.web.mime.DownloadPolicy;
import com.cenqua.fisheye.web.mime.FisheyeDownloadPolicyProvider;
import com.opensymphony.xwork.ActionSupport;
import java.util.Arrays;
import javax.annotation.Resource;

public class EditDownloadPolicyAction
extends ActionSupport {
    @Resource
    private FisheyeDownloadPolicyProvider fisheyeDownloadPolicyProvider;
    @Resource
    private RootConfig rootConfig;
    private DownloadPolicy newPolicy;
    private DownloadPolicy policy;

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        this.policy = this.fisheyeDownloadPolicyProvider.getPolicy();
        return "input";
    }

    public String execute() throws Exception {
        SecurityType security;
        ConfigDocument.Config config = this.rootConfig.getConfig();
        RawPolicyType policyType = config.isSetSecurity() ? ((security = config.getSecurity()).isSetRawPolicy() ? security.getRawPolicy() : security.addNewRawPolicy()) : config.addNewSecurity().addNewRawPolicy();
        policyType.setPolicy(RawPolicyType.Policy.Enum.forString(this.newPolicy.name()));
        this.rootConfig.saveConfig();
        return "success";
    }

    public DownloadPolicy getDownloadPolicy() {
        return this.policy;
    }

    public Iterable<PolicyDescription> getPolicyDescriptions() {
        return Arrays.asList(PolicyDescription.values());
    }

    public void setNewPolicy(String newPolicy) {
        try {
            this.newPolicy = DownloadPolicy.valueOf(newPolicy);
        }
        catch (IllegalArgumentException e2) {
            this.newPolicy = DownloadPolicy.Smart;
        }
    }

    public void setRootConfig(RootConfig rootConfig) {
        this.rootConfig = rootConfig;
    }

    public void setFisheyeDownloadPolicyProvider(FisheyeDownloadPolicyProvider fisheyeDownloadPolicyProvider) {
        this.fisheyeDownloadPolicyProvider = fisheyeDownloadPolicyProvider;
    }
}

