/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.atlassian.fecru.page.OnePageRequest;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.AdminUserConfig;
import com.cenqua.fisheye.user.GroupInfo;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.cenqua.fisheye.user.GroupSearchCriteria;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.admin.util.AdminActionUtils;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import com.opensymphony.xwork.ActionSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class BaseAdminAction
extends ActionSupport
implements ServletRequestAware {
    @Resource
    private CommitterUserMappingManager committerUserMappingManager;
    @Resource
    protected UserManager userManager;
    @Resource
    protected GroupMembershipManager groupMembershipManager;
    @Resource
    protected RepositoryManager repositoryManager;
    @Resource
    protected RootConfig rootConfig;
    @Resource
    private EffectiveUserProvider effectiveUserProvider;
    @Resource
    protected AdminUserConfig adminUserConfig;
    private Map<String, GroupInfo> groupInfos;
    private HttpServletRequest request;

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public LicenseInfo getLicense() {
        return AppConfig.getsConfig().getLicense();
    }

    public Map<String, RepositoryHandle> getRepHandleMap() {
        return this.repositoryManager.getHandleMap();
    }

    public Collection<GroupInfo> getGroupInfos() {
        return this.getGroupInfoMap().values();
    }

    public Map<String, GroupInfo> getGroupInfoMap() {
        if (this.groupInfos == null) {
            try {
                this.groupInfos = Maps.uniqueIndex((Iterable)this.userManager.searchGroups(GroupSearchCriteria.create(), OnePageRequest.createNoLimit()).getValues(), GroupInfo::getName);
            }
            catch (DbException e2) {
                Logs.APP_LOG.warn((Object)"Problem getting groups", (Throwable)e2);
                this.groupInfos = Collections.emptyMap();
            }
        }
        return this.groupInfos;
    }

    public Collection<String> getGroupNames() {
        return this.getGroupInfoMap().keySet();
    }

    protected UserManager getUserManager() {
        return this.userManager;
    }

    public List getFieldErrors(String fieldKey) {
        Object errors;
        if (this.getFieldErrors() != null && (errors = this.getFieldErrors().get(fieldKey)) instanceof List) {
            return (List)errors;
        }
        return null;
    }

    protected CommitterUserMappingManager getUserMappingManager() {
        return this.committerUserMappingManager;
    }

    protected HttpServletRequest getRequest() {
        return this.request;
    }

    public final ConfigDocument.Config getCfg() {
        return AdminActionUtils.getCfg(this, this.effectiveUserProvider, this.rootConfig);
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        return super.execute();
    }

    protected void addActionErrorAndLogWarning(String message, Throwable throwable) {
        this.addActionErrorAndLogWarning(message, message, throwable);
    }

    protected void addActionErrorAndLogWarning(String message, String logMessage, Throwable throwable) {
        Logs.APP_LOG.warn((Object)logMessage, throwable);
        this.addActionError(String.format("%s. %s. Please check the system logs for details.", StringUtils.stripEnd((String)message, (String)"."), StringUtils.stripEnd((String)Throwables.getRootCause((Throwable)throwable).getMessage(), (String)".")));
    }
}

