/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.logging.Logs;
import com.google.common.base.Strings;
import org.eclipse.jetty.server.Request;

public class WebServerUtils {
    public static void customizeImpl(Request request, String mProxyScheme, int mProxyPort, String mProxyHost) {
        String scheme = Strings.isNullOrEmpty((String)mProxyScheme) ? request.getScheme() : mProxyScheme;
        String host = request.getServerName();
        int port = request.getServerPort();
        try {
            String hostInfo = request.getHeader("X-Forwarded-Host");
            if (hostInfo != null) {
                int index = hostInfo.indexOf(58);
                if (index == -1) {
                    host = hostInfo;
                    port = WebServerUtils.getDefaultPort(scheme);
                } else {
                    host = hostInfo.substring(0, index);
                    try {
                        port = Integer.parseInt(hostInfo.substring(index + 1));
                    }
                    catch (NumberFormatException e2) {
                        port = WebServerUtils.getDefaultPort(scheme);
                    }
                }
            }
        }
        catch (RuntimeException e3) {
            Logs.APP_LOG.warn((Object)"unexpected error parsing http header", (Throwable)e3);
        }
        if (mProxyPort > 0) {
            port = mProxyPort;
        }
        if (!Strings.isNullOrEmpty((String)mProxyHost)) {
            host = mProxyHost;
        }
        request.setScheme(scheme);
        request.setServerName(host);
        request.setServerPort(port);
    }

    private static int getDefaultPort(String scheme) {
        return scheme.equalsIgnoreCase("https") ? 443 : 80;
    }
}

