/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.fisheye.web.NetworkLocation;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.Ajp13ServerType;
import com.cenqua.fisheye.config1.HttpServerType;
import com.cenqua.fisheye.config1.SslServerType;
import com.cenqua.fisheye.config1.WebServerType;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.io.ZipHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.web.admin.util.SSLUtils;
import com.cenqua.fisheye.web.jetty.FishEyeWebApplicationContext;
import com.cenqua.fisheye.web.jetty.ProxyInfo;
import com.cenqua.fisheye.web.jetty.ProxyPassingSelectChannelConnector;
import com.cenqua.fisheye.web.jetty.ProxyPassingSslSocketConnector;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.management.MBeanServer;
import org.eclipse.jetty.ajp.Ajp13SocketConnector;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class WebServer {
    private final Server mServer;
    private final List<String> desc = new ArrayList<String>();
    private final FishEyeWebApplicationContext webapp;
    private final LocalConnector jspConnector = new LocalConnector();
    private File webAppLocation;
    private File instanceDir;
    private boolean instanceSameAsHome;
    private File tempDir;

    public WebServer() throws Exception {
        this(AppConfig.getsConfig(), AppConfig.getWebAppLocation(), AppConfig.getInstanceDir(), AppConfig.getTempDir());
    }

    protected WebServer(RootConfig rootConfig, File webAppLocation, File instanceDir, File tempDir) throws Exception {
        this.webAppLocation = webAppLocation;
        this.instanceDir = instanceDir;
        this.instanceSameAsHome = IOHelper.isSameFile(webAppLocation, instanceDir);
        this.tempDir = tempDir;
        WebServerType wsConfig = rootConfig.getConfig().getWebServer();
        String webcontext = "/";
        this.mServer = new Server();
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMaxThreads(wsConfig.getMaxThreads().intValue());
        threadPool.setMinThreads(wsConfig.getMinThreads().intValue());
        this.mServer.setThreadPool((ThreadPool)threadPool);
        if (wsConfig.isSetContext()) {
            webcontext = WebServer.cleanWebContext(wsConfig.getContext());
        }
        if (FishEyeSysProps.jettyJmxEnabled) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            MBeanContainer mBeanContainer = new MBeanContainer(mBeanServer);
            this.mServer.getContainer().addEventListener((Container.Listener)mBeanContainer);
            mBeanContainer.start();
        }
        this.mServer.addConnector((Connector)this.jspConnector);
        if (wsConfig.isSetHttp()) {
            this.addHTTPListener(wsConfig.getHttp());
        }
        if (wsConfig.isSetSsl()) {
            this.addSSLListener(wsConfig.getSsl());
        }
        if (wsConfig.isSetAjp13()) {
            this.addAJP13Listener(wsConfig.getAjp13());
        }
        HandlerCollection handlers = new HandlerCollection();
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        DefaultHandler defaultHandler = new DefaultHandler();
        defaultHandler.setServeIcon(false);
        handlers.setHandlers(new Handler[]{contexts, defaultHandler, requestLogHandler});
        this.mServer.setHandler((Handler)handlers);
        this.webapp = new FishEyeWebApplicationContext((HandlerCollection)contexts, this.getWebAppLocation().getPath(), webcontext);
        this.webapp.setCompactPath(true);
        this.copyJettySystemProperties(this.webapp.getInitParams());
        this.webapp.getInitParams().put("org.eclipse.jetty.servlet.Default.gzip", "true");
        this.webapp.getInitParams().put("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        this.webapp.setMaxFormContentSize(Integer.getInteger("org.eclipse.jetty.server.Request.maxFormContentSize", 3000000));
        if (!this.isInstanceSameAsHome()) {
            File source;
            String contentOverride = Strings.emptyToNull((String)System.getProperty("fecru.content.dir.override"));
            if (contentOverride != null) {
                source = new File(contentOverride).getCanonicalFile();
                Logs.APP_LOG.info((Object)"Using overridden content path");
            } else {
                File inst = this.getInstanceDir().getCanonicalFile();
                source = new File(inst, "content").getCanonicalFile();
            }
            Logs.APP_LOG.info((Object)("Adding secondary content dir of " + source));
            this.webapp.setCustomContentDir(source);
        }
        File tmpDir = new File(this.getTmpDir(), "web");
        tmpDir.mkdirs();
        WebServer.extractPrecompiledClasses(this.getJspClassesDir(tmpDir));
        this.webapp.setTempDirectory(tmpDir);
        this.webapp.getServletHandler().setFilterChainsCached(false);
    }

    private File getTmpDir() {
        return this.tempDir;
    }

    private boolean isInstanceSameAsHome() {
        return this.instanceSameAsHome;
    }

    private File getInstanceDir() {
        return this.instanceDir;
    }

    private File getWebAppLocation() {
        return this.webAppLocation;
    }

    private void addSSLListener(SslServerType ssl) throws IOException, UnknownHostException {
        String bind = ssl.getBind();
        String keyStorePath = this.getStorePath(ssl.getKeystore(), "keystore");
        String truststorePath = this.getStorePath(ssl.getTruststore(), "truststore");
        String keystorePassword = ssl.getKeystorePassword();
        String truststorePassword = ssl.getTruststorePassword();
        this.checkPassword(keyStorePath, keystorePassword, "keystore");
        this.checkPassword(truststorePath, truststorePassword, "truststore");
        ProxyInfo proxyInfo = new ProxyInfo(ssl.getProxyInfo());
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(keyStorePath);
        sslContextFactory.setKeyManagerPassword(keystorePassword);
        sslContextFactory.setTrustStore(truststorePath);
        sslContextFactory.setTrustStorePassword(truststorePassword);
        sslContextFactory.setNeedClientAuth(ssl.isSetClientAuth() && ssl.getClientAuth());
        if (ssl.isSetExcludeCipherSuites() && ssl.getExcludeCipherSuites().sizeOfCipherSuiteArray() > 0) {
            sslContextFactory.setExcludeCipherSuites(ssl.getExcludeCipherSuites().getCipherSuiteArray());
        }
        if (ssl.isSetIncludeCipherSuites() && ssl.getIncludeCipherSuites().sizeOfCipherSuiteArray() > 0) {
            sslContextFactory.setIncludeCipherSuites(ssl.getIncludeCipherSuites().getCipherSuiteArray());
        }
        if (ssl.isSetExcludeProtocols() && ssl.getExcludeProtocols().sizeOfProtocolArray() > 0) {
            sslContextFactory.setExcludeProtocols(ssl.getExcludeProtocols().getProtocolArray());
        }
        if (ssl.isSetIncludeProtocols() && ssl.getIncludeProtocols().sizeOfProtocolArray() > 0) {
            sslContextFactory.setIncludeProtocols(ssl.getIncludeProtocols().getProtocolArray());
        }
        ProxyPassingSslSocketConnector connector = new ProxyPassingSslSocketConnector(sslContextFactory, proxyInfo);
        this.setupBind((Connector)connector, bind);
        this.setupCustomBufferHeaderSize((Connector)connector);
        this.mServer.addConnector((Connector)connector);
        this.desc.add(bind + " (https)");
    }

    private void checkPassword(String store, String password, String type) throws IOException {
        if (!SSLUtils.isCorrectKeystorePassword(store, password)) {
            throw new IOException(String.format("Password for [%s] is incorrect. Please check the '%s-password' attribute in the <ssl> element in config.xml.", store, type));
        }
    }

    private String getStorePath(String store, String type) throws IOException {
        File file = new File(store);
        if (!file.isAbsolute() && !(file = new File(this.getInstanceDir(), store)).exists()) {
            file = new File(AppConfig.getAppHome(), store);
        }
        String path = file.getPath();
        if (!file.exists()) {
            throw new IOException(String.format("Cannot find the file [%s]. Please check the '%s' attribute in the <ssl> element in config.xml", path, type));
        }
        return path;
    }

    private void copyJettySystemProperties(Map initParams) {
        Enumeration<?> names = System.getProperties().propertyNames();
        while (names.hasMoreElements()) {
            String prop = (String)names.nextElement();
            if (!prop.startsWith("org.eclipse.jetty")) continue;
            String val = System.getProperty(prop);
            Logs.APP_LOG.info((Object)("using jetty system property " + prop + " " + val));
            initParams.put(prop, val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractPrecompiledClasses(File destDir) throws IOException {
        File zip = WebServer.getJspPrecompZip();
        if (!zip.isFile()) {
            return;
        }
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(zip));
            int count = ZipHelper.unzip(in, destDir, false);
            if (count != 0) {
                Logs.APP_LOG.info((Object)("Extracted " + count + " pre-compiled jsp classes to " + destDir));
            }
        }
        catch (Throwable throwable) {
            IOHelper.close(in);
            throw throwable;
        }
        IOHelper.close(in);
    }

    private static File getJspPrecompZip() {
        return new File(AppConfig.getAppHome(), "lib/jsp_pre.zip");
    }

    private void addAJP13Listener(Ajp13ServerType ajp) throws UnknownHostException, IllegalArgumentException {
        Ajp13SocketConnector connector = new Ajp13SocketConnector();
        this.setupBind((Connector)connector, ajp.getBind());
        this.mServer.addConnector((Connector)connector);
        this.desc.add(ajp.getBind() + " (ajp13)");
    }

    private void addHTTPListener(HttpServerType http) throws UnknownHostException, IllegalArgumentException {
        ProxyInfo proxyInfo = new ProxyInfo(http);
        ProxyPassingSelectChannelConnector connector = new ProxyPassingSelectChannelConnector(proxyInfo);
        this.setupBind((Connector)connector, http.getBind());
        this.setupCustomBufferHeaderSize((Connector)connector);
        if (FishEyeSysProps.jettyJmxEnabled) {
            connector.setStatsOn(true);
        }
        this.mServer.addConnector((Connector)connector);
        this.desc.add(http.getBind() + " (http)");
    }

    private void setupCustomBufferHeaderSize(Connector connector) {
        String requestBufferSize;
        String responseHeaderSize;
        String headerBufferSize = System.getProperty("jetty.http.headerbuffersize");
        if (headerBufferSize != null) {
            try {
                connector.setRequestHeaderSize(Integer.parseInt(headerBufferSize));
            }
            catch (NumberFormatException e2) {
                Logs.APP_LOG.warn((Object)("Could not parse jetty.http.headerbuffersize: " + headerBufferSize));
            }
        }
        if ((responseHeaderSize = System.getProperty("jetty.http.responseHeaderSize")) != null) {
            try {
                connector.setResponseHeaderSize(Integer.parseInt(responseHeaderSize));
            }
            catch (NumberFormatException e3) {
                Logs.APP_LOG.warn((Object)("Could not parse jetty.http.responseHeaderSize: " + responseHeaderSize));
            }
        }
        if ((requestBufferSize = System.getProperty("jetty.http.requestbuffersize")) != null) {
            try {
                connector.setRequestBufferSize(Integer.parseInt(requestBufferSize));
            }
            catch (NumberFormatException e4) {
                Logs.APP_LOG.warn((Object)("Could not parse jetty.http.requestbuffersize: " + requestBufferSize));
            }
        }
    }

    private void setupBind(Connector connector, String bindSpec) throws UnknownHostException, IllegalArgumentException {
        NetworkLocation bind = new NetworkLocation(bindSpec);
        if (!bind.isWildcard()) {
            connector.setHost(bind.getHost());
        }
        connector.setPort(bind.getPort());
    }

    public void start() throws Exception {
        this.mServer.start();
    }

    public void stop() {
        try {
            this.mServer.stop();
        }
        catch (Exception e2) {
            Logs.APP_LOG.info((Object)"problem closing webserver", (Throwable)e2);
        }
    }

    public void flushContentAndJsps() throws IOException {
        File tmp = this.webapp.getTempDirectory();
        IOHelper.recursiveDelete(tmp, 20, false);
        WebServer.extractPrecompiledClasses(this.getJspClassesDir(tmp));
    }

    @Nonnull
    protected File getJspClassesDir(File tmp) {
        return new File(tmp, "jsp");
    }

    private static String cleanWebContext(String ctx) {
        if (ctx.endsWith("*")) {
            ctx = ctx.substring(0, ctx.length() - 1);
        }
        if (ctx.endsWith("/")) {
            ctx = ctx.substring(0, ctx.length() - 1);
        }
        if (ctx.equals("")) {
            return "/";
        }
        if (!ctx.startsWith("/")) {
            ctx = "/" + ctx;
        }
        return ctx;
    }

    public String getDesc() {
        return String.join((CharSequence)", ", this.desc);
    }

    public File getCustomContentDir() {
        return this.webapp.getCustomContentDir();
    }

    public File getTempDir() {
        return this.webapp.getTempDirectory();
    }

    @VisibleForTesting
    Server getServer() {
        return this.mServer;
    }
}

