/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.fisheye.bucket.BreakdownOption;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.web.CommandString;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import com.cenqua.fisheye.web.util.WayBackUrlEncoder;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class WaybackSpecChart
extends WaybackSpec {
    private Map<Params, ParamValue> params = new LinkedHashMap<Params, ParamValue>();
    public static final int DEFAULT_MAX_ITEMS = 10;
    public static final String CHART_DEFAULT = "Line";
    public static final String STACK_DEFAULT = "None";
    public static final String YAXIS_DEFAULT = "Full";
    private final DateFormat dateFormat = WaybackSpecChart.createDateFormatter();

    private static DateFormat createDateFormatter() {
        TimeZone tz = TimeZone.getDefault();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        dateFormat.setTimeZone(tz);
        return dateFormat;
    }

    private <V> void setParamValue(Params param, V newValue) {
        if (newValue == null) {
            this.params.remove((Object)param);
        } else {
            ParamValue value = this.params.get((Object)param);
            if (value == null) {
                try {
                    value = (ParamValue)param.type.newInstance();
                }
                catch (InstantiationException e2) {
                    Logs.APP_LOG.debug((Object)"Error parsing parameters in WaybackSpecChart", (Throwable)e2);
                }
                catch (IllegalAccessException e3) {
                    Logs.APP_LOG.debug((Object)"Error parsing parameters in WaybackSpecChart", (Throwable)e3);
                }
                this.params.put(param, value);
            }
            if (value != null) {
                value.setValue(newValue);
                value.setParam(param);
            }
        }
    }

    public <V> V getParamValue(Params param) {
        ParamValue value = this.params.get((Object)param);
        if (value != null) {
            return value.getValue();
        }
        return null;
    }

    private void setDate(String dateStr, Params param) {
        try {
            this.setParamValue(param, this.dateFormat.parse(dateStr));
        }
        catch (ParseException e2) {
            Logs.APP_LOG.debug((Object)("Error formatting date string " + dateStr), (Throwable)e2);
        }
    }

    public void setDate1(String dateStr) {
        this.setDate(dateStr, Params.DATE1);
    }

    public void setDate1(long date) {
        this.setParamValue(Params.DATE1, new Date(date));
    }

    public void setDate2(String dateStr) {
        this.setDate(dateStr, Params.DATE2);
    }

    public void setDate2(long date) {
        this.setParamValue(Params.DATE2, new Date(date));
    }

    @Override
    public String getUrlCommandParams() {
        return this.getUrlCommandParams(true);
    }

    @Override
    public String getUrlCommandParams(boolean includeBranchesAndTags) {
        StringBuffer buf = new StringBuffer(super.getUrlCommandParams(includeBranchesAndTags));
        for (ParamValue paramValue : this.params.values()) {
            if (paramValue == null) continue;
            paramValue.appendUrlString(buf, ",");
        }
        return buf.toString();
    }

    @Override
    public String getDisplayString() {
        StringBuffer buf = new StringBuffer(super.getDisplayString());
        for (ParamValue paramValue : this.params.values()) {
            if (paramValue == null) continue;
            paramValue.appendDisplayString(buf, ",");
        }
        return buf.toString();
    }

    @Override
    public String removeWbFromQueryString(String queryString) {
        for (Params params : Params.values()) {
            queryString = WaybackSpecChart.removeParamFromQueryString(params.wbString, queryString);
        }
        return super.removeWbFromQueryString(queryString);
    }

    public static WaybackSpecChart fromRequest(HttpServletRequest req) {
        WaybackSpecChart wb = new WaybackSpecChart();
        WaybackSpec.fromRequest(req, wb);
        for (Params params : Params.values()) {
            WaybackSpecChart.fromRequest(req, wb, params);
        }
        return wb;
    }

    private static void fromRequest(HttpServletRequest req, WaybackSpecChart wb, Params params) {
        if (params.type == StringListParam.class) {
            String[] vals = req.getParameterValues(params.wbString);
            if (!WaybackSpecChart.isEmpty(vals)) {
                ArrayList<String> list = new ArrayList<String>();
                for (String val : vals) {
                    if (val == null || val.length() == 0) continue;
                    list.add(val);
                }
                if (list.size() > 0) {
                    wb.setParamValue(params, list);
                }
            }
        } else {
            String wbtype = req.getParameter(params.wbString);
            if (!StringUtils.isBlank((String)wbtype)) {
                wb.setParamValue(params, params.getObject(wbtype));
            }
        }
    }

    public void setMaxItems(String s2) {
        try {
            this.setParamValue(Params.MAXITEMS, Integer.parseInt(s2));
        }
        catch (NumberFormatException e2) {
            Logs.APP_LOG.debug((Object)("Could not parse to integer maxItems value " + s2));
            this.params.remove((Object)Params.MAXITEMS);
        }
    }

    private static boolean isEmpty(String[] wbbr) {
        return wbbr == null || wbbr.length == 0 || wbbr.length == 1 && wbbr[0].trim().length() == 0;
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        WaybackSpecChart that = (WaybackSpecChart)o2;
        if (this.params.size() != that.params.size() || !this.params.keySet().containsAll(that.params.keySet())) {
            return false;
        }
        for (Params params : Params.values()) {
            if (this.equalOrBothNull(this.getParamValue(params), that.getParamValue(params))) continue;
            return false;
        }
        return true;
    }

    private boolean equalOrBothNull(Object a2, Object b2) {
        return a2 == null ? b2 == null : a2.equals(b2);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        for (Params params : Params.values()) {
            Object p2 = this.getParamValue(params);
            result = 29 * result + (p2 != null ? p2.hashCode() : 0);
        }
        return result;
    }

    public static WaybackSpecChart fromPathInfo(FishEyePathInfo pi) {
        return WaybackSpecChart.fromCommandString(pi.getCommandString());
    }

    public static WaybackSpecChart fromCommandString(CommandString cs) {
        List<String> vals;
        if (cs == null) {
            return null;
        }
        WaybackSpecChart wb = new WaybackSpecChart();
        boolean okay = false;
        String s2 = cs.getCommandParam("br");
        if (s2 != null) {
            wb.setBranch(s2);
            okay = true;
        }
        if ((s2 = cs.getCommandParam("tag")) != null) {
            wb.setTag(s2);
            okay = true;
        }
        if ((vals = cs.getCommandParams("author")) != null) {
            wb.setAuthors(vals);
            okay = true;
        }
        for (Params param : Params.values()) {
            WaybackSpecChart.fromCommandString(cs, param, wb);
        }
        return okay || wb.params.size() > 0 ? wb : null;
    }

    private static void fromCommandString(CommandString cs, Params params, WaybackSpecChart wb) {
        if (params.type == StringListParam.class) {
            List<String> vals = cs.getCommandParams(params.display);
            if (vals != null) {
                wb.setParamValue(params, vals);
            }
        } else {
            String s2 = cs.getCommandParam(params.display);
            if (s2 != null) {
                wb.setParamValue(params, params.getObject(s2));
            }
        }
    }

    @Override
    public CommandString toCommandString() {
        ListMultimap<String, String> params = super.getCommandParams();
        for (ParamValue paramValue : this.params.values()) {
            paramValue.toCommandString((Multimap<String, String>)params);
        }
        return new CommandString(null, params);
    }

    public String getChartType() {
        String result = (String)this.getParamValue(Params.CHARTTYPE);
        if (result != null) {
            return result;
        }
        return CHART_DEFAULT;
    }

    public void setChartType(String chartType) {
        this.setParamValue(Params.CHARTTYPE, chartType);
    }

    public String getStackType() {
        String result = (String)this.getParamValue(Params.STACKTYPE);
        if (result != null) {
            return result;
        }
        return STACK_DEFAULT;
    }

    public void setStackType(String stackType) {
        this.setParamValue(Params.STACKTYPE, stackType);
    }

    public String getDate1Str() {
        Date date = (Date)this.getParamValue(Params.DATE1);
        if (date != null) {
            return this.dateFormat.format(date);
        }
        return null;
    }

    public String getDate2Str() {
        Date date = (Date)this.getParamValue(Params.DATE2);
        if (date != null) {
            return this.dateFormat.format(date);
        }
        return null;
    }

    public Date getDate1() {
        return (Date)this.getParamValue(Params.DATE1);
    }

    public Date getDate2() {
        return (Date)this.getParamValue(Params.DATE2);
    }

    public List<String> getExtn() {
        return this.getExtns();
    }

    public void setExtns(String[] extns) {
        this.setExtns(Arrays.asList(extns));
    }

    public void setExtns(List<String> extns) {
        this.setParamValue(Params.EXTNS, extns);
    }

    public String getDate2String() {
        if (this.isPie()) {
            return "Date";
        }
        return "End Date";
    }

    public int getMaxItems() {
        Integer maxItems = (Integer)this.getParamValue(Params.MAXITEMS);
        if (maxItems != null) {
            return maxItems;
        }
        return 10;
    }

    public BreakdownOption getBreakdownOption() {
        BreakdownOption option = BreakdownOption.getBreakdownOption(this.getStackType());
        if (option == null) {
            option = BreakdownOption.NONE;
        }
        return option;
    }

    public boolean isArea() {
        return this.getChartType() == null || this.getChartType().equalsIgnoreCase("Area");
    }

    public boolean isLine() {
        return this.getChartType() != null && this.getChartType().equalsIgnoreCase(CHART_DEFAULT);
    }

    public boolean isPie() {
        return this.getChartType() != null && this.getChartType().equalsIgnoreCase("Pie");
    }

    public List<String> getAuthors() {
        return (List)this.getParamValue(Params.AUTHORS);
    }

    public void setAuthors(List<String> authors) {
        this.setParamValue(Params.AUTHORS, authors);
    }

    public void setAuthors(String[] authors) {
        ArrayList<String> auths = new ArrayList<String>();
        for (String author : authors) {
            if (StringUtils.isBlank((String)author)) continue;
            auths.add(author);
        }
        this.setAuthors(auths);
    }

    public String getAxisType() {
        String result = (String)this.getParamValue(Params.YAXISTYPE);
        if (result != null) {
            return result;
        }
        return YAXIS_DEFAULT;
    }

    public void setAxisType(String yAxisType) {
        this.setParamValue(Params.YAXISTYPE, yAxisType);
    }

    public void setDate1Str(String date1Str) {
        this.setDate(date1Str, Params.DATE1);
    }

    public void setDate2Str(String date2Str) {
        this.setDate(date2Str, Params.DATE2);
    }

    public void setMaxItems(Integer maxItems) {
        this.setParamValue(Params.MAXITEMS, maxItems);
    }

    public List<String> getExtns() {
        return (List)this.getParamValue(Params.EXTNS);
    }

    public boolean isChange() {
        return this.getChartType() != null && this.getChartType().equalsIgnoreCase("Change");
    }

    public static class StringListParam
    extends ParamValue<List<String>> {
        @Override
        public void appendDisplayString(StringBuffer buf, String sep) {
            for (String val : (List)this.value) {
                buf.append(buf.length() == 0 ? "" : sep);
                buf.append(this.param.display).append("=").append(ExpressionUtil.escapeString(val));
            }
        }

        @Override
        public void appendUrlString(StringBuffer buf, String sep) {
            for (String val : (List)this.value) {
                buf.append(buf.length() == 0 ? "" : sep);
                buf.append(this.param.display).append("=").append(WayBackUrlEncoder.commandUrlEncode(val));
            }
        }
    }

    public static class DateParam
    extends ParamValue<Date> {
        @Override
        protected String toUrlString() {
            DateFormat dateFormat = WaybackSpecChart.createDateFormatter();
            return dateFormat.format((Date)this.value);
        }
    }

    public static class ParamValue<V> {
        protected V value;
        protected Params param;
        private static Class STRING_CLASS = new ParamValue().getClass();
        private static Class INTEGER_CLASS = new ParamValue().getClass();

        public void setValue(V value) {
            this.value = value;
        }

        public void setParam(Params param) {
            this.param = param;
        }

        public void appendDisplayString(StringBuffer buf, String sep) {
            buf.append(buf.length() == 0 ? "" : sep);
            buf.append(this.param.display).append("=").append(ExpressionUtil.escapeString(this.value.toString()));
        }

        public void appendUrlString(StringBuffer buf, String sep) {
            buf.append(buf.length() == 0 ? "" : sep);
            buf.append(this.param.display).append("=").append(WayBackUrlEncoder.commandUrlEncode(this.toUrlString()));
        }

        protected String toUrlString() {
            return this.value.toString();
        }

        public V getValue() {
            return this.value;
        }

        public void toCommandString(Multimap<String, String> params) {
            params.put((Object)this.param.display, (Object)this.value.toString());
        }

        static /* synthetic */ Class access$300() {
            return STRING_CLASS;
        }

        static /* synthetic */ Class access$400() {
            return INTEGER_CLASS;
        }
    }

    public static enum Params {
        CHARTTYPE("charttype", "wbtype", ParamValue.access$300()),
        STACKTYPE("stacktype", "wbstack", ParamValue.access$300()),
        YAXISTYPE("yaxistype", "wbyaxis", ParamValue.access$300()),
        DATE1("date1", "wbdate1", DateParam.class),
        DATE2("date2", "wbdate2", DateParam.class),
        MAXITEMS("maxitems", "wbmaxitems", ParamValue.access$400()),
        AUTHORS("author", "wbauthors", StringListParam.class),
        EXTNS("extn", "wbextn", StringListParam.class);

        private final String display;
        private final String wbString;
        private final Class type;

        private Params(String display, String wbString, Class type) {
            this.display = display;
            this.wbString = wbString;
            this.type = type;
        }

        public Object getObject(String string) {
            if (this.type == new ParamValue().getClass()) {
                return string;
            }
            if (this.type == new ParamValue().getClass()) {
                return new Integer(string);
            }
            if (this.type == DateParam.class) {
                if (!"(YYYY-MM-DD)".equals(string)) {
                    try {
                        DateFormat dateFormat = WaybackSpecChart.createDateFormatter();
                        return dateFormat.parse(string);
                    }
                    catch (ParseException e2) {
                        Logs.APP_LOG.debug((Object)("Error parsing date string " + string), (Throwable)e2);
                    }
                }
                return null;
            }
            if (this.type == StringListParam.class) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(string);
                return list;
            }
            return string;
        }
    }
}

