/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.web.CommandString;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import com.cenqua.fisheye.web.util.WayBackUrlEncoder;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class WaybackSpec
implements Serializable {
    public static final String URL_TOKEN_PREFIX = "~";
    public static final String BRANCH_URL_TOKEN = "br=";
    private String branch;
    private String tag;
    private String dateStr;
    private String author;
    private String user;
    private long date;
    private String commentSearchText = null;
    private String fileName = null;
    private String fileExtension = null;
    private String startDateStr = null;
    private String endDateStr = null;
    private long startTime;
    private long endTime;
    private static final String START_DATE = "startDate";
    private static final String END_DATE = "endDate";
    private static final String COMMENT_TEXT = "commentText";
    private static final String FILENAME = "fileName";
    private static final String FILE_EXTENSION = "fileExtension";
    private static final String BRANCH = "branchConstraint";
    private static final String COMPULSORY_COMMITTER = "committerConstraint";
    private static final String DIRECTEDTOROOT = "dtr";
    private static final String MULTIPLEBRANCHES = "mbrs";
    private Map<String, Boolean> volatileParams = new HashMap<String, Boolean>();

    public boolean isDirectedToRoot() {
        Boolean dtr = this.volatileParams.get(DIRECTEDTOROOT);
        return dtr != null && dtr != false;
    }

    public void setDirectedToRoot(Boolean dtr) {
        this.volatileParams.put(DIRECTEDTOROOT, dtr);
    }

    public boolean isMultipleBranches() {
        Boolean mbrs = this.volatileParams.get(MULTIPLEBRANCHES);
        return mbrs != null && mbrs != false;
    }

    public void setMultipleBranches(Boolean mbrs) {
        this.volatileParams.put(MULTIPLEBRANCHES, mbrs);
    }

    public WaybackSpec() {
    }

    private WaybackSpec(WaybackSpec other) {
        this.author = other.author;
        this.user = other.user;
        this.branch = other.branch;
        this.commentSearchText = other.commentSearchText;
        this.date = other.date;
        this.dateStr = other.dateStr;
        this.endDateStr = other.endDateStr;
        this.endTime = other.endTime;
        this.fileExtension = other.fileExtension;
        this.fileName = other.fileName;
        this.startDateStr = other.startDateStr;
        this.startTime = other.startTime;
        this.tag = other.tag;
        this.volatileParams = ImmutableMap.copyOf(this.volatileParams);
    }

    public static WaybackSpec immutableCopyOf(WaybackSpec other) {
        return other == null ? null : new WaybackSpec(other){

            @Override
            public void setDirectedToRoot(Boolean dtr) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setMultipleBranches(Boolean mbrs) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setAuthor(String author) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setUser(String user) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setBranch(String branch) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setTag(String tag) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setDateStr(String dateStr) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setDate(long date) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setFileName(String fileName) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setFileExtension(String fileExtension) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setStartDateStr(String startDateStr) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setEndDateStr(String endDateStr) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setStartTime(long startTime) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setEndTime(long endTime) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getTag() {
        return this.tag;
    }

    public String getBranchOrTag() {
        if (!Strings.isNullOrEmpty((String)this.branch)) {
            return this.branch;
        }
        if (!Strings.isNullOrEmpty((String)this.tag)) {
            return this.tag;
        }
        return null;
    }

    public String getDateStr() {
        return this.dateStr;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setDateStr(String dateStr) {
        this.dateStr = dateStr;
    }

    public void setDate(long date) {
        this.date = date;
    }

    public boolean isTagSet() {
        return !StringUtils.isBlank((String)this.tag);
    }

    public boolean isBranchSet() {
        return !StringUtils.isBlank((String)this.branch);
    }

    public boolean matchesRevision(FileRevision info, boolean ignoreBranchAndTagConstraints) {
        boolean matches = true;
        if (this.branch != null && !ignoreBranchAndTagConstraints) {
            boolean bl = matches = info.getBranches() != null && info.getBranches().contains(this.branch) || this.branch.equals(info.getBranch()) || info.getBranchPoints().contains(this.branch);
        }
        if (this.author != null) {
            matches &= this.author.equalsIgnoreCase(info.getAuthor());
        }
        if (this.tag != null && !ignoreBranchAndTagConstraints) {
            matches &= info.getTags().contains(this.tag);
        }
        if (this.startDateStr != null || this.endDateStr != null) {
            if (this.startDateStr != null) {
                matches &= info.getDate() >= this.startTime;
            }
            if (this.endDateStr != null) {
                matches &= info.getDate() <= this.endTime;
            }
        } else if (this.dateStr != null) {
            matches &= info.getDate() <= this.date;
        }
        if (!Strings.isNullOrEmpty((String)this.commentSearchText) && !Strings.isNullOrEmpty((String)info.getComment())) {
            String comment = info.getComment().toLowerCase(Locale.US);
            String[] operands = this.commentSearchText.trim().toLowerCase(Locale.US).split("\\s+");
            boolean matchesComment = true;
            for (String operand : operands) {
                matchesComment &= comment.contains(operand);
            }
            matches &= matchesComment;
        }
        return matches;
    }

    public String getUrlCommandNoBranchOrTag() {
        String params = this.getUrlCommandParams(false);
        if (params.length() == 0) {
            return "";
        }
        return "/~" + params;
    }

    public String getUrlCommandBranchOrTag() {
        String params;
        StringBuilder buf = new StringBuilder();
        String sep = "";
        if (this.branch != null) {
            buf.append(sep);
            buf.append(BRANCH_URL_TOKEN).append(WayBackUrlEncoder.commandUrlEncode(this.branch));
            sep = ",";
        }
        if (this.tag != null) {
            buf.append(sep);
            buf.append("tag=").append(WayBackUrlEncoder.commandUrlEncode(this.tag));
        }
        if ((params = buf.toString()).length() == 0) {
            return "";
        }
        return "/~" + params;
    }

    public String getUrlCommand() {
        String params = this.getUrlCommandParams();
        if (params.length() == 0) {
            return "";
        }
        return "/~" + params;
    }

    public String getUrlCommandWithVolatileParams() {
        StringBuilder paramsBuilder = new StringBuilder(this.getUrlCommandParams());
        String sep = "";
        if (paramsBuilder.length() != 0) {
            sep = ",";
        }
        if (this.isDirectedToRoot()) {
            paramsBuilder.append(sep).append(DIRECTEDTOROOT).append("=true");
            sep = ",";
        }
        if (this.isMultipleBranches()) {
            paramsBuilder.append(sep).append(MULTIPLEBRANCHES).append("=true");
        }
        if (paramsBuilder.length() == 0) {
            return "";
        }
        return "/~" + paramsBuilder.toString();
    }

    public String getUrlCommandParams2() {
        return "," + this.getUrlCommandParams();
    }

    public String getUrlCommandParams() {
        return this.getUrlCommandParams(true);
    }

    public String getUrlCommandParams(boolean includeBranchesAndTags) {
        StringBuilder buf = new StringBuilder();
        String sep = "";
        if (includeBranchesAndTags && this.branch != null) {
            buf.append(sep);
            buf.append(BRANCH_URL_TOKEN).append(WayBackUrlEncoder.commandUrlEncode(this.branch));
            sep = ",";
        }
        if (this.author != null) {
            buf.append(sep);
            buf.append("author=").append(WayBackUrlEncoder.commandUrlEncode(this.author));
            sep = ",";
        }
        if (this.user != null) {
            buf.append(sep);
            buf.append("user=").append(WayBackUrlEncoder.commandUrlEncode(this.user));
            sep = ",";
        }
        if (includeBranchesAndTags && this.tag != null) {
            buf.append(sep);
            buf.append("tag=").append(WayBackUrlEncoder.commandUrlEncode(this.tag));
            sep = ",";
        }
        if (this.dateStr != null) {
            buf.append(sep);
            buf.append("date=").append(WayBackUrlEncoder.commandUrlEncode(this.dateStr));
            sep = ",";
        }
        if (this.fileExtension != null) {
            buf.append(sep);
            buf.append(FILE_EXTENSION).append("=").append(WayBackUrlEncoder.commandUrlEncode(this.fileExtension));
            sep = ",";
        }
        if (this.fileName != null) {
            buf.append(sep);
            buf.append(FILENAME).append("=").append(WayBackUrlEncoder.commandUrlEncode(this.fileName));
            sep = ",";
        }
        if (this.commentSearchText != null) {
            buf.append(sep);
            buf.append(COMMENT_TEXT).append("=").append(WayBackUrlEncoder.commandUrlEncode(this.commentSearchText));
            sep = ",";
        }
        if (this.startDateStr != null) {
            buf.append(sep);
            buf.append(START_DATE).append("=").append(WayBackUrlEncoder.commandUrlEncode(this.startDateStr));
            sep = ",";
        }
        if (this.endDateStr != null) {
            buf.append(sep);
            buf.append(END_DATE).append("=").append(WayBackUrlEncoder.commandUrlEncode(this.endDateStr));
        }
        return buf.toString();
    }

    public String getUrlCommandParamsBrowse() {
        StringBuilder buf = new StringBuilder();
        String sep = "";
        if (this.branch != null) {
            buf.append(sep);
            buf.append(BRANCH_URL_TOKEN).append(WayBackUrlEncoder.commandUrlEncode(this.branch));
            sep = ",";
        }
        if (this.author != null) {
            buf.append(sep);
            buf.append("author=").append(WayBackUrlEncoder.commandUrlEncode(this.author));
            sep = ",";
        }
        if (this.user != null) {
            buf.append(sep);
            buf.append("user=").append(WayBackUrlEncoder.commandUrlEncode(this.user));
            sep = ",";
        }
        if (this.tag != null) {
            buf.append(sep);
            buf.append("tag=").append(WayBackUrlEncoder.commandUrlEncode(this.tag));
            sep = ",";
        }
        if (this.dateStr != null) {
            buf.append(sep);
            buf.append("date=").append(WayBackUrlEncoder.commandUrlEncode(this.dateStr));
            sep = ",";
        }
        if (this.fileExtension != null) {
            buf.append(sep);
            buf.append(FILE_EXTENSION).append("=").append(WayBackUrlEncoder.commandUrlEncode(this.fileExtension));
            sep = ",";
        }
        if (this.fileName != null) {
            buf.append(sep);
            buf.append(FILENAME).append("=").append(WayBackUrlEncoder.commandUrlEncode(this.fileName));
            sep = ",";
        }
        if (this.commentSearchText != null) {
            buf.append(sep);
            buf.append(COMMENT_TEXT).append("=").append(WayBackUrlEncoder.commandUrlEncode(this.commentSearchText));
            sep = ",";
        }
        if (this.startDateStr != null) {
            buf.append(sep);
            buf.append(START_DATE).append("=").append(WayBackUrlEncoder.commandUrlEncode(this.startDateStr));
            sep = ",";
        }
        if (this.endDateStr != null) {
            buf.append(sep);
            buf.append(END_DATE).append("=").append(WayBackUrlEncoder.commandUrlEncode(this.endDateStr));
        }
        return buf.toString();
    }

    public String toString() {
        return this.getUrlCommandParams();
    }

    public boolean isNoOp() {
        return this.branch == null && this.author == null && this.user == null && this.tag == null && this.dateStr == null && this.commentSearchText == null && this.fileExtension == null && this.fileName == null && this.startDateStr == null && this.endDateStr == null;
    }

    public String getDisplayString() {
        StringBuilder buf = new StringBuilder();
        String sep = "";
        if (this.branch != null) {
            buf.append(sep);
            buf.append("branch=").append(ExpressionUtil.escapeString(this.branch));
            sep = ",";
        }
        if (this.author != null) {
            buf.append(sep);
            buf.append("author=").append(ExpressionUtil.escapeString(this.author));
            sep = ",";
        }
        if (this.user != null) {
            buf.append(sep);
            buf.append("user=").append(ExpressionUtil.escapeString(this.user));
            sep = ",";
        }
        if (this.tag != null) {
            buf.append(sep);
            buf.append("tag=").append(ExpressionUtil.escapeString(this.tag));
            sep = ",";
        }
        if (this.dateStr != null) {
            buf.append(sep);
            buf.append("date=").append(ExpressionUtil.escapeString(this.dateStr));
            sep = ",";
        }
        if (this.fileExtension != null) {
            buf.append(sep);
            buf.append(FILE_EXTENSION).append("=").append(ExpressionUtil.escapeString(this.fileExtension));
            sep = ",";
        }
        if (this.fileName != null) {
            buf.append(sep);
            buf.append(FILENAME).append("=").append(ExpressionUtil.escapeString(this.fileName));
            sep = ",";
        }
        if (this.commentSearchText != null) {
            buf.append(sep);
            buf.append(COMMENT_TEXT).append("=").append(ExpressionUtil.escapeString(this.commentSearchText));
            sep = ",";
        }
        if (this.startDateStr != null) {
            buf.append(sep);
            buf.append(START_DATE).append("=").append(ExpressionUtil.escapeString(this.startDateStr));
            sep = ",";
        }
        if (this.endDateStr != null) {
            buf.append(sep);
            buf.append(END_DATE).append("=").append(ExpressionUtil.escapeString(this.endDateStr));
        }
        return buf.toString();
    }

    public String removeWbFromQueryString(String queryString) {
        queryString = WaybackSpec.removeParamFromQueryString("wbjump", queryString);
        queryString = WaybackSpec.removeParamFromQueryString("wbbr", queryString);
        queryString = WaybackSpec.removeParamFromQueryString("wbtag", queryString);
        queryString = WaybackSpec.removeParamFromQueryString(BRANCH, queryString);
        queryString = WaybackSpec.removeParamFromQueryString(COMPULSORY_COMMITTER, queryString);
        queryString = WaybackSpec.removeParamFromQueryString(FILE_EXTENSION, queryString);
        queryString = WaybackSpec.removeParamFromQueryString(FILENAME, queryString);
        queryString = WaybackSpec.removeParamFromQueryString(COMMENT_TEXT, queryString);
        queryString = WaybackSpec.removeParamFromQueryString(START_DATE, queryString);
        queryString = WaybackSpec.removeParamFromQueryString(END_DATE, queryString);
        queryString = WaybackSpec.removeParamFromQueryString("wbdate", queryString);
        return queryString;
    }

    public static String removeParamFromQueryString(String param, String queryString) {
        if (!Strings.isNullOrEmpty((String)queryString)) {
            queryString = queryString.replaceAll("&" + param + "(=[^&]*)?(?=&|$)|^" + param + "(=[^&]*)?(&|$)|^" + param + "(=[^&]*)?", "");
        }
        return queryString;
    }

    public static WaybackSpec fromRequest(HttpServletRequest req) {
        return WaybackSpec.fromRequest(req, null);
    }

    public static WaybackSpec fromRequest(HttpServletRequest req, WaybackSpec wb) {
        TimeZone tz;
        long now;
        Long d2;
        String wbdate;
        String param;
        String wbtag;
        if (wb == null) {
            wb = new WaybackSpec();
        }
        if (!StringUtils.isBlank((String)(wbtag = req.getParameter("wbtag")))) {
            wb.setTag(wbtag.trim());
        }
        if (!StringUtils.isBlank((String)(param = req.getParameter("wbbr")))) {
            wb.setBranch(param.trim());
        } else {
            param = req.getParameter(BRANCH);
            if (!StringUtils.isBlank((String)param)) {
                wb.setBranch(param.trim());
            }
        }
        param = req.getParameter("wbauthor");
        if (!StringUtils.isBlank((String)param)) {
            wb.setAuthor(param.trim());
        } else {
            param = req.getParameter(COMPULSORY_COMMITTER);
            if (!StringUtils.isBlank((String)param)) {
                wb.setAuthor(param.trim());
            }
        }
        param = req.getParameter("wbuser");
        if (!StringUtils.isBlank((String)param)) {
            wb.setUser(param.trim());
        }
        if (!StringUtils.isBlank((String)(param = req.getParameter(FILE_EXTENSION)))) {
            wb.setFileExtension(param.trim());
        }
        if (!StringUtils.isBlank((String)(param = req.getParameter(FILENAME)))) {
            wb.setFileName(param.trim());
        }
        if (!StringUtils.isBlank((String)(param = req.getParameter(COMMENT_TEXT)))) {
            wb.setCommentSearchText(param.trim());
        }
        WaybackSpec.parseDate(wb, req.getParameter(START_DATE), true);
        WaybackSpec.parseDate(wb, req.getParameter(END_DATE), false);
        if (wb.getEndDateStr() == null) {
            WaybackSpec.parseDate(wb, req.getParameter("wbdate"), false);
        }
        if (!StringUtils.isBlank((String)(wbdate = req.getParameter("wbdate"))) && (d2 = DateHelper.parseDate(wbdate = wbdate.trim(), now = System.currentTimeMillis(), tz = AppConfig.getsConfig().getTimezone())) != null) {
            wb.setDateStr(wbdate);
            wb.setDate(d2);
        }
        return wb;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        WaybackSpec that = (WaybackSpec)o2;
        return this.equalOrBothNull(this.author, that.author) && this.equalOrBothNull(this.user, that.author) && this.equalOrBothNull(this.branch, that.branch) && this.equalOrBothNull(this.dateStr, that.dateStr) && this.equalOrBothNull(this.tag, that.tag) && this.endTime == that.endTime && this.startTime == that.startTime && this.equalOrBothNull(this.commentSearchText, that.commentSearchText) && this.equalOrBothNull(this.endDateStr, that.endDateStr) && this.equalOrBothNull(this.fileExtension, that.fileExtension) && this.equalOrBothNull(this.fileName, that.fileName) && this.equalOrBothNull(this.startDateStr, that.startDateStr);
    }

    private boolean equalOrBothNull(Object a2, Object b2) {
        return a2 != null ? a2.equals(b2) : b2 == null;
    }

    public int hashCode() {
        int result = this.branch != null ? this.branch.hashCode() : 0;
        result = 29 * result + (this.tag != null ? this.tag.hashCode() : 0);
        result = 29 * result + (this.dateStr != null ? this.dateStr.hashCode() : 0);
        result = 29 * result + (this.author != null ? this.author.hashCode() : 0);
        result = 29 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 29 * result + (this.commentSearchText != null ? this.commentSearchText.hashCode() : 0);
        result = 29 * result + (this.fileName != null ? this.fileName.hashCode() : 0);
        result = 29 * result + (this.fileExtension != null ? this.fileExtension.hashCode() : 0);
        result = 29 * result + (this.startDateStr != null ? this.startDateStr.hashCode() : 0);
        result = 29 * result + (this.endDateStr != null ? this.endDateStr.hashCode() : 0);
        result = 29 * result + (int)(this.startTime ^ this.startTime >>> 32);
        result = 29 * result + (int)(this.endTime ^ this.endTime >>> 32);
        return result;
    }

    public static WaybackSpec createWaybackSpec(FishEyePathInfo pi) {
        WaybackSpec wb = pi == null ? null : WaybackSpec.fromPathInfo(pi);
        return wb == null ? new WaybackSpec() : wb;
    }

    public static WaybackSpec fromPathInfo(FishEyePathInfo pi) {
        return WaybackSpec.fromCommandString(pi.getCommandString());
    }

    public static WaybackSpec fromCommandString(CommandString cs) {
        TimeZone tz;
        long now;
        Long d2;
        if (cs == null) {
            return null;
        }
        WaybackSpec wb = new WaybackSpec();
        String s2 = cs.getCommandParam("br");
        if (s2 == null) {
            s2 = cs.getCommandParam(BRANCH);
        }
        wb.setBranch(s2);
        s2 = cs.getCommandParam("author");
        if (s2 == null) {
            s2 = cs.getCommandParam(COMPULSORY_COMMITTER);
        }
        wb.setAuthor(s2);
        wb.setUser(cs.getCommandParam("user"));
        wb.setTag(cs.getCommandParam("tag"));
        s2 = cs.getCommandParam("date");
        if (s2 != null && (d2 = DateHelper.parseDate(s2, now = System.currentTimeMillis(), tz = AppConfig.getsConfig().getTimezone())) != null) {
            wb.setDateStr(s2);
            wb.setDate(d2);
        }
        wb.setCommentSearchText(cs.getCommandParam(COMMENT_TEXT));
        wb.setFileExtension(cs.getCommandParam(FILE_EXTENSION));
        wb.setFileName(cs.getCommandParam(FILENAME));
        WaybackSpec.parseDate(wb, cs.getCommandParam(START_DATE), true);
        WaybackSpec.parseDate(wb, cs.getCommandParam(END_DATE), false);
        if (wb.getEndDateStr() == null) {
            WaybackSpec.parseDate(wb, cs.getCommandParam("date"), false);
        }
        wb.setDirectedToRoot("true".equals(cs.getCommandParam(DIRECTEDTOROOT)));
        wb.setMultipleBranches("true".equals(cs.getCommandParam(MULTIPLEBRANCHES)));
        return wb.isEmpty() ? null : wb;
    }

    public CommandString toCommandString() {
        return new CommandString(null, this.getCommandParams());
    }

    public ListMultimap<String, String> getCommandParams() {
        ArrayListMultimap params = ArrayListMultimap.create();
        if (this.branch != null) {
            params.put((Object)"br", (Object)this.branch);
        }
        if (this.author != null) {
            params.put((Object)"author", (Object)this.author);
        }
        if (this.user != null) {
            params.put((Object)"user", (Object)this.user);
        }
        if (this.tag != null) {
            params.put((Object)"tag", (Object)this.tag);
        }
        if (this.dateStr != null) {
            params.put((Object)"date", (Object)this.dateStr);
        }
        if (this.commentSearchText != null) {
            params.put((Object)COMMENT_TEXT, (Object)this.commentSearchText);
        }
        if (this.fileExtension != null) {
            params.put((Object)FILE_EXTENSION, (Object)this.fileExtension);
        }
        if (this.fileName != null) {
            params.put((Object)FILENAME, (Object)this.fileName);
        }
        if (this.startDateStr != null) {
            params.put((Object)START_DATE, (Object)this.startDateStr);
        }
        if (this.endDateStr != null) {
            params.put((Object)END_DATE, (Object)this.endDateStr);
        }
        return params;
    }

    public String getCommentSearchText() {
        return this.commentSearchText;
    }

    public void setCommentSearchText(String commentSearchText) {
        this.commentSearchText = commentSearchText;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        if (fileExtension != null && fileExtension.startsWith(".")) {
            fileExtension = fileExtension.substring(1);
        }
        this.fileExtension = fileExtension;
    }

    public String getStartDateStr() {
        return this.startDateStr;
    }

    public void setStartDateStr(String startDateStr) {
        this.startDateStr = startDateStr;
    }

    public String getEndDateStr() {
        return this.endDateStr;
    }

    public void setEndDateStr(String endDateStr) {
        this.endDateStr = endDateStr;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    static boolean parseDate(WaybackSpec wb, String param, boolean isStart) {
        TimeZone tz;
        long now;
        Long d2;
        boolean success = false;
        if (!StringUtils.isBlank((String)param) && (d2 = DateHelper.parseDate(param = param.trim(), now = System.currentTimeMillis(), tz = AppConfig.getsConfig().getTimezone())) != null) {
            if (isStart) {
                if (!param.contains("T")) {
                    Calendar c2 = Calendar.getInstance();
                    c2.setTimeInMillis(d2);
                    c2.set(11, 0);
                    c2.set(12, 0);
                    c2.set(13, 0);
                    d2 = c2.getTimeInMillis();
                }
                wb.setStartDateStr(param);
                wb.setStartTime(d2);
            } else {
                if (!param.contains("T")) {
                    Calendar c3 = Calendar.getInstance();
                    c3.setTimeInMillis(d2);
                    c3.set(11, 23);
                    c3.set(12, 59);
                    c3.set(13, 59);
                    d2 = c3.getTimeInMillis();
                }
                wb.setEndDateStr(param);
                wb.setEndTime(d2);
            }
            success = true;
        }
        return success;
    }

    public boolean isEmpty() {
        return this.branch == null && this.tag == null && this.isEmptyWithoutBranchOrTag();
    }

    public boolean isEmptyWithoutBranchOrTag() {
        return this.dateStr == null && this.author == null && this.user == null && this.commentSearchText == null && this.fileName == null && this.fileExtension == null && this.startDateStr == null && this.endDateStr == null;
    }
}

