/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.util.HashUtils;
import com.cenqua.fisheye.web.CommandString;
import com.cenqua.fisheye.web.WaybackSpec;
import com.google.common.base.Preconditions;
import java.io.Serializable;

public class Watch
implements Serializable {
    private Long id;
    private FecruUser user;
    private String rep;
    private Path path;
    private WaybackSpec constraint;
    private long lastChecked;
    private RevInfoKey lastRevisionSent = null;
    private long cacheSerialOfLastRevisionSent = 1L;

    public Watch() {
    }

    public Watch(FecruUser user, String rep, Path path, WaybackSpec constraint) {
        this(user, rep, path, constraint, -1L, null);
    }

    public Watch(FecruUser user, String rep, Path path, WaybackSpec constraint, long lastChecked, RevInfoKey lastRevisionSent) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)rep);
        Preconditions.checkNotNull((Object)path);
        this.user = user;
        this.rep = rep;
        this.path = path;
        this.constraint = constraint;
        this.lastChecked = lastChecked;
        this.lastRevisionSent = lastRevisionSent;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getRep() {
        return this.rep;
    }

    public void setRep(String rep) {
        this.rep = rep;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public String getPathAsString() {
        return Watch.pathAsString(this.getPath());
    }

    private static String pathAsString(Path path) {
        return path != null ? path.getPath() : "";
    }

    public void setPathAsString(String path) {
        this.path = new Path(path);
    }

    public WaybackSpec getConstraint() {
        return this.constraint;
    }

    public void setConstraint(WaybackSpec constraint) {
        this.constraint = constraint;
    }

    public void setConstraintAsCommandString(String commandString) {
        if (commandString != null) {
            this.constraint = WaybackSpec.fromCommandString(new CommandString(commandString));
        }
    }

    public String getConstraintAsCommandString() {
        return Watch.constraintAsCommandString(this.constraint);
    }

    private static String constraintAsCommandString(WaybackSpec constraint) {
        return constraint != null && constraint.toCommandString() != null ? constraint.toCommandString().toString() : "";
    }

    public long getLastChecked() {
        return this.lastChecked;
    }

    public void setLastChecked(long lastChecked) {
        this.lastChecked = lastChecked;
    }

    public RevInfoKey getLastRevisionSent() {
        return this.lastRevisionSent;
    }

    public void setLastRevisionSent(RevInfoKey lastRevisionSent) {
        this.lastRevisionSent = lastRevisionSent;
    }

    public FecruUser getUser() {
        return this.user;
    }

    public String getUsername() {
        return Watch.username(this.getUser());
    }

    private static String username(FecruUser user) {
        return user != null ? user.getUsername() : null;
    }

    public void setUser(FecruUser user) {
        this.user = user;
    }

    public long getCacheSerialOfLastRevisionSent() {
        return this.cacheSerialOfLastRevisionSent;
    }

    public void setCacheSerialOfLastRevisionSent(long cacheSerialOfLastRevisionSent) {
        this.cacheSerialOfLastRevisionSent = cacheSerialOfLastRevisionSent;
    }

    public boolean isSameEntity(String rep, Path path) {
        return this.rep != null && this.rep.equals(rep) && this.path != null && this.path.equals(path);
    }

    public boolean isEquivalent(Watch other) {
        return other.rep.equals(this.rep) && other.path.equals(this.path) && (other.constraint == null && this.constraint == null || other.constraint != null && other.constraint.equals(this.constraint));
    }

    public String getWatchKey() {
        return Watch.watchKey(this.getUsername(), this.getRep(), this.getPathAsString(), this.getConstraintAsCommandString());
    }

    public static String watchKey(FecruUser user, String rep, Path path, WaybackSpec constraint) {
        return Watch.watchKey(Watch.username(user), rep, Watch.pathAsString(path), Watch.constraintAsCommandString(constraint));
    }

    public static String watchKey(String username, String rep, String pathAsString, String constraintAsCommandString) {
        if (username != null && rep != null && pathAsString != null && constraintAsCommandString != null) {
            return HashUtils.getDefaultDigestHexEncoded(username + rep + pathAsString + constraintAsCommandString);
        }
        return null;
    }

    public void setWatchKey(String watchKey) {
    }

    public String toString() {
        return "Watch[id=" + this.id + ";user=" + this.user + ";rep=" + this.rep + ";path=" + this.path + ";constraint=" + this.constraint + ";lastChecked=" + this.lastChecked + ";lastRevisionSent=" + this.lastRevisionSent + ";csn=" + this.cacheSerialOfLastRevisionSent + "]";
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Watch watch = (Watch)o2;
        if (this.path != null ? !this.path.equals(watch.path) : watch.path != null) {
            return false;
        }
        if (!this.rep.equals(watch.rep)) {
            return false;
        }
        return this.user.equals(watch.user);
    }

    public int hashCode() {
        int result = this.user.hashCode();
        result = 31 * result + this.rep.hashCode();
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        return result;
    }
}

