/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.fecru.search.common.SearchUtils;
import com.atlassian.fisheye.activity.RssFeedUrlBuilder;
import com.atlassian.fisheye.web.NavBuilder;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.web.BaseAction;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.FisheyeRepositoryExplorer;
import com.cenqua.fisheye.web.ServletUtils;
import com.cenqua.fisheye.web.ViewFileAction;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.parameterbeans.BaseActionParams;
import com.cenqua.fisheye.web.parameterbeans.ViewRepositoryServletParams;
import com.cenqua.fisheye.web.tarball.TarballAction;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ViewRepositoryServlet
extends BaseAction {
    public static final String SERVLET_PATH = "browse";
    private RepositoryEngine engine;

    @Override
    public void setup() {
        this.engine = this.getPathInfo().getEngine();
    }

    @Override
    public long computeLastModified() {
        return this.computeRepositoryLastModified();
    }

    @Override
    public BaseAction handleRequest(BaseActionParams baseParams) throws ServletException, IOException, DbException {
        FishEyePathInfo pi = this.getPathInfo();
        Path lPath = pi.getLocalPath();
        ViewRepositoryServletParams params = new ViewRepositoryServletParams(baseParams);
        this.getRequest().setAttribute("p", (Object)params);
        this.parseWaybackSpec();
        if (this.handleWaybackJump("/browse", params.getUserPrefs())) {
            return null;
        }
        if (this.handleSvnConflictingBranches("/browse", this.engine)) {
            return null;
        }
        if (this.handleLogicalPathRedirect(baseParams, this.engine)) {
            return null;
        }
        params.setWbSpec(this.waybackSpec);
        RevisionCache<? extends ChangeSet> rep = this.engine.getRevisionCache();
        if (this.handleWatches("/browse", params.getWatchParams())) {
            return null;
        }
        if (pi.getCommandParam("tarball") != null) {
            return SpringContext.createComponent(TarballAction.class);
        }
        if (rep.isDir(lPath)) {
            return this.handleDirRequest(params);
        }
        if (rep.isFile(lPath)) {
            return SpringContext.createComponent(ViewFileAction.class);
        }
        this.send404("Don't know how to handle path " + lPath);
        return null;
    }

    private boolean handleLogicalPathRedirect(BaseActionParams baseParams, RepositoryEngine engine) throws IOException {
        FileRevision bestRevision;
        String logicalPathRedirectParam = this.getRequest().getParameter("logicalPathRedirect");
        if (Strings.isNullOrEmpty((String)logicalPathRedirectParam)) {
            return false;
        }
        Path fullPath = new Path(logicalPathRedirectParam);
        RevisionCache<? extends ChangeSet> revisionCache = engine.getRevisionCache();
        String defaultBranchName = revisionCache.getDefaultBranch();
        FileRevision fileRevision = bestRevision = defaultBranchName != null ? revisionCache.getHeadRevisionOnBranchAtPath(defaultBranchName, fullPath) : null;
        if (bestRevision == null) {
            ArrayList headRevisions = Lists.newArrayListWithExpectedSize((int)1);
            SearchUtils.loadLatestRevisions(engine, fullPath, headRevisions, 1);
            if (!headRevisions.isEmpty()) {
                bestRevision = (FileRevision)headRevisions.get(0);
            }
        }
        if (bestRevision != null) {
            WaybackSpec wb = new WaybackSpec();
            wb.setBranch(bestRevision.getBranch());
            this.getResponse().sendRedirect(bestRevision.isDead() ? NavBuilder.browse(this.getRequest(), wb, baseParams.getRepname(), bestRevision.getPath()) : NavBuilder.browseSource(this.getRequest(), wb, baseParams.getRepname(), bestRevision));
        } else {
            this.getResponse().sendRedirect(NavBuilder.browse(this.getRequest(), null, engine.getName(), fullPath));
        }
        return true;
    }

    private BaseAction handleDirRequest(ViewRepositoryServletParams params) throws IOException, ServletException, DbException {
        long t0 = System.currentTimeMillis();
        FishEyePathInfo pi = this.getPathInfo();
        HttpServletRequest req = this.getRequest();
        HttpServletResponse resp = this.getResponse();
        RepositoryConfig cfg = pi.getRepository();
        Path fpath = pi.getFullPath();
        Path lpath = pi.getLocalPath();
        params.setPath(lpath);
        params.setFpath(fpath);
        params.setTarballNamePrefix(TarballAction.makeTarballFilename(fpath));
        params.setRepositoryExplorer(new FisheyeRepositoryExplorer(this.engine, lpath, this.waybackSpec, this.getUserPreferences()));
        params.setTarballEnabled(cfg.getTarballConfig().isEnabled() && !cfg.getTarballConfig().isExcluded(lpath));
        params.setRequiresAuth(this.requiresAuth());
        if (this.handleWatches("/browse", params.getWatchParams())) {
            return null;
        }
        RssFeedUrlBuilder builder = new RssFeedUrlBuilder(req, "/changelog");
        builder.setAuthenticationRequired(this.requiresAuth());
        builder.setPathInfo(this.getPathInfo());
        builder.setView("fe");
        params.setRssFeedUrl(builder.build().toString());
        long t1 = System.currentTimeMillis();
        req.getRequestDispatcher("/WEB-INF/jsp/dirlist.jsp").forward((ServletRequest)req, (ServletResponse)resp);
        long t2 = System.currentTimeMillis();
        if (Logs.APP_LOG.isDebugEnabled()) {
            Logs.APP_LOG.debug((Object)("handleDirRequest-page for /" + lpath + " in " + (t1 - t0) + "ms then " + (t2 - t1) + "ms for render"));
        }
        return null;
    }

    @Override
    public void handleNoRepository(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        ServletUtils.forward("/WEB-INF/jsp/repositoryList.jsp", req, resp);
    }

    @Override
    public boolean requiresValidPath(FishEyePathInfo pi) {
        return pi.getCommandParam("tarball") == null;
    }
}

