/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.fisheye.activity.RssFeedUrlBuilder;
import com.atlassian.fisheye.plugin.descriptor.GutterRendererModuleDescriptor;
import com.atlassian.fisheye.ui.filedecoration.GutterRenderer;
import com.atlassian.fisheye.ui.filedecoration.LineDecorator;
import com.atlassian.plugin.PluginAccessor;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.config.SyntaxDefinitions;
import com.cenqua.fisheye.cvsrep.KeywordExpansion;
import com.cenqua.fisheye.cvsrep.cache.CvsFileHistory;
import com.cenqua.fisheye.diff.DiffOpts;
import com.cenqua.fisheye.diff.view.FileDiffExplorer;
import com.cenqua.fisheye.io.StreamIndexedLineReader;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.syntax.LinkerService;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.util.CustomFileNameMap;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.vis.Gutter;
import com.cenqua.fisheye.vis.RevisionHistVisualiser;
import com.cenqua.fisheye.web.ActionDispatcherServlet;
import com.cenqua.fisheye.web.BaseAction;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.FisheyeFileHistoryExplorer;
import com.cenqua.fisheye.web.FisheyeRepositoryExplorer;
import com.cenqua.fisheye.web.PreferenceManager;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.mime.ContentDispositionHeaderGuesser;
import com.cenqua.fisheye.web.parameterbeans.BaseActionParams;
import com.cenqua.fisheye.web.parameterbeans.ViewFileActionParams;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ViewFileAction
extends BaseAction {
    private RepositoryEngine engine;
    private final PluginAccessor pluginAccessor;
    private final ContentDispositionHeaderGuesser contentDispositionHeaderGuesser;
    private static final String[] CVS_KEYWORD_OPTS = new String[]{"kv", "k", "v", "o"};

    @Autowired
    public ViewFileAction(PluginAccessor pluginAccessor, ContentDispositionHeaderGuesser contentDispositionHeaderGuesser) {
        this.pluginAccessor = pluginAccessor;
        this.contentDispositionHeaderGuesser = contentDispositionHeaderGuesser;
    }

    @Override
    public void setup() {
        this.engine = this.getPathInfo().getEngine();
    }

    @Override
    public BaseAction handleRequest(BaseActionParams baseParams) throws ServletException, IOException, DbException {
        FishEyePathInfo pi = this.getPathInfo();
        Path lPath = pi.getLocalPath();
        this.parseWaybackSpec();
        FisheyeRepositoryExplorer explorer = new FisheyeRepositoryExplorer(this.engine, Path.ROOT, this.waybackSpec, PreferenceManager.getPreferences(this.getRequest()));
        ViewFileActionParams params = new ViewFileActionParams(baseParams, explorer);
        this.getRequest().setAttribute("p", (Object)params);
        params.setWbSpec(this.waybackSpec);
        params.setPath(this.getPathInfo().getLocalPath());
        params.setFpath(this.getPathInfo().getFullPath());
        RevisionCache<? extends ChangeSet> rep = this.engine.getRevisionCache();
        if (!rep.isFile(lPath)) {
            this.send404("No such file " + lPath);
            return null;
        }
        if ("raw".equals(pi.getCommandWord())) {
            this.doRawRequest(params);
            return null;
        }
        if (this.waybackSpec != null) {
            params.setWbSpec(this.waybackSpec);
        }
        this.handleFileRequest(params);
        return null;
    }

    private void handleFileRequest(ViewFileActionParams params) throws IOException, ServletException, DbException {
        HttpServletRequest req = this.getRequest();
        boolean headOfBranch = StringUtils.isNotEmpty((String)req.getParameter("hb"));
        String revstr = req.getParameter("r");
        String r1str = req.getParameter("r1");
        String r2str = req.getParameter("r2");
        boolean isContent = StringUtils.isNotEmpty((String)req.getParameter("content"));
        boolean isHistoryDropdown = StringUtils.isNotEmpty((String)req.getParameter("historyDropdown"));
        params.setRequiresAuth(this.requiresAuth());
        RssFeedUrlBuilder builder = new RssFeedUrlBuilder(req, "/changelog");
        builder.setAuthenticationRequired(this.requiresAuth());
        builder.setPathInfo(this.getPathInfo());
        builder.setView("fe");
        params.setRSSFeedUrl(builder.build().toString());
        this.setupKeywordOpts(params);
        FileRevision r2 = null;
        if (headOfBranch) {
            WaybackSpec wbSpec = params.getWbSpec();
            r2 = wbSpec != null && wbSpec.getBranch() != null ? this.engine.getRevisionCache().getFileRevisionAtBranch(params.getPath(), wbSpec.getBranch()) : (wbSpec != null && wbSpec.getTag() != null ? this.engine.getRevisionCache().getFileRevisionAtTag(params.getPath(), wbSpec.getTag()) : this.engine.getRevisionCache().getLatestFileRevision(params.getPath()));
        }
        if (r2 == null && StringUtils.isNotEmpty((String)revstr)) {
            r2 = this.engine.getRevisionCache().findFileRevision(params.getPath(), revstr);
        }
        FileRevision r22 = StringUtils.isEmpty((String)r2str) ? null : this.engine.getRevisionCache().findFileRevision(params.getPath(), r2str);
        FileRevision r1 = null;
        if (!StringUtils.isEmpty((String)r2str) && r2str.equals(r1str)) {
            r1 = r22;
        } else if (!StringUtils.isEmpty((String)r1str)) {
            r1 = this.engine.getRevisionCache().findFileRevision(params.getPath(), r1str);
        }
        if (r2 == null) {
            if (r22 != null) {
                r2 = r22;
            } else if (r1 != null) {
                r2 = r1;
            }
        }
        params.setCanAnnotate(this.canAnnotate(r2));
        if (isHistoryDropdown) {
            this.loadHistory(params);
            this.doHistoryDropdown();
        } else if (req.getParameterMap().containsKey("histimage")) {
            FileHistory hist = this.loadHistory(params);
            this.doHistImage(hist);
        } else if (StringUtils.isNotEmpty((String)r1str) || StringUtils.isNotEmpty((String)r2str)) {
            boolean r2Error;
            boolean r1Error = StringUtils.isNotEmpty((String)r1str) && r1 == null;
            boolean bl = r2Error = StringUtils.isNotEmpty((String)r2str) && r22 == null;
            if (r1Error || r2Error) {
                if (r1Error && r2Error) {
                    params.setErrorMessage("Could not resolve revisions " + r1str + " and " + r2str);
                } else if (r1Error) {
                    this.reportRevisionNotResolved(params, r1str);
                } else {
                    this.reportRevisionNotResolved(params, r2str);
                }
                this.loadHistory(params);
                this.handleDoFileHistoryRequest(params);
                return;
            }
            if (r22 == null || r1 == null) {
                this.handleDoDiffRequest(null, r22 != null ? r22 : r1, isContent, params);
            } else if (r1.equals(r22)) {
                this.handleDoFileRequest(r1, isContent, params);
            } else {
                this.handleDoDiffRequest(r1, r22, isContent, params);
            }
        } else if (r2 != null) {
            this.handleDoFileRequest(r2, isContent, params);
        } else if (StringUtils.isNotEmpty((String)r1str) && StringUtils.isEmpty((String)r2str)) {
            this.handleDoFileRequest(r1, isContent, params);
        } else {
            this.loadHistory(params);
            this.handleDoFileHistoryRequest(params);
        }
    }

    private void reportRevisionNotResolved(ViewFileActionParams params, String r2str) {
        params.setErrorMessage("Could not resolve revision " + r2str);
    }

    private void handleDoFileRequest(FileRevision rev, boolean isContent, ViewFileActionParams params) throws IOException, ServletException, DbException {
        if (isContent) {
            this.doFileContents(rev, params);
        } else {
            this.doFile(rev, params);
        }
    }

    private void handleDoDiffRequest(FileRevision r1, FileRevision r2, boolean isContent, ViewFileActionParams params) throws IOException, ServletException, DbException {
        if (isContent) {
            this.doDiffAjax(r1, r2, params);
        } else {
            this.doDiff(r1, r2, params);
        }
    }

    private FileHistory loadHistory(ViewFileActionParams params) throws DbException {
        RevisionCache<? extends ChangeSet> crep = this.engine.getRevisionCache();
        String viewMode = this.getUserPreferences().getPreference("viewMode");
        FileHistory hist = crep.getFullFileHistory(params.getPath(), viewMode.equals("p"));
        params.setHist(hist);
        params.setHistExplorer(new FisheyeFileHistoryExplorer(hist, this.waybackSpec, this.getUserPreferences()));
        return hist;
    }

    private void doFile(FileRevision info, ViewFileActionParams params) throws IOException, ServletException, DbException {
        HttpServletRequest req = this.getRequest();
        HttpServletResponse resp = this.getResponse();
        String revstr = info.getDisplayRevision();
        if (info.getRevInfoKey() == null) {
            Logs.APP_LOG.debug((Object)("Revision " + revstr + " has a null RevInfoKey - unable to view file"));
            this.reportRevisionNotResolved(params, revstr);
            this.handleDoFileHistoryRequest(params);
            return;
        }
        if (info.isDead()) {
            this.sendFileDeleted(info, params);
            return;
        }
        if (Logs.APP_LOG.isDebugEnabled()) {
            Logs.APP_LOG.debug((Object)("doFile: " + params.getPath() + " " + revstr + " " + info.getRevInfoKey()));
        }
        params.setRev(revstr);
        params.setRevname(revstr);
        params.setInfo(info);
        this.parseKeywordOpts(false, params);
        this.addPrevAndNext(info, params);
        this.setupGutters(info, params);
        params.setViewAnnotation(true);
        params.setContextLines(this.getContextLines(req));
        DiffOpts diffOpts = new DiffOpts(req.getParameter("ignore"));
        diffOpts.setSideBySide(false);
        diffOpts.setSoftWrap(false);
        params.setDiffOpts(diffOpts);
        params.setDiffOpts(diffOpts);
        req.getRequestDispatcher("/WEB-INF/jsp/file/fileView.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }

    private boolean canAnnotate(FileRevision info) throws DbException {
        return info != null && info.isAnnotatable();
    }

    private void doFileContents(FileRevision info, ViewFileActionParams params) throws IOException, ServletException, DbException {
        HttpServletRequest req = this.getRequest();
        HttpServletResponse resp = this.getResponse();
        RevisionCache<? extends ChangeSet> crep = this.engine.getRevisionCache();
        if (info == null || info.getRevInfoKey() == null || info.isDead()) {
            return;
        }
        String revstr = info.getDisplayRevision();
        params.setRev(revstr);
        params.setRevname(revstr);
        params.setInfo(info);
        if (req.getParameter("toBlock") != null) {
            params.setAnnotationBlock(req.getParameter("toBlock"));
        }
        params.setViewAnnotation(true);
        if (params.getCanAnnotate()) {
            String kopt = this.parseKeywordOpts(false, params);
            StreamIndexedLineReader lines = this.getRepositoryCache().getUnicodeTextRevision(info, kopt, revstr);
            lines.scanRestOfFile();
            params.setEolTerminated(lines.isEolTerminated());
            SyntaxDefinitions.ParseResult synhi = AppConfig.getsConfig().getSyntaxDefinitions().getRegionsForFile(params.getFpath().getPath(), lines.getCharSequence());
            RegionList regions = synhi.getRegions();
            this.getLinkerService().getRepositoryLinker(crep.getRepositoryName()).insertLinks(lines.getCharSequence(), regions);
            params.setRegions(regions);
            params.setSyntaxname(synhi.getSyntaxDefinition().getName().toLowerCase());
            params.setLines(lines);
            this.addPrevAndNext(info, params);
            this.setupGutters(info, params);
        }
        String responseJsp = params.isViewDiff() ? "/WEB-INF/jsp/file/fileViewContentsHtmlResp.jsp" : (this.isAjaxRequest(req) ? "/WEB-INF/jsp/file/fileViewJsonAnnotationAjaxResp.jsp" : "/WEB-INF/jsp/file/fileViewJsonAnnotationResp.jsp");
        req.getRequestDispatcher(responseJsp).forward((ServletRequest)req, (ServletResponse)resp);
    }

    private boolean isAjaxRequest(HttpServletRequest request) {
        String p2 = request.getParameter("ajax");
        return p2 != null && p2.equals("true");
    }

    private void setupGutters(FileRevision info, ViewFileActionParams params) {
        String repname = this.getRepositoryCache().getRepositoryName();
        String path = info.getRevInfoKey().getPath().getPath();
        String rev = info.getRevInfoKey().getRev();
        try {
            for (GutterRendererModuleDescriptor d2 : this.pluginAccessor.getEnabledModuleDescriptorsByClass(GutterRendererModuleDescriptor.class)) {
                List decorators = ((GutterRenderer)d2.getModule()).getAnnotationDecorators(repname, path, rev);
                for (LineDecorator decorator : decorators) {
                    params.addGutter(new Gutter(decorator));
                }
            }
        }
        catch (Exception e2) {
            Logs.APP_LOG.warn((Object)"problem getting gutter renderers, skipping", (Throwable)e2);
        }
    }

    protected String getPreviousRevision(FileRevision current) {
        RevInfoKey rk = this.getPreviousRevisionKey(current);
        if (rk != null) {
            return rk.getRev();
        }
        return null;
    }

    protected RevInfoKey getPreviousRevisionKey(FileRevision current) {
        if (current != null && current.getDiffRevision() != null) {
            RevInfoKey revKey = current.getDiffRevision();
            if (revKey.getPath().equals(current.getPath())) {
                return current.getDiffRevision();
            }
            return null;
        }
        return null;
    }

    protected String getNextRevision(FileRevision current) {
        if (current == null) {
            return null;
        }
        int nextSuccessorId = this.engine.getRevisionCache().findNextSuccessor(current.getRevID());
        FileRevision nextSuccessor = nextSuccessorId == current.getRevID() ? null : this.engine.getRevisionCache().getFileRevision(nextSuccessorId);
        return nextSuccessor == null ? null : nextSuccessor.getRevision();
    }

    protected String getNextRevision(FileHistory hist, FileRevision current) {
        if (current != null && hist != null) {
            RevInfoKey curKey = current.getRevInfoKey();
            RevInfoKey ancestorKey = null;
            for (FileRevision rev : hist.getRevisionsSorted()) {
                if (!curKey.getPath().equals(rev.getPath())) continue;
                if (curKey.equals(rev.getDiffRevision())) {
                    return rev.getRevision();
                }
                if (ancestorKey != null || !rev.getAncestors().contains(curKey)) continue;
                ancestorKey = rev.getRevInfoKey();
            }
            return ancestorKey != null ? ancestorKey.getRev() : null;
        }
        return null;
    }

    private void addPrevAndNext(FileRevision current, ViewFileActionParams params) {
        params.setEarlierRev(this.getPreviousRevision(current));
        params.setLaterRev(this.getNextRevision(current));
    }

    private void addPrevAndNextDiff(FileRevision r1, FileRevision r2, ViewFileActionParams params) {
        params.setEarlierDiffRev(this.getPreviousRevision(r1));
        params.setLaterDiffRev(this.getNextRevision(r2));
    }

    private void doDiff(FileRevision r1info, FileRevision r2info, ViewFileActionParams params) throws IOException, DbException, ServletException {
        HttpServletRequest req = this.getRequest();
        HttpServletResponse resp = this.getResponse();
        params.setOriginalR1(r1info == null ? "" : r1info.getDisplayRevision());
        params.setOriginalR2(r2info.getDisplayRevision());
        if (r1info == null) {
            RevInfoKey r1Key = this.getPreviousRevisionKey(r2info);
            if (r1Key != null) {
                r1info = this.engine.getRevisionCache().getFileRevision(r1Key);
            }
            if (r1info == null) {
                this.handleDoFileRequest(r2info, false, params);
                return;
            }
        }
        if (r1info.getDate() > r2info.getDate()) {
            FileRevision tmp2 = r1info;
            r1info = r2info;
            r2info = tmp2;
        }
        params.setCanAnnotate(!r1info.isBinaryOrOversize() && !r2info.isBinaryOrOversize());
        params.setCanDiff(!r1info.isBinaryOrOversize() && !r2info.isBinaryOrOversize());
        params.setR1(r1info.getRevision());
        params.setR1info(r1info);
        params.setR2(r2info.getRevision());
        params.setR2info(r2info);
        params.setRevname(r2info.getDisplayRevision());
        params.setContextLines(this.getContextLines(req));
        DiffOpts diffOpts = new DiffOpts(req.getParameter("ignore"));
        diffOpts.setSideBySide(false);
        diffOpts.setSoftWrap(false);
        params.setDiffOpts(diffOpts);
        params.setViewDiff(true);
        this.addPrevAndNextDiff(r1info, r2info, params);
        req.getRequestDispatcher("/WEB-INF/jsp/file/fileView.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }

    private void doDiffAjax(FileRevision r1info, FileRevision r2info, ViewFileActionParams params) throws IOException, DbException, ServletException {
        HttpServletRequest req = this.getRequest();
        HttpServletResponse resp = this.getResponse();
        if (r1info == null) {
            RevInfoKey r1Key = this.getPreviousRevisionKey(r2info);
            if (r1Key != null) {
                r1info = this.engine.getRevisionCache().getFileRevision(r1Key);
            }
            if (r1info == null) {
                this.handleDoFileRequest(r2info, true, params);
                return;
            }
        }
        if (r1info == null || r2info == null) {
            return;
        }
        params.setCanAnnotate(!r1info.isBinaryOrOversize() && !r2info.isBinaryOrOversize());
        params.setCanDiff(!r1info.isBinaryOrOversize() && !r2info.isBinaryOrOversize());
        if (r1info.getDate() > r2info.getDate()) {
            FileRevision tmp2 = r1info;
            r1info = r2info;
            r2info = tmp2;
        }
        params.setR1(r1info.getRevision());
        params.setR1info(r1info);
        params.setR2(r2info.getRevision());
        params.setR2info(r2info);
        String ignore = req.getParameter("ignore");
        DiffOpts diffOpts = new DiffOpts(ignore);
        diffOpts.setSideBySide(false);
        diffOpts.setSoftWrap(false);
        String kopt = this.parseKeywordOpts(true, params);
        FileDiffExplorer fe = params.getCanDiff() ? ViewFileAction.diffRevisions(this.getRepositoryCache(), r1info, r2info, diffOpts, kopt) : null;
        String contextLines = this.getContextLines(req);
        params.setContextLines(contextLines);
        try {
            if (fe != null) {
                fe.setContextLines(Integer.parseInt(contextLines));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        params.setDiffOpts(diffOpts);
        params.setDiffs(fe);
        params.setViewDiff(true);
        if (req.getParameter("sbsdiff") != null) {
            if (fe != null) {
                fe.setContextLines(-1);
                fe.getPrinter().setSideBySide(true);
            }
            if (req.getParameter("linesPerPage") != null) {
                params.setLinesPerPage(req.getParameter("linesPerPage"));
            }
            if (req.getParameter("fromBlock") != null || req.getParameter("toBlock") != null) {
                params.setFromBlock(req.getParameter("fromBlock"));
                params.setToBlock(req.getParameter("toBlock"));
                req.getRequestDispatcher("/WEB-INF/jsp/file/diffPageJson.jsp").forward((ServletRequest)req, (ServletResponse)resp);
            } else {
                params.setFromBlock("0");
                params.setToBlock("0");
                req.getRequestDispatcher("/WEB-INF/jsp/file/fileViewSideBySideDiffHtmlResp.jsp").forward((ServletRequest)req, (ServletResponse)resp);
            }
        } else if (params.isViewDiff()) {
            req.getRequestDispatcher("/WEB-INF/jsp/file/fileViewContentsHtmlResp.jsp").forward((ServletRequest)req, (ServletResponse)resp);
        } else {
            req.getRequestDispatcher("/WEB-INF/jsp/file/fileViewJsonAnnotationResp.jsp").forward((ServletRequest)req, (ServletResponse)resp);
        }
    }

    private String getContextLines(HttpServletRequest req) {
        String contextLines = req.getParameter("u");
        if (contextLines == null) {
            contextLines = String.valueOf(this.getUserProfile().getContext());
        }
        return contextLines;
    }

    private void handleDoFileHistoryRequest(ViewFileActionParams params) throws ServletException, IOException, DbException {
        HttpServletRequest req = this.getRequest();
        boolean isContent = StringUtils.isNotEmpty((String)req.getParameter("content"));
        if (isContent) {
            this.doFileHistoryContents(params);
        } else {
            this.doFileHistory(params);
        }
    }

    private void doHistoryDropdown() throws ServletException, IOException {
        HttpServletRequest req = this.getRequest();
        HttpServletResponse resp = this.getResponse();
        req.getRequestDispatcher("/WEB-INF/jsp/file/fileHistoryRevisionsJson.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }

    private void doFileHistory(ViewFileActionParams params) throws ServletException, IOException, DbException {
        HttpServletRequest req = this.getRequest();
        HttpServletResponse resp = this.getResponse();
        params.getWatchParams().setWatching(this.isWatching(params.getPath(), params.getWbSpec()));
        params.setRevname(req.getParameter("focusedRev"));
        params.setR1(req.getParameter("fromRev"));
        params.setR2(req.getParameter("toRev"));
        req.getRequestDispatcher("/WEB-INF/jsp/file/fileHistory.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }

    private void doFileHistoryContents(ViewFileActionParams params) throws ServletException, IOException, DbException {
        HttpServletRequest req = this.getRequest();
        HttpServletResponse resp = this.getResponse();
        HashSet<Integer> revisionIds = new HashSet<Integer>();
        String[] revs = req.getParameterValues("rev");
        if (revs != null) {
            for (String rev : revs) {
                Integer id = Integer.parseInt(rev);
                revisionIds.add(id);
            }
        }
        params.getMinimalRevisionTableData(revisionIds);
        params.setRevname(req.getParameter("focusedRev"));
        req.getRequestDispatcher("/WEB-INF/jsp/file/fileHistoryContentsResp.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }

    private void setupKeywordOpts(ViewFileActionParams params) {
        if (this.getRepositoryCache().getRepositoryType() != ScmType.CVS) {
            return;
        }
        params.setKeywordOpts(CVS_KEYWORD_OPTS);
    }

    private String parseKeywordOpts(boolean forDiff, ViewFileActionParams params) {
        if (this.getRepositoryCache().getRepositoryType() != ScmType.CVS) {
            return null;
        }
        HttpServletRequest req = this.getRequest();
        CvsFileHistory hist = (CvsFileHistory)this.loadHistory(params);
        String kr = req.getParameter("k");
        if (kr != null) {
            params.setKoptGiven(kr);
            params.setKopt(kr);
            return kr;
        }
        String kp = this.getPathInfo().getCommandParam("k");
        if (kp != null) {
            params.setKoptGiven(kp);
            params.setKopt(kp);
            return kp;
        }
        KeywordExpansion defaultKw = hist.getExpand();
        if (!forDiff) {
            params.setKopt(defaultKw.getName());
            return defaultKw.getName();
        }
        if (defaultKw == KeywordExpansion.KFLAG_O || defaultKw == KeywordExpansion.KFLAG_B) {
            params.setKopt(defaultKw.getName());
            return defaultKw.getName();
        }
        KeywordExpansion defaultOverride = KeywordExpansion.KFLAG_K;
        params.setKoptGiven(defaultOverride.getName());
        params.setKopt(defaultOverride.getName());
        return defaultOverride.getName();
    }

    private void doRawRequest(ViewFileActionParams params) throws IOException, DbException, ServletException {
        ServletOutputStream out;
        FishEyePathInfo pi = this.getPathInfo();
        HttpServletResponse resp = this.getResponse();
        params.setFpath(pi.getFullPath());
        String r2 = pi.getCommandParam("r");
        if (r2 == null) {
            this.send404("No revision (r) given for raw request");
            return;
        }
        FileRevision info = this.engine.getRevisionCache().findFileRevision(params.getPath(), r2);
        if (info == null) {
            this.send404("No revision found " + r2);
            return;
        }
        if (info.isDead()) {
            this.sendFileDeleted(info, params);
            return;
        }
        String filename = params.getPath().getName();
        CustomFileNameMap fnm = AppConfig.getsConfig().getRawMimeMap();
        String mime = fnm.getContentTypeFor(filename);
        if (mime == null) {
            mime = this.getServletContext().getMimeType(filename);
        }
        if (mime == null) {
            mime = info.isBinary() ? "application/octet-stream" : "text/plain";
        }
        String userAgent = this.getRequest().getHeader("User-Agent");
        String contentDispositionHeader = this.contentDispositionHeaderGuesser.guessContentDispositionHeader(filename, mime, userAgent);
        mime = this.contentDispositionHeaderGuesser.guessMIME(filename, mime, userAgent);
        resp.setHeader("Content-Disposition", contentDispositionHeader);
        if (info.isBinary()) {
            resp.setContentType(mime);
            out = resp.getOutputStream();
            this.engine.getRevisionCache().getBinaryRevision(info.getRevInfoKey(), (OutputStream)out);
        } else {
            Charset cs = this.engine.getRevisionCache().getTextEncoding(info.getRevInfoKey());
            resp.setContentType(mime + ";charset=" + cs.name());
            out = resp.getOutputStream();
            String kopt = this.parseKeywordOpts(false, params);
            this.engine.getRevisionCache().getTextRevision(info.getRevInfoKey(), (OutputStream)out, kopt, r2);
        }
        out.close();
    }

    public static FileDiffExplorer diffRevisions(RevisionCache contentsSource, FileRevision ri1, FileRevision ri2, DiffOpts diffOpts, String kopt) throws IOException {
        return FileDiffExplorer.buildDiffExplorer(contentsSource, ri1, ri2, diffOpts, kopt);
    }

    public static boolean diffBinaryRevisions(Disposer disposer, RevisionCache rep, RevInfoKey ri1, RevInfoKey ri2) throws IOException, DbException {
        block2: {
            int c2;
            int c1;
            File file1 = rep.getBinaryRevision(ri1);
            File file2 = rep.getBinaryRevision(ri2);
            if (file1.length() != file2.length()) {
                return true;
            }
            BufferedInputStream in1 = new BufferedInputStream(new FileInputStream(file1));
            disposer.closeOnDispose(in1);
            BufferedInputStream in2 = new BufferedInputStream(new FileInputStream(file2));
            disposer.closeOnDispose(in2);
            do {
                boolean eof2;
                c1 = ((InputStream)in1).read();
                c2 = ((InputStream)in2).read();
                boolean eof1 = c1 == -1;
                boolean bl = eof2 = c2 == -1;
                if (eof1 && eof2) break block2;
                if (!eof1 && !eof2) continue;
                return true;
            } while (c1 == c2);
            return true;
        }
        return false;
    }

    private void doHistImage(FileHistory hist) throws IOException, DbException {
        HttpServletResponse resp = this.getResponse();
        RevisionHistVisualiser vis = new RevisionHistVisualiser(hist);
        resp.setContentType(vis.getImageContentType());
        boolean imageRendered = vis.renderImage((OutputStream)resp.getOutputStream());
        if (!imageRendered) {
            resp.sendRedirect(this.getRequest().getContextPath() + "/" + ActionDispatcherServlet.STATIC_DIR + "/images/spacerArrow.gif");
        }
    }

    @Override
    public long computeLastModified() {
        return this.computeRepositoryLastModified();
    }

    private LinkerService getLinkerService() {
        return SpringContext.getComponentByClass(LinkerService.class);
    }
}

