/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.RootConfig;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ViewCvsRemapperServlet
extends HttpServlet {
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String first;
        String pCvsroot = req.getParameter("cvsroot");
        String pRoot = req.getParameter("root");
        String pRev = req.getParameter("rev");
        String pR1 = req.getParameter("r1");
        String pR2 = req.getParameter("r2");
        String pAnnotate = req.getParameter("annotate");
        String pView = req.getParameter("view");
        RootConfig.ViewCvsRemapper mapper = AppConfig.getsConfig().getViewCvsRemapper();
        String repname = mapper.getDefaultRepository();
        if (pCvsroot != null) {
            repname = mapper.map(pCvsroot);
        } else if (pRoot != null) {
            repname = mapper.map(pRoot);
        }
        String browseUrl = req.getContextPath() + "/browse/";
        String changelogUrl = req.getContextPath() + "/changelog/";
        if ("rev".equals(pView) && pRev != null) {
            resp.sendRedirect(changelogUrl + repname + "/?cs=" + pRev);
            return;
        }
        String pi = req.getPathInfo();
        if (pi == null) {
            resp.sendRedirect(browseUrl + repname + "/");
            return;
        }
        Path rest = new Path(pi);
        boolean isCheckout = false;
        if (rest.numComponents() > 0 && ((first = rest.getComponent(0)).equals("*checkout*") || first.equals("~checkout~"))) {
            rest = rest.trimFirst();
            isCheckout = true;
        }
        if (pRev != null) {
            if (isCheckout) {
                resp.sendRedirect(browseUrl + "~raw,r=" + pRev + "/" + repname + "/" + rest);
            } else {
                resp.sendRedirect(browseUrl + repname + "/" + rest + "?r=" + pRev);
            }
        }
        if (pAnnotate != null) {
            resp.sendRedirect(browseUrl + repname + "/" + rest + "?r=" + pAnnotate);
        }
        if (pR1 != null && pR2 != null) {
            resp.sendRedirect(browseUrl + repname + "/" + rest + "?r1=" + pR1 + "&r2=" + pR2);
        }
        resp.sendRedirect(browseUrl + repname + "/" + rest);
    }
}

