/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.google.common.base.Strings;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class UrlHelper {
    private String url = "";
    private boolean urlIsEncoded = false;
    private LinkedHashMap<String, Object> params;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        this.urlIsEncoded = false;
    }

    public void setEncodedUrl(String url) {
        this.url = url;
        this.urlIsEncoded = true;
    }

    public Map<String, Object> getParams() {
        if (this.params == null) {
            this.params = new LinkedHashMap();
        }
        return this.params;
    }

    public void putMulti(String name, String value) {
        Map<String, Object> m2 = this.getParams();
        LinkedList<String> l2 = (LinkedList<String>)m2.get(name);
        if (l2 == null) {
            l2 = new LinkedList<String>();
            m2.put(name, l2);
        }
        l2.add(value);
    }

    public void putParam(String name, Object value) {
        if (value == null || value.toString().equals("") || Strings.isNullOrEmpty((String)name)) {
            return;
        }
        this.getParams().put(name, value.toString());
    }

    public void clearParam(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return;
        }
        this.getParams().remove(name);
    }

    public void putParam(String name, Object[] value) {
        if (Strings.isNullOrEmpty((String)name) || value == null) {
            return;
        }
        for (Object o2 : value) {
            String val;
            if (o2 == null || Strings.isNullOrEmpty((String)(val = o2.toString()))) continue;
            this.putMulti(name, o2.toString());
        }
    }

    public UrlHelper getClone() {
        UrlHelper clone = new UrlHelper();
        clone.url = this.url;
        clone.urlIsEncoded = this.urlIsEncoded;
        clone.params = this.params == null ? null : new LinkedHashMap<String, Object>(this.params);
        return clone;
    }

    public String toString() {
        String url = this.urlIsEncoded ? this.url : FishEyeURLEncoder.pathEncode(this.url);
        return url + this.getParamString();
    }

    public String getParamString() {
        StringBuilder buf = new StringBuilder();
        if (this.params != null && !this.params.isEmpty()) {
            String sep = "";
            if (this.url.indexOf(63) == -1) {
                buf.append('?');
            } else {
                sep = "&";
            }
            for (String key : this.params.keySet()) {
                Object val = this.params.get(key);
                if (val instanceof List) {
                    List l2 = (List)val;
                    for (Object val2 : l2) {
                        buf.append(sep);
                        buf.append(FishEyeURLEncoder.uriEncode(key));
                        buf.append("=").append(FishEyeURLEncoder.uriEncode(val2.toString()));
                        sep = "&";
                    }
                    continue;
                }
                buf.append(sep);
                buf.append(FishEyeURLEncoder.uriEncode(key));
                buf.append("=").append(FishEyeURLEncoder.uriEncode(String.valueOf(val)));
                sep = "&";
            }
        }
        return buf.toString();
    }

    public static void putParam(UrlHelper urlHelper, String name, Object value) {
        urlHelper.putParam(name, value);
    }

    public static void clearParam(UrlHelper urlHelper, String name) {
        urlHelper.clearParam(name);
    }

    public static void putParams(UrlHelper urlHelper, String name, List values) {
        if (values != null) {
            urlHelper.putParam(name, values.toArray());
        }
    }

    public static void initUrl(UrlHelper urlHelper, String url) {
        urlHelper.setUrl(url);
    }

    public String getUrlAndParams() {
        return this.toString();
    }

    public void parseAndAddParams(String paramString) {
        if (paramString != null && paramString.length() > 0) {
            for (String s2 : paramString.split("[&?]")) {
                String[] paramElements = s2.split("=");
                if (paramElements.length != 2) continue;
                this.putParam(paramElements[0], paramElements[1]);
            }
        }
    }

    public void putParams(Map<String, String[]> parameterMap) {
        if (this.params == null) {
            this.params = new LinkedHashMap();
        }
        for (Map.Entry<String, String[]> param : parameterMap.entrySet()) {
            if (param.getValue().length == 1) {
                this.putParam(param.getKey(), param.getValue()[0]);
                continue;
            }
            for (String value : param.getValue()) {
                this.putMulti(param.getKey(), value);
            }
        }
    }
}

