/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.google.common.base.Strings;
import java.util.Comparator;
import java.util.Locale;

public abstract class TableDisplayData {
    private Long loc;
    private String displayName;
    private Long numCommits;
    private Long numReviews;
    private String extraField = null;

    protected TableDisplayData(String displayName, Long loc, Long numCommits, Long numReviews) {
        this.loc = loc;
        this.displayName = displayName;
        this.numCommits = numCommits;
        this.numReviews = numReviews;
    }

    protected TableDisplayData(String displayName, Long loc, Long numCommits, Long numReviews, String extraField) {
        this(displayName, loc, numCommits, numReviews);
        this.extraField = extraField;
    }

    public void setLoc(Long loc) {
        this.loc = loc;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setNumCommits(Long numCommits) {
        this.numCommits = numCommits;
    }

    public void setNumReviews(Long numReviews) {
        this.numReviews = numReviews;
    }

    public Long getLoc() {
        return this.loc;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Long getNumCommits() {
        return this.numCommits;
    }

    public Long getNumReviews() {
        return this.numReviews;
    }

    public String getExtraField() {
        return this.extraField;
    }

    public static enum ColumnComparators {
        DISPLAY_NAME(new Comparator<TableDisplayData>(){

            @Override
            public int compare(TableDisplayData o1, TableDisplayData o2) {
                return ColumnComparators.nameComparison(o1, o2);
            }
        }),
        LOC(new Comparator<TableDisplayData>(){

            @Override
            public int compare(TableDisplayData o1, TableDisplayData o2) {
                int result = -o1.getLoc().compareTo(o2.getLoc());
                if (result == 0) {
                    result = ColumnComparators.nameComparison(o1, o2);
                }
                return result;
            }
        }),
        REVIEW(new Comparator<TableDisplayData>(){

            @Override
            public int compare(TableDisplayData o1, TableDisplayData o2) {
                int result = -o1.getNumReviews().compareTo(o2.getNumReviews());
                if (result == 0) {
                    result = ColumnComparators.nameComparison(o1, o2);
                }
                return result;
            }
        }),
        EXTRA(new Comparator<TableDisplayData>(){

            @Override
            public int compare(TableDisplayData o1, TableDisplayData o2) {
                int result = -o1.getExtraField().toLowerCase(Locale.US).compareTo(o2.getExtraField().toLowerCase(Locale.US));
                if (result == 0) {
                    result = ColumnComparators.nameComparison(o1, o2);
                }
                return result;
            }
        }),
        COMMITS(new Comparator<TableDisplayData>(){

            @Override
            public int compare(TableDisplayData o1, TableDisplayData o2) {
                int result = -o1.getNumCommits().compareTo(o2.getNumCommits());
                if (result == 0) {
                    result = ColumnComparators.nameComparison(o1, o2);
                }
                return result;
            }
        });

        private final Comparator<TableDisplayData> reversedOrder;
        private final Comparator<TableDisplayData> naturalOrder;

        private static int nameComparison(TableDisplayData o1, TableDisplayData o2) {
            return o1.getDisplayName().toLowerCase(Locale.US).compareTo(o2.getDisplayName().toLowerCase(Locale.US));
        }

        private ColumnComparators(final Comparator<TableDisplayData> natural) {
            this.naturalOrder = natural;
            this.reversedOrder = new Comparator<TableDisplayData>(){

                @Override
                public int compare(TableDisplayData o1, TableDisplayData o2) {
                    return -natural.compare(o1, o2);
                }
            };
        }

        public Comparator<TableDisplayData> getComp(boolean useReverseOrder) {
            return useReverseOrder ? this.reversedOrder : this.naturalOrder;
        }

        public static ColumnComparators getFromParam(String parameter) {
            if (Strings.isNullOrEmpty((String)parameter)) {
                return DISPLAY_NAME;
            }
            ColumnComparators which = ColumnComparators.valueOf(parameter.toUpperCase(Locale.US));
            return which == null ? DISPLAY_NAME : which;
        }
    }
}

