/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.fisheye.activity.ActivityRequestConstants;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.cenqua.fisheye.web.RepositoryAction;
import com.cenqua.fisheye.web.TableDisplayData;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SortableListAction
extends RepositoryAction {
    private TableDisplayData.ColumnComparators columnComparator = null;
    private boolean descending;
    private static final String ASC = "asc";
    private static final String DESC = "desc";
    protected int timeout = ActivityRequestConstants.DEFAULT_TIMEOUT_LONG;
    protected ActivitySearchMonitor monitor;

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public ActivitySearchMonitor getActivitySearchMonitor() {
        return this.monitor;
    }

    public void sort(List<? extends TableDisplayData> data) {
        Collections.sort(data, this.getSortComparator().getComp(this.descending));
    }

    public String getSortType() {
        return this.getSortComparator().name().toLowerCase(Locale.US);
    }

    public void setSort(String sort) {
        this.columnComparator = TableDisplayData.ColumnComparators.getFromParam(sort);
    }

    public TableDisplayData.ColumnComparators getSortComparator() {
        if (this.columnComparator == null) {
            this.columnComparator = TableDisplayData.ColumnComparators.DISPLAY_NAME;
        }
        return this.columnComparator;
    }

    public final Map<String, String> getNextSorts() {
        HashMap<String, String> nextSortsMap = new HashMap<String, String>(TableDisplayData.ColumnComparators.values().length);
        for (TableDisplayData.ColumnComparators column : TableDisplayData.ColumnComparators.values()) {
            nextSortsMap.put(column.name(), this.getSortComparator().equals((Object)column) ? this.getReverseDir() : ASC);
        }
        return nextSortsMap;
    }

    public void setD(String direction) {
        this.descending = DESC.equalsIgnoreCase(direction);
    }

    public String getDir() {
        return this.descending ? DESC : ASC;
    }

    public String getReverseDir() {
        return this.descending ? ASC : DESC;
    }

    public boolean isDescending() {
        return this.descending;
    }
}

