/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.web.UrlHelper;
import com.cenqua.fisheye.web.filters.ReviewPermaIdRewrite;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jetty.util.UrlEncoded;

public class ServletUtils {
    public static final String ORIG_REQUEST_URI = "fisheye.forward.request_uri";
    public static final String ORIG_CONTEXT_PATH = "fisheye.forward.context_path";
    public static final String ORIG_QUERY_STRING = "fisheye.forward.query_string";
    private static final String GLOBAL_REALM = "fecru";
    private static final String REDIRECT_FROM = "_redir";

    public static void send404(HttpServletRequest request, HttpServletResponse response, String msg) throws IOException {
        Logs.APP_LOG.info((Object)("404: " + msg + " referer=" + request.getHeader("Referer")));
        response.sendError(404, msg);
    }

    public static void send403(HttpServletRequest request, HttpServletResponse response, String msg) throws IOException {
        Logs.APP_LOG.info((Object)("403: " + msg + " referer=" + request.getHeader("Referer")));
        response.sendError(403, msg);
    }

    public static void send401(HttpServletResponse response) throws IOException {
        response.addHeader("WWW-Authenticate", "Basic realm=\"fecru\"");
        response.sendError(401, "Auth required");
    }

    public static void sendXsrfError(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (request.getParameter(REDIRECT_FROM) != null) {
            response.sendRedirect(ServletUtils.getClosestGETUrl(request));
        } else {
            ServletUtils.send403(request, response, "XSRF Error");
        }
    }

    public static void sendRepositoryNotRunning(HttpServletRequest request, HttpServletResponse response, RepositoryHandle handle) throws IOException, ServletException {
        request.setAttribute("state", (Object)handle.getStateDescription());
        String msg = handle.getStatus().getMessage();
        if (StringUtils.isNotBlank((String)msg)) {
            request.setAttribute("status", (Object)msg);
        }
        request.getRequestDispatcher("/WEB-INF/jsp/common/repositoryNotRunning.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    public static void sendRepositoryNotEnabled(HttpServletRequest request, HttpServletResponse response, RepositoryHandle handle) throws IOException, ServletException {
        request.setAttribute("state", (Object)handle.getStateDescription());
        String msg = handle.getStatus().getMessage();
        if (StringUtils.isNotBlank((String)msg)) {
            request.setAttribute("status", (Object)msg);
        }
        request.getRequestDispatcher("/WEB-INF/jsp/common/repositoryDisabled.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    public static String getPostContextPath(HttpServletRequest req) {
        String uri = ServletUtils.decodeString(req.getRequestURI());
        String cp = ServletUtils.decodeString(req.getContextPath());
        return ServletUtils.slashBefore(uri.substring(cp.length()));
    }

    public static String getOriginalPostContextPath(HttpServletRequest req) {
        String uri = ServletUtils.decodeString(ServletUtils.getOriginalRequestURI(req));
        String cp = ServletUtils.decodeString(ServletUtils.getOriginalContextPath(req));
        return ServletUtils.slashBefore(uri.substring(cp.length()));
    }

    public static String getOriginalContextPath(HttpServletRequest req) {
        String cp = (String)req.getAttribute(ORIG_CONTEXT_PATH);
        return cp == null ? req.getContextPath() : cp;
    }

    public static String getOriginalRequestURIAndQueryString(HttpServletRequest req) {
        String qs = ServletUtils.getOriginalQueryString(req);
        return ServletUtils.getOriginalRequestURI(req) + (qs == null ? "" : "?" + qs);
    }

    public static String getClosestGETUrl(HttpServletRequest req) {
        String requestUrl = ServletUtils.getOriginalRequestURI(req);
        String contextUrl = ServletUtils.slashBefore(requestUrl.substring(Strings.nullToEmpty((String)req.getContextPath()).length()));
        String closestUrl = ReviewPermaIdRewrite.getClosestGETUrl(contextUrl);
        if (closestUrl == null && contextUrl.startsWith("/admin/")) {
            closestUrl = "/admin/";
        }
        closestUrl = (String)Objects.firstNonNull((Object)closestUrl, (Object)"");
        return ServletUtils.slashBefore((String)Objects.firstNonNull((Object)req.getContextPath(), (Object)"") + closestUrl);
    }

    protected static String slashBefore(String uri) {
        if (!uri.startsWith("/")) {
            uri = "/" + uri;
        }
        return uri;
    }

    public static void sendRedirectFrom(HttpServletResponse response, String url, String from) throws IOException {
        String redirectUrl;
        UrlHelper helper = new UrlHelper();
        helper.putParam(REDIRECT_FROM, from);
        String query = helper.getParamString();
        if (query.startsWith("?")) {
            query = query.substring(1);
        }
        if (url.contains("#")) {
            int hashIndex = url.indexOf(35);
            String pathAndQs = url.substring(0, hashIndex);
            String sep = pathAndQs.contains("?") ? "&" : "?";
            redirectUrl = pathAndQs + sep + query + url.substring(hashIndex);
        } else {
            String sep = url.contains("?") ? "&" : "?";
            redirectUrl = url + sep + query;
        }
        response.sendRedirect(redirectUrl);
    }

    public static String getOriginalRequestURI(HttpServletRequest req) {
        String uri = (String)req.getAttribute(ORIG_REQUEST_URI);
        return uri == null ? req.getRequestURI() : uri;
    }

    public static String getOriginalQueryString(HttpServletRequest req) {
        String qs = (String)req.getAttribute(ORIG_QUERY_STRING);
        return qs == null ? req.getQueryString() : qs;
    }

    public static long parseLongFromRequest(String paramName, long defaultVal, HttpServletRequest request) {
        Long l2 = ServletUtils.parseLongFromRequest(paramName, request);
        if (l2 == null) {
            return defaultVal;
        }
        return l2;
    }

    public static boolean parseBooleanFromRequest(String name, boolean defaultValue, HttpServletRequest request) {
        String val = request.getParameter(name);
        return Strings.isNullOrEmpty((String)name) ? defaultValue : "true".equalsIgnoreCase(val);
    }

    public static Long parseLongFromRequest(String paramName, HttpServletRequest request) {
        String str = request.getParameter(paramName);
        if (str != null) {
            try {
                return Long.valueOf(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String decodeString(String s2) {
        return s2 == null ? "" : UrlEncoded.decodeString((String)s2, (int)0, (int)s2.length(), (String)"UTF-8");
    }

    public static void forward(String jspFile, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        req.getRequestDispatcher(jspFile).forward((ServletRequest)req, (ServletResponse)resp);
    }

    public static Map<String, String[]> copyParameterMap(Map<String, String[]> parameterMap) {
        HashMap<String, String[]> copy = new HashMap<String, String[]>();
        for (Map.Entry<String, String[]> e2 : parameterMap.entrySet()) {
            copy.put(e2.getKey(), (String[])e2.getValue().clone());
        }
        return copy;
    }

    public static String toQueryString(Map<String, String[]> params) {
        UrlHelper helper = new UrlHelper();
        for (Map.Entry<String, String[]> e2 : params.entrySet()) {
            for (String s2 : e2.getValue()) {
                helper.putMulti(e2.getKey(), s2);
            }
        }
        return helper.toString();
    }

    public static String getBaseUrl(HttpServletRequest req) {
        String ctx;
        StringBuilder url = new StringBuilder(48);
        String scheme = req.getScheme();
        url.append(scheme);
        url.append("://");
        url.append(req.getServerName());
        int port = req.getServerPort();
        if (port > 0 && (scheme.equalsIgnoreCase("http") && port != 80 || scheme.equalsIgnoreCase("https") && port != 443)) {
            url.append(':');
            url.append(port);
        }
        if (StringUtils.isNotEmpty((String)(ctx = req.getContextPath())) && !ctx.startsWith("/")) {
            url.append("/");
        }
        url.append(ctx);
        return url.toString();
    }

    public static List<Object> asList(Object o2) {
        return Arrays.asList(o2);
    }

    public static String getSanitisedURL(HttpServletRequest req) {
        return ServletUtils.getSanitisedURL(req.getRequestURI());
    }

    public static String getSanitisedReferer(HttpServletRequest req) {
        return ServletUtils.getSanitisedURL(req.getHeader("Referer"));
    }

    public static String getSanitisedURL(String url) {
        if (url == null) {
            return null;
        }
        int queryStart = url.indexOf(63);
        if (queryStart != -1) {
            url = url.substring(0, queryStart);
        }
        url = ServletUtils.decodeString(url);
        return url;
    }
}

