/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.search.SearchResults;
import com.cenqua.fisheye.search.SimpleSearchParameters;
import com.cenqua.fisheye.search.query.AndClause;
import com.cenqua.fisheye.search.query.Clause;
import com.cenqua.fisheye.search.query.CsidExactMatchClause;
import com.cenqua.fisheye.search.query.FishQuery;
import com.cenqua.fisheye.search.query.PathClause;
import com.cenqua.fisheye.search.query.ReturnClause;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.web.UrlHelper;
import com.cenqua.fisheye.web.paging.TotalCountAwarePagingCalculator;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class SearchResultsExplorer {
    private final SearchResults hits;
    private UrlHelper baseUrl;
    private TotalCountAwarePagingCalculator pages = null;
    private GroupRowsQueryBuilder groupRowsQueryBuilder = null;
    private String pageUrl;

    public SearchResultsExplorer(SearchResults hits) {
        this.hits = hits;
        if (!hits.hasTabularResults()) {
            ReturnClause md = new ReturnClause();
            for (String column : SimpleSearchParameters.DEFAULT_COLUMNS) {
                md.addField(SimpleSearchParameters.parseReturnField(column));
            }
            hits.setReturnClause(md);
        }
    }

    public void init(HttpServletRequest req, UrlHelper base) {
        this.baseUrl = base;
        if (this.isHasAggregates()) {
            this.groupRowsQueryBuilder = new GroupRowsQueryBuilder();
        }
        this.pages = TotalCountAwarePagingCalculator.getPagingCalculator(req, this.hits.getTabularSize());
        UrlHelper rowLinkHelper = this.baseUrl.getClone();
        rowLinkHelper.putParam("ql", this.hits.getQuery().makeQueryString());
        rowLinkHelper.putParam("page", this.pages.getPage());
        this.pageUrl = rowLinkHelper.getUrlAndParams();
    }

    public UrlHelper getBaseUrl() {
        return this.baseUrl;
    }

    public boolean isEmpty() {
        return this.hits.getTabularSize() == 0;
    }

    public TotalCountAwarePagingCalculator getPagingCalculator() {
        return this.pages;
    }

    protected void setPagingCalculator(TotalCountAwarePagingCalculator pagingCalculator) {
        this.pages = pagingCalculator;
    }

    public int getSize() {
        return this.hits.getTabularSize();
    }

    public Iterator getItems() throws DbException {
        final int start = this.pages.getCurrentPageStart();
        final int end = this.pages.getCurrentPageEnd();
        final SearchResults.RevisionResultsIterator iter = this.hits.iterateRevisions(start);
        return new Iterator(){
            int i;
            {
                this.i = start;
            }

            @Override
            public boolean hasNext() {
                return this.i < end;
            }

            public Object next() {
                ++this.i;
                return iter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public TabularRowDetailIterator getTabularRows() throws DbException {
        return new TabularRowDetailIterator(this.pages.getCurrentPageStart(), this.pages.getCurrentPageEnd());
    }

    public List<Pair<String, String>> getTabularColumnNames() {
        ReturnClause md = this.hits.getReturnClause();
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>(md.numFields());
        for (ReturnClause.Field field : md.getFields()) {
            result.add(Pair.newInstance(field.getColumnName(), field.getHumanReadableColumnName()));
        }
        return result;
    }

    public List<GroupItem> getGroups() throws Exception {
        int start = this.pages.getCurrentPageStart();
        int end = this.pages.getCurrentPageEnd();
        SearchResults.RevisionResultsIterator iter = this.hits.iterateRevisions(start);
        ArrayList<GroupItem> groups = new ArrayList<GroupItem>(end - start);
        GroupItem group = null;
        for (int i2 = start; i2 < end; ++i2) {
            FileRevision item = iter.nextItem();
            boolean startOfGroup = iter.isStartOfGroup();
            if (group == null || startOfGroup) {
                group = new GroupItem(!startOfGroup);
                groups.add(group);
            }
            group.add(item);
        }
        if (group != null && iter.hasNext()) {
            iter.nextItem();
            if (!iter.isStartOfGroup()) {
                group.setMoreItemsInGroup(true);
            }
        }
        return groups;
    }

    public String getTabularResultType() {
        if (this.isHasAggregates()) {
            return this.hits.getGroupByTerm().getAggregateResultType();
        }
        return "revision";
    }

    public String getTabularResultsType() {
        boolean plural;
        boolean bl = plural = this.hits.getTabularSize() > 1;
        if (this.hits.getTabularSize() > 1) {
            if (this.isHasAggregates()) {
                return this.hits.getGroupByTerm().getAggregatesResultsType();
            }
            return "revisions";
        }
        return this.getTabularResultType();
    }

    public String getResultType() {
        return this.hits.getType();
    }

    public boolean isTabularData() {
        return this.hits.hasTabularResults();
    }

    public boolean isHasAggregates() {
        return this.hits.getReturnClause().hasAggregates();
    }

    public boolean isLimited() {
        return this.hits.isLimited();
    }

    public int getPreLimitSize() {
        return this.hits.getPreLimitSize();
    }

    public int getLimitOffset() {
        return this.hits.getLimitOffset();
    }

    public int getLimitDuration() {
        return this.hits.getLimitDuration();
    }

    public String getUrl() {
        return this.baseUrl.getUrl();
    }

    public String getParams() {
        String params = this.baseUrl.getParamString();
        if (!Strings.isNullOrEmpty((String)params)) {
            params = params.substring(1);
        }
        return params;
    }

    public String getUrlWithParams() {
        return this.baseUrl.getUrlAndParams();
    }

    public String getPageUrl(int page) {
        UrlHelper url = this.baseUrl.getClone();
        url.putParam("page", page);
        return url.toString();
    }

    public class GroupRowsQueryBuilder {
        private FishQuery query;
        private Clause originalClause;

        public GroupRowsQueryBuilder() {
            this.query = SearchResultsExplorer.this.hits.getQuery().getShallowCopy();
            this.query.setGroupBy(FishQuery.GroupBy.NONE);
            ReturnClause rc = new ReturnClause();
            rc.addField(new ReturnClause.PathField());
            for (ReturnClause.Field field : this.query.getReturnClause().getFields()) {
                if (field instanceof ReturnClause.AggregateField) {
                    field = ((ReturnClause.AggregateField)field).getReferencedField();
                }
                if (field instanceof ReturnClause.PathField) continue;
                rc.addField(field);
            }
            this.query.setReturnClause(rc);
            this.originalClause = this.query.getWhereClause();
        }

        public String getURLFor(SearchResults.ResultRow row) {
            if (SearchResultsExplorer.this.hits.getGroupByTerm() != FishQuery.GroupBy.NONE) {
                Clause groupWhere = null;
                switch (SearchResultsExplorer.this.hits.getGroupByTerm()) {
                    case FILE: {
                        groupWhere = new PathClause(row.getCurrentGroupHumanReadable(), false, false);
                        break;
                    }
                    case CHANGESET: {
                        groupWhere = new CsidExactMatchClause(row.getCurrentGroupHumanReadable());
                        break;
                    }
                    case DIRECTORY: {
                        groupWhere = new PathClause(row.getCurrentGroupHumanReadable() + "/*", true, false);
                    }
                }
                if (this.originalClause != null) {
                    AndClause whereClause = new AndClause();
                    whereClause.addClause(groupWhere);
                    whereClause.addClause(this.originalClause);
                    this.query.setWhereClause(whereClause);
                } else {
                    this.query.setWhereClause(groupWhere);
                }
            } else {
                this.query.setWhereClause(this.originalClause);
            }
            String eyeQL = this.query.makeQueryString();
            UrlHelper groupingQuery = SearchResultsExplorer.this.baseUrl.getClone();
            groupingQuery.putParam("ql", eyeQL);
            return groupingQuery.getUrlAndParams();
        }
    }

    public static class GroupItem {
        private final List<FileRevision> items = new LinkedList<FileRevision>();
        private final boolean previousItemsInGroup;
        private boolean moreItemsInGroup = false;

        public GroupItem(boolean previousItemsInGroup) {
            this.previousItemsInGroup = previousItemsInGroup;
        }

        void add(FileRevision item) {
            this.items.add(item);
        }

        void setMoreItemsInGroup(boolean moreItemsInGroup) {
            this.moreItemsInGroup = moreItemsInGroup;
        }

        public boolean isPreviousItemsInGroup() {
            return this.previousItemsInGroup;
        }

        public boolean isMoreItemsInGroup() {
            return this.moreItemsInGroup;
        }

        public FileRevision getFirst() {
            return this.items.get(0);
        }

        public List<FileRevision> getItems() {
            return this.items;
        }

        public Set<Integer> getReviewIds() {
            LinkedHashSet<Integer> reviewIds = new LinkedHashSet<Integer>();
            for (FileRevision frx : this.items) {
                reviewIds.addAll(frx.getReviewIds());
            }
            return reviewIds;
        }
    }

    public static class CellDetail {
        private final SearchResults.ResultRow row;
        private final int index;
        private final ReturnClause.Field field;

        public CellDetail(SearchResults.ResultRow row, int index, ReturnClause.Field field) {
            this.row = row;
            this.index = index;
            this.field = field;
        }

        public boolean isNumber() {
            return this.field.isInt();
        }

        public boolean isDate() {
            return this.field.isDate();
        }

        public String getField() {
            return this.field.getField();
        }

        public String getColumnName() {
            return this.field.getColumnName();
        }

        public String getHumanColumnName() {
            return this.field.getHumanReadableColumnName();
        }

        public String getAsString() {
            return this.row.getString(this.index);
        }

        public String getAsDisplayString() {
            return this.row.getDisplayString(this.index);
        }

        public String getAsStringArray() {
            return this.row.getStringFromArray(this.index);
        }

        public Map[] getAsMapArray() {
            return this.row.getMapArray(this.index);
        }

        public Path getAsPath() {
            return this.row.getPath(this.index);
        }

        public int getAsInt() {
            return this.row.getInt(this.index);
        }

        public long getAsDate() {
            return this.row.getDate(this.index);
        }

        public Date getAsDateValue() {
            return new Date(this.row.getDate(this.index));
        }

        public Collection getAsList() {
            return this.row.getList(this.index);
        }

        public String toString() {
            return this.index + ":(" + this.field.getHumanReadableColumnName() + "):" + this.getAsDisplayString();
        }
    }

    public static class RowDetail {
        private final SearchResults.ResultRow row;
        private final int rowIndex;
        private final boolean startOfGroup;
        private final ReturnClause metadata;

        public RowDetail(SearchResults.ResultRow row, int rowIndex, boolean startOfGroup, ReturnClause metadata) {
            this.row = row;
            this.rowIndex = rowIndex;
            this.startOfGroup = startOfGroup;
            this.metadata = metadata;
        }

        public boolean isStartOfGroup() {
            return this.startOfGroup;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public String getGroupTitle() {
            return this.row.getCurrentGroupHumanReadable();
        }

        public List<CellDetail> getColumns() {
            ArrayList<CellDetail> result = new ArrayList<CellDetail>();
            for (int i2 = 0; i2 < this.metadata.numFields(); ++i2) {
                ReturnClause.Field field = this.metadata.getField(i2);
                result.add(new CellDetail(this.row, i2, field));
            }
            return result;
        }
    }

    public class TabularRowDetailIterator
    implements Iterator<RowDetail> {
        private int pos;
        private final int end;
        private final SearchResults.TabularResultsIterator iter;
        private SearchResults.ResultRow currentRow;

        public TabularRowDetailIterator(int start, int end) throws DbException {
            this.pos = start;
            this.end = end;
            this.iter = SearchResultsExplorer.this.hits.iterateData(start);
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.end;
        }

        @Override
        public RowDetail next() {
            try {
                this.currentRow = this.iter.nextRow();
                boolean startOfGroup = !SearchResultsExplorer.this.hits.isGrouped() || this.iter.isStartOfGroup();
                RowDetail rowDetail = new RowDetail(this.currentRow, this.pos, startOfGroup, SearchResultsExplorer.this.hits.getReturnClause());
                ++this.pos;
                return rowDetail;
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public String getCurrentGroupRowsQueryURL() {
            if (SearchResultsExplorer.this.groupRowsQueryBuilder != null) {
                return SearchResultsExplorer.this.groupRowsQueryBuilder.getURLFor(this.currentRow);
            }
            throw new RuntimeException("Attempt to get current group query url when no groups!");
        }

        public int getCurrentRowIndex() {
            return SearchResultsExplorer.this.getLimitOffset() + this.pos;
        }

        public String getCurrentRowsURL() {
            return SearchResultsExplorer.this.pageUrl + "#" + this.getCurrentRowIndex();
        }
    }
}

