/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.search.SearchManager;
import com.cenqua.fisheye.search.SearchResults;
import com.cenqua.fisheye.search.SimpleSearchParameters;
import com.cenqua.fisheye.search.query.FishQuery;
import com.cenqua.fisheye.search.query.ReturnClause;
import com.cenqua.fisheye.util.CsvWriter;
import com.cenqua.fisheye.web.BaseAction;
import com.cenqua.fisheye.web.FisheyeRepositoryExplorer;
import com.cenqua.fisheye.web.SearchResultsExplorer;
import com.cenqua.fisheye.web.UrlHelper;
import com.cenqua.fisheye.web.parameterbeans.BaseActionParams;
import com.cenqua.fisheye.web.parameterbeans.SearchRepositoryServletParams;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SearchRepositoryServlet
extends BaseAction {
    @Override
    public long computeLastModified() {
        return this.computeRepositoryLastModified();
    }

    @Override
    public BaseAction handleRequest(BaseActionParams baseParams) throws ServletException, DbException, IOException {
        RepositoryEngine engine = this.getPathInfo().getEngine();
        Path lpath = this.getPathInfo().getLocalPath();
        SearchRepositoryServletParams params = new SearchRepositoryServletParams(baseParams, new FisheyeRepositoryExplorer(engine, Path.ROOT, this.waybackSpec, this.getUserPreferences()), this.waybackSpec, FishQuery.GroupBy.fromString(this.getRequest().getParameter("groupby")));
        this.getRequest().setAttribute("p", (Object)params);
        RevisionCache<? extends ChangeSet> rep = engine.getRevisionCache();
        if (rep.isFile(lpath)) {
            lpath = lpath.getParent();
        }
        if (!rep.isDir(lpath)) {
            lpath = Path.ROOT;
        }
        this.doSearch(this.getPathInfo().getLocalPath(), lpath, params);
        return null;
    }

    private void doSearch(Path fpath, Path path, SearchRepositoryServletParams jspParams) throws ServletException, IOException, DbException {
        FishQuery query;
        RepositoryConfig rcfg = this.getPathInfo().getRepository();
        RepositoryEngine engine = this.getPathInfo().getEngine();
        HttpServletRequest req = this.getRequest();
        Path searchPath = path;
        String searchAllDirsStr = req.getParameter("searchAllDirs");
        if (searchAllDirsStr != null && "true".equals(searchAllDirsStr)) {
            searchPath = Path.ROOT;
        }
        ArrayList<String> errors = new ArrayList<String>(1);
        jspParams.setErrors(errors);
        String ql = req.getParameter("ql");
        UrlHelper searchUrl = new UrlHelper();
        searchUrl.setUrl(req.getContextPath() + "/search/" + rcfg.getName() + "/" + path.getPath());
        if (ql != null) {
            jspParams.setQlStr(ql);
            jspParams.setAdvanced("true");
            searchUrl.getParams().put("ql", ql);
            query = ql.trim().length() > 0 ? FishQuery.parse(ql, errors) : null;
        } else {
            SimpleSearchParameters params = new SimpleSearchParameters(req);
            query = params.parseUserData(searchPath, searchUrl);
            if (query != null) {
                jspParams.setQlStr(query.makeQueryString());
            }
        }
        if (query != null) {
            if (query.getFromPath() == null) {
                query.setFromPath(searchPath);
            }
            try {
                SearchManager searcher = engine.getSearchManager();
                boolean refresh = req.getParameter("refresh") != null;
                SearchResults collator = searcher.runQuery(query, refresh);
                if (req.getParameter("csv") != null) {
                    if (collator.hasTabularResults()) {
                        this.sendAsCsv(collator);
                        return;
                    }
                    errors.add("You need tabular data to produce it as CSV (use the 'return', 'calculate' and/or 'calculate group' EyeQL clause).");
                }
                SearchResultsExplorer results = new SearchResultsExplorer(collator);
                results.init(req, searchUrl);
                jspParams.setResults(results);
            }
            catch (Exception e2) {
                Logs.APP_LOG.warn((Object)"error doing search", (Throwable)e2);
                errors.add("General search term error:" + e2.getMessage());
            }
        }
        jspParams.setPath(path);
        jspParams.setFpath(new Path(new Path(rcfg.getName()), fpath.getPath()));
        jspParams.setAuthors(this.getRepositoryCache().findAuthors(path));
        req.getRequestDispatcher("/WEB-INF/jsp/search/searchresults.jsp").forward((ServletRequest)req, (ServletResponse)this.getResponse());
    }

    private void sendAsCsv(SearchResults results) throws IOException, DbException {
        HttpServletResponse resp = this.getResponse();
        resp.setContentType("text/plain");
        resp.setCharacterEncoding("UTF-8");
        PrintWriter out = resp.getWriter();
        ReturnClause md = results.getReturnClause();
        CsvWriter csv = new CsvWriter(out);
        for (int c2 = 0; c2 < md.numFields(); ++c2) {
            ReturnClause.Field f2 = md.getField(c2);
            csv.writeHeaderColumn(f2.getColumnName());
        }
        csv.endHeader();
        SearchResults.TabularResultsIterator rows = results.iterateData(0);
        while (rows.hasNext()) {
            SearchResults.ResultRow row = rows.next();
            block8: for (int c3 = 0; c3 < md.numFields(); ++c3) {
                ReturnClause.Field f3 = md.getField(c3);
                switch (f3.getType()) {
                    case INTEGER: {
                        csv.writeInt(row.getInt(c3));
                        continue block8;
                    }
                    case DATE: {
                        csv.writeDate(row.getDate(c3));
                        continue block8;
                    }
                    case STRING_ARRAY: {
                        csv.writeStringArray(row.getStringArray(c3));
                        continue block8;
                    }
                    case MAP_ARRAY: {
                        Map[] maps = row.getMapArray(c3);
                        String[] reviews = new String[maps.length];
                        for (int i2 = 0; i2 < row.getMapArray(c3).length; ++i2) {
                            Map map = row.getMapArray(c3)[i2];
                            reviews[i2] = (String)map.get("id");
                        }
                        csv.writeStringArray(reviews);
                        continue block8;
                    }
                    default: {
                        csv.writeString(row.getString(c3));
                    }
                }
            }
            csv.endRow();
        }
        ((Writer)out).close();
    }
}

