/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.bucket.BucketDataCollectionTotalled;
import com.atlassian.fisheye.bucket.BucketDataTotalled;
import com.atlassian.fisheye.bucket.ParameterSetQuery;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.crossrepo.ChangesetQueryBuilder;
import com.cenqua.fisheye.csindex.ChangesetStatsCalculator;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.web.SortableListAction;
import com.cenqua.fisheye.web.TableDisplayData;
import com.cenqua.fisheye.web.paging.PagingCalculator;
import com.cenqua.fisheye.web.paging.TotalCountAwarePagingCalculator;
import com.cenqua.fisheye.web.util.RepositoryUtil;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class RepositoryListAction
extends SortableListAction
implements ServletRequestAware {
    private HttpServletRequest request;
    private List<RepositoryTableData> repositories = new ArrayList<RepositoryTableData>();
    private ReviewManager reviewManager;
    private PagingCalculator pagingData;
    private boolean locEnabled = false;

    @Autowired
    public void setReviewManager(ReviewManager reviewManager) {
        this.reviewManager = reviewManager;
    }

    @RequireSecurityToken(value=false)
    public String doList() throws Exception {
        if (AppConfig.isCrucibleOnly()) {
            return "404";
        }
        this.monitor = new ActivitySearchMonitor(Long.valueOf(this.timeout));
        List<RepositoryTableData> allRepositories = this.getAllRepositories();
        this.sort(allRepositories);
        this.pagingData = TotalCountAwarePagingCalculator.getPagingCalculator(this.request, allRepositories.size());
        this.repositories = allRepositories.subList(this.pagingData.getCurrentPageStart(), this.pagingData.getCurrentPageEnd());
        this.completeRepositoryData(this.repositories);
        return "success";
    }

    private List<RepositoryTableData> getAllRepositories() throws Exception {
        ArrayList<RepositoryTableData> repositories = new ArrayList<RepositoryTableData>();
        List<RepositoryHandle> handles = RepositoryUtil.repositories(this.request);
        for (RepositoryHandle handle : handles) {
            long loc = 0L;
            long numCommits = 0L;
            String repname = handle.getName();
            boolean timedOut = this.monitor.isTimeExceeded();
            if (timedOut) {
                this.monitor.setSearchTruncated(true);
            } else if (handle.isRunning() && (this.isSortByCommits() || this.isSortByLoc())) {
                ChangesetStatsCalculator calc = new ChangesetStatsCalculator(((ChangesetQueryBuilder)ChangesetQueryBuilder.newBuilder(repname).changesetsOnly()).build());
                RepositoryEngine engine = handle.acquireEngine();
                if (this.isSortByCommits()) {
                    numCommits = calc.count(engine.getCrossRepLuceneConnection());
                }
                if (this.isSortByLoc()) {
                    loc = this.calculateLoc(engine);
                }
            }
            if (handle.isRunning() && handle.getCfg().isLocEnabled()) {
                this.locEnabled = true;
            }
            repositories.add(new RepositoryTableData(loc, repname, numCommits, handle, timedOut, handle.getCfg().isLocEnabled()));
        }
        return repositories;
    }

    private boolean isSortByLoc() {
        return this.getSortComparator() == TableDisplayData.ColumnComparators.LOC;
    }

    private boolean isSortByCommits() {
        return this.getSortComparator() == TableDisplayData.ColumnComparators.COMMITS;
    }

    private void completeRepositoryData(List<RepositoryTableData> repositories) throws Exception {
        for (RepositoryTableData rep : repositories) {
            boolean timedOut = this.monitor.isTimeExceeded();
            if (timedOut) {
                this.monitor.setSearchTruncated(true);
                continue;
            }
            if (!rep.getRepositoryHandle().isRunning()) continue;
            ChangesetStatsCalculator calc = new ChangesetStatsCalculator(((ChangesetQueryBuilder)ChangesetQueryBuilder.newBuilder(rep.getDisplayName()).changesetsOnly()).build());
            RepositoryEngine engine = rep.getRepositoryHandle().acquireEngine();
            if (!this.isSortByCommits()) {
                rep.setNumCommits(calc.count(engine.getCrossRepLuceneConnection()));
            }
            if (this.isSortByLoc()) continue;
            rep.setLoc(this.calculateLoc(engine));
        }
    }

    private long calculateLoc(RepositoryEngine engine) throws DbException {
        if (!engine.getCfg().isLocEnabled()) {
            return 0L;
        }
        long loc = 0L;
        BucketDataCollectionTotalled buckets = engine.getBucketGraph().getBuckets(new ParameterSetQuery());
        for (Map.Entry e2 : buckets.entrySet()) {
            loc += (long)((BucketDataTotalled)e2.getValue()).getTotalLoc();
        }
        return loc;
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public List<RepositoryTableData> getRepositories() {
        return this.repositories;
    }

    public PagingCalculator getPagingCalculator() {
        return this.pagingData;
    }

    public boolean isLocEnabled() {
        return this.locEnabled;
    }

    public static class RepositoryTableData
    extends TableDisplayData {
        private final boolean running;
        private final RepositoryHandle repositoryHandle;
        private final boolean timedOut;
        private final boolean locEnabled;

        private RepositoryTableData(long loc, String name, long numCommits, RepositoryHandle repositoryHandle, boolean timedOut, boolean locEnabled) {
            super(name, loc, numCommits, 0L, repositoryHandle.getStateDescription());
            this.running = repositoryHandle.isRunning();
            this.repositoryHandle = repositoryHandle;
            this.timedOut = timedOut;
            this.locEnabled = locEnabled;
        }

        public boolean isRunning() {
            return this.running;
        }

        public RepositoryHandle getRepositoryHandle() {
            return this.repositoryHandle;
        }

        public boolean isTimedOut() {
            return this.timedOut;
        }

        public boolean isLocEnabled() {
            return this.locEnabled;
        }
    }
}

