/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.fisheye.spi.TxTemplate;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.web.util.RepositoryUtil;
import com.opensymphony.xwork.ActionSupport;
import javax.annotation.Resource;

public abstract class RepositoryAction
extends ActionSupport {
    @Resource
    private TxTemplate txTemplate;
    @Resource
    private RepositoryManager repositoryManager;

    protected RepositoryHandle getRepositoryHandle(String repName) throws RepositoryPermissionException {
        if (RepositoryUtil.hasPermission(this.txTemplate.getEffectivePrincipal(), repName)) {
            return this.repositoryManager.getRepository(repName);
        }
        throw new RepositoryPermissionException(repName);
    }

    public class RepositoryPermissionException
    extends Exception {
        private RepositoryPermissionException(String repName) {
            super("The user '" + RepositoryAction.this.txTemplate.getEffectivePrincipal().getDisplayName() + "' does not have permission to access the repository '" + repName + "'");
        }
    }
}

