/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.crucible.spi.services.GlobalPermissionService;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.UserProfile;
import com.atlassian.fecru.user.UserProfileManager;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivityStreamHandler;
import com.atlassian.fisheye.activity.RepositoryConstraints;
import com.atlassian.fisheye.bucket.BucketDataCollectionTotalled;
import com.atlassian.fisheye.bucket.BucketDataElementTotalled;
import com.atlassian.fisheye.bucket.BucketDataTotalled;
import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.ParameterSetQuery;
import com.atlassian.fisheye.bucket.PeriodUnit;
import com.atlassian.fisheye.user.RecentlyVisitedManager;
import com.atlassian.fisheye.user.model.RecentlyVisitedItem;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.tags.ProjectUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.csindex.ChangesetStatsCalculator;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.model.ContentRoot;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.ServletUtils;
import com.cenqua.fisheye.web.util.RepositoryUtil;
import com.google.common.base.Strings;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import com.opensymphony.webwork.interceptor.ServletResponseAware;
import com.opensymphony.xwork.ActionSupport;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ProjectPageAction
extends ActionSupport
implements ServletRequestAware,
ServletResponseAware {
    @Resource
    private ProjectManager manager;
    @Resource
    private UserManager userManager;
    @Resource
    private RepositoryManager repositoryManager;
    @Resource
    private UserProfileManager userProfileManager;
    @Resource
    private PermissionManager permissionManager;
    @Resource
    private CommitterUserMappingManager committerUserMappingManager;
    @Resource
    private GlobalPermissionService globalPermissionService;
    private CrossRepLuceneIndex crossRepLuceneIndex = AppConfig.getsConfig().getCrossRepLuceneIndex();
    private Project project;
    private int loc;
    private String projectKey;
    private Set<ContentRoot> paths;
    private HttpServletResponse response;
    private HttpServletRequest request;
    private ActivityStreamHandler activityHandler;
    private String view = "all";
    private RepositoryHandle defaultRep = null;
    private int commitsThisWeek = 0;
    private int totalCommits = 0;
    private int locThisWeek = 0;
    private Date lastCommit = new Date(0L);
    private Set<RepositoryStatus> slurpWarningReps = new HashSet<RepositoryStatus>();
    private Boolean locEnabled = false;

    public void validate() {
        if (this.projectKey != null) {
            this.project = this.manager.getProjectByKey(this.projectKey);
            if (this.project == null) {
                Logs.APP_LOG.debug((Object)("could not find " + this.projectKey));
                this.projectKey = null;
                return;
            }
            UserLogin userLogin = this.userManager.getCurrentUser(this.request);
            if (!this.canUserViewProject(userLogin) && userLogin != null) {
                Logs.APP_LOG.debug((Object)("permission denied for " + this.projectKey));
                this.projectKey = null;
                this.project = null;
                return;
            }
        }
    }

    private boolean canUserViewProject(UserLogin userLogin) {
        return this.permissionManager.isProjectVisible(userLogin, this.project);
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        if (this.projectKey == null || this.project == null) {
            ServletUtils.send404(this.request, this.response, "No such project");
            return "none";
        }
        UserLogin userLogin = this.userManager.getCurrentUser(this.request);
        if (!this.canUserViewProject(userLogin) && userLogin == null) {
            return "login";
        }
        this.updateRecentProjects();
        this.paths = !AppConfig.getsConfig().getLicense().isCrucibleOnly() ? this.filterOnPermission(this.project.getContentRoots()) : Collections.emptySet();
        this.collectAllStats();
        String result = super.execute();
        if ("success".equals(result) && "true".equals(this.request.getParameter("RSS"))) {
            this.request.setAttribute("activityStreamRSS", (Object)this.getActivityHandler());
            return "success-rss";
        }
        if ("success".equals(result) && "true".equals(this.request.getParameter("activityAjax"))) {
            this.getActivityHandler();
            return "activity-ajax";
        }
        return result;
    }

    private void updateRecentProjects() {
        FecruUser user = this.userManager.getUserFor(this.getCurrentUser());
        if (user != null) {
            RecentlyVisitedManager recentlyVisitedManager = SpringContext.getComponentByClass(RecentlyVisitedManager.class);
            recentlyVisitedManager.addItemToHistory(RecentlyVisitedItem.Type.PROJECT, user, this.project.getProjKey());
        }
    }

    private Set<ContentRoot> filterOnPermission(Set<ContentRoot> contentRoots) {
        HashSet<ContentRoot> filtered = new HashSet<ContentRoot>(contentRoots.size());
        for (ContentRoot contentRoot : contentRoots) {
            RepositoryHandle repHandle = contentRoot.getRepHandle();
            if (repHandle == null || !RepositoryUtil.hasPermission(this.getCurrentUser(), repHandle)) continue;
            filtered.add(contentRoot);
        }
        return filtered;
    }

    private void accumulateStats(BucketDataCollectionTotalled data, TimeZone tz) {
        int loc = 0;
        int locThisWeek = 0;
        Object bucketData1 = data.getLast();
        if (bucketData1 != null) {
            int oneWeekAgo = PeriodUnit.DAY.dateToBucket(System.currentTimeMillis(), tz) - 7;
            for (Map.Entry entry : data.entrySet()) {
                for (Int2ObjectMap.Entry e2 : ((BucketDataTotalled)entry.getValue()).getData().int2ObjectEntrySet()) {
                    BucketDataElementTotalled bde = (BucketDataElementTotalled)e2.getValue();
                    int bucket = e2.getIntKey();
                    if (bucket > oneWeekAgo) {
                        locThisWeek += bde.getLinecountChange();
                    }
                    loc += bde.getLinecountChange();
                }
            }
        }
        this.loc += loc;
        this.locThisWeek += locThisWeek;
    }

    private void collectAllStats() throws RepositoryHandle.StateException, DbException {
        RepositoryHandle defaultRepHandle;
        this.clearAll();
        String defaultRepositoryName = this.project.getDefaultRepositoryNameIfFisheyeRepository();
        if (!Strings.isNullOrEmpty((String)defaultRepositoryName) && (defaultRepHandle = this.repositoryManager.getRepository(defaultRepositoryName)) != null && RepositoryUtil.hasPermission(this.getCurrentUser(), defaultRepHandle)) {
            this.defaultRep = defaultRepHandle;
            this.slurpWarningReps.add(this.defaultRep.getStatus());
        }
        RepositoryConstraints repositoryConstraints = ProjectUtil.generateRepositoryConstraint(this.project);
        for (String rep : repositoryConstraints.getReps()) {
            RepositoryHandle repHandle = this.repositoryManager.getRepository(rep);
            if (repHandle == null || !RepositoryUtil.hasPermission(this.getCurrentUser(), repHandle)) continue;
            this.slurpWarningReps.add(repHandle.getStatus());
            if (repositoryConstraints.isIncludeWholeRepository(rep)) {
                this.getStatsForPath(Path.ROOT, repHandle);
                this.accumulateChangesetStats(repHandle, Path.ROOT, AppConfig.getUserTimeZone(this.request));
            } else {
                for (Path path : repositoryConstraints.getConstraintsForRep(rep).getPaths()) {
                    this.getStatsForPath(path, repHandle);
                    this.accumulateChangesetStats(repHandle, path, AppConfig.getUserTimeZone(this.request));
                }
            }
            if (!repHandle.isRunning() || !repHandle.getCfg().isLocEnabled()) continue;
            this.locEnabled = true;
        }
    }

    private void getStatsForPath(Path path, RepositoryHandle repHandle) {
        try {
            BucketGraph bucketGraph = repHandle.acquireEngine().getBucketGraph();
            ParameterSetQuery queryParams = new ParameterSetQuery();
            queryParams.setPath(path);
            BucketDataCollectionTotalled repData = bucketGraph.getBuckets(queryParams);
            if (repData.collectionCount() > 0) {
                this.accumulateStats(repData, bucketGraph.getTimeZone());
            }
        }
        catch (DbException e2) {
            Logs.APP_LOG.debug((Object)"DbException", (Throwable)e2);
        }
        catch (RepositoryHandle.StateException e3) {
            Logs.APP_LOG.debug((Object)"Repository State Exception", (Throwable)((Object)e3));
        }
    }

    public Set<ContentRoot> getPaths() {
        return this.paths;
    }

    public void setPaths(Set<ContentRoot> paths) {
        this.paths = paths;
    }

    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        this.view = view;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public int getLoc() {
        return this.loc;
    }

    public void setLoc(int loc) {
        this.loc = loc;
    }

    public void clearAll() {
        this.loc = 0;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = Project.upperCaseProjectKey(projectKey);
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public ActivityStreamHandler getActivityHandler() throws IOException, ServletException {
        if (this.activityHandler == null) {
            this.activityHandler = new ActivityStreamHandler(this.globalPermissionService, this.repositoryManager, null, null, null, false, false, this.committerUserMappingManager);
            int numItems = this.getUserProfile().getChangesetsPerPage();
            TimeZone tz = AppConfig.getsConfig().getTimezone();
            ActivityItemSearchParams searchParams = ActivityItemSearchParams.Builder.fromParams(ActivityStreamHandler.constructSearchParams(this.request, numItems, tz, this.view)).project(this.project).build();
            this.activityHandler.handleActivityStream(this.request, this.response, searchParams, this.getCurrentUser(), numItems, this.view, false);
        }
        return this.activityHandler;
    }

    public void setActivityHandler(ActivityStreamHandler activityHandler) {
        this.activityHandler = activityHandler;
    }

    private UserProfile getUserProfile() {
        UserProfile profile = UserProfileManager.DEFAULT_PROFILE;
        if (this.getCurrentUser() != null) {
            try {
                profile = this.userProfileManager.getProfile(this.getCurrentUser().getUserName());
            }
            catch (DbException e2) {
                Logs.APP_LOG.warn((Object)("unable to get user profile for principal '" + this.getCurrentUser() + "'"), (Throwable)e2);
            }
        }
        return profile;
    }

    private Principal getCurrentUser() {
        return this.userManager.getCurrentUser(this.request);
    }

    public RepositoryHandle getDefaultRep() {
        return this.defaultRep;
    }

    public int getCommitsThisWeek() {
        return this.commitsThisWeek;
    }

    public int getTotalCommits() {
        return this.totalCommits;
    }

    public int getLocThisWeek() {
        return this.locThisWeek;
    }

    private void accumulateChangesetStats(RepositoryHandle handle, Path path, TimeZone tz) throws DbException, RepositoryHandle.StateException {
        if (handle.isRunning()) {
            FileRevision latestFileRevision = handle.acquireEngine().getRevisionCache().getLatestFileRevision(path);
            if (latestFileRevision != null && latestFileRevision.getDate() > this.lastCommit.getTime()) {
                this.lastCommit = new Date(latestFileRevision.getDate());
            }
            ChangesetStatsCalculator calculator = new ChangesetStatsCalculator(handle.getName(), null, Collections.emptyList(), path);
            LuceneConnection<CrossRepLuceneIndexes> luceneConnection = this.crossRepLuceneIndex.getConnection();
            this.totalCommits = (int)((long)this.totalCommits + calculator.count(luceneConnection));
            Calendar calendar = Calendar.getInstance(tz);
            calendar.add(3, -1);
            ActivityItemSearchParams.Builder builder = ActivityItemSearchParams.builder().minDate(calendar.getTime());
            builder.maxItems(1).includeFisheye().timeZone(tz);
            builder.path(handle.getName(), path);
            calculator = new ChangesetStatsCalculator(builder.build());
            this.commitsThisWeek = (int)((long)this.commitsThisWeek + calculator.count(luceneConnection));
        }
    }

    public Set<RepositoryStatus> getSlurpStatuses() {
        return this.slurpWarningReps;
    }

    public Date getLastCommit() {
        return this.lastCommit;
    }

    public Boolean getLocEnabled() {
        return this.locEnabled;
    }
}

