/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.SecureProjectManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.StringComparator;
import com.cenqua.fisheye.web.paging.PagingCalculator;
import com.cenqua.fisheye.web.paging.TotalCountAwarePagingCalculator;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import com.opensymphony.xwork.ActionSupport;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

public class ProjectListAction
extends ActionSupport
implements ServletRequestAware {
    private static final String ASC = "asc";
    private static final String DESC = "desc";
    private HttpServletRequest request;
    private List<Project> projects;
    private PagingCalculator pagingData;
    private SortType sortType = SortType.PROJECT_KEY;
    private boolean descending;
    @Resource
    private SecureProjectManager secureProjectManager;
    @Resource
    private EffectiveUserProvider userProvider;

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        Principal principal = this.userProvider.getEffectivePrincipal();
        List<Project> allProjects = this.secureProjectManager.getVisibleProjects(principal);
        this.pagingData = TotalCountAwarePagingCalculator.getPagingCalculator(this.request, allProjects.size());
        Collections.sort(allProjects, this.sortType.getComparator(this.descending));
        this.projects = allProjects.subList(this.pagingData.getCurrentPageStart(), this.pagingData.getCurrentPageEnd());
        return "success";
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public List<Project> getProjects() {
        return this.projects;
    }

    public PagingCalculator getPagingCalculator() {
        return this.pagingData;
    }

    public String getSortType() {
        return this.sortType.name().toLowerCase(Locale.US);
    }

    public void setSort(String sortType) {
        try {
            this.sortType = SortType.valueOf(sortType.toUpperCase(Locale.US));
        }
        catch (Exception e2) {
            Logs.APP_LOG.debug((Object)"Unknown sortType for projectListAction", (Throwable)e2);
        }
    }

    public void setD(String direction) {
        this.descending = DESC.equals(direction);
    }

    public boolean isDescending() {
        return this.descending;
    }

    public Map<String, String> getNextSorts() {
        HashMap<String, String> nextSortsMap = new HashMap<String, String>(SortType.values().length);
        for (SortType sortType : SortType.values()) {
            nextSortsMap.put(sortType.name(), this.sortType.equals((Object)sortType) ? (this.descending ? ASC : DESC) : ASC);
        }
        return nextSortsMap;
    }

    public static enum SortType {
        PROJECT_KEY(new Comparator<Project>(){

            @Override
            public int compare(Project o1, Project o2) {
                return SortType.keyComparison(o1, o2);
            }
        }),
        REPOSITORY(new Comparator<Project>(){
            private Comparator<String> comparator = new StringComparator(true);

            @Override
            public int compare(Project o1, Project o2) {
                int ret = this.comparator.compare(o1.getDefaultRepositoryName(), o2.getDefaultRepositoryName());
                return ret == 0 ? SortType.keyComparison(o1, o2) : ret;
            }
        });

        private Comparator<Project> natural;
        private Comparator<Project> reverse;

        private SortType(final Comparator<Project> natural) {
            this.natural = natural;
            this.reverse = new Comparator<Project>(){

                @Override
                public int compare(Project o1, Project o2) {
                    return -natural.compare(o1, o2);
                }
            };
        }

        public Comparator<Project> getComparator(boolean reverseOrder) {
            return reverseOrder ? this.reverse : this.natural;
        }

        private static int keyComparison(Project o1, Project o2) {
            return o1.getProjKey().compareTo(o2.getProjKey());
        }
    }
}

