/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.fecru.properties.UserRepositoryPropertyManager;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.UserProfile;
import com.atlassian.fecru.utils.HttpUtils;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.BranchSelectorPref;
import com.cenqua.fisheye.web.CookiePreferences;
import com.google.common.base.Splitter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component(value="preferenceManager")
public class PreferenceManager {
    private static final String PREF_COOKIE_NAME = "crucibleprefs1";
    private static final String SET_PREF_COOKIE_NAME = "set_crucibleprefs1";
    private static final String ATTRIBUTE_NAME = "userPrefs";
    private static final int COOKIE_AGE = 31536000;

    public static CookiePreferences getPreferences(HttpServletRequest req) {
        CookiePreferences prefs = (CookiePreferences)req.getAttribute(ATTRIBUTE_NAME);
        if (prefs == null) {
            prefs = PreferenceManager.loadUserPreference(req);
        }
        return prefs;
    }

    public static String getPreference(HttpServletRequest req, String name) {
        return PreferenceManager.getPreferences(req).getMap().get(name);
    }

    public static String getCookieNameForPrefName(String prefName) {
        return CookiePreferences.getCookieNameForPrefName(prefName);
    }

    private Map<String, String> parsePreferencesToSetFromCookie(Cookie cookie) {
        try {
            String cookieValue = URLDecoder.decode(cookie.getValue(), "UTF-8");
            return Splitter.on((char)'&').trimResults().withKeyValueSeparator("=").split((CharSequence)cookieValue);
        }
        catch (UnsupportedEncodingException e2) {
            Logs.APP_LOG.debug((Object)("UTF-8 not supported. " + e2));
            return null;
        }
    }

    public static CookiePreferences loadUserPreference(HttpServletRequest req) {
        Cookie preferenceCookie;
        CookiePreferences prefs = null;
        UserManager um = AppConfig.getsConfig().getUserManager();
        UserLogin user = um.getCurrentUser(req);
        if (user != null) {
            try {
                UserProfile prof = AppConfig.getsConfig().getUserProfileManager().getProfile(user.getUsername());
                if (prof != null) {
                    prefs = CookiePreferences.fromString(prof.getCookiePrefs());
                }
            }
            catch (DbException e2) {
                Logs.APP_LOG.warn((Object)"error reading profile from database", (Throwable)e2);
            }
        }
        if (prefs == null && (preferenceCookie = HttpUtils.findCookieByName(req, PREF_COOKIE_NAME)) != null) {
            prefs = CookiePreferences.fromCookie(preferenceCookie);
        }
        if (prefs == null) {
            prefs = new CookiePreferences();
        }
        req.setAttribute(ATTRIBUTE_NAME, (Object)prefs);
        return prefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(HttpServletRequest req, HttpServletResponse resp) {
        CookiePreferences up = PreferenceManager.getPreferences(req);
        Cookie setPreferencesCookie = HttpUtils.findCookieByName(req, SET_PREF_COOKIE_NAME);
        if (setPreferencesCookie != null) {
            try {
                Map<String, String> preferencesToSet = this.parsePreferencesToSetFromCookie(setPreferencesCookie);
                if (preferencesToSet != null) {
                    for (Map.Entry<String, String> entry : preferencesToSet.entrySet()) {
                        String param = entry.getKey();
                        up.setValueUsingCookieName(param, entry.getValue());
                    }
                }
            }
            finally {
                Cookie cookieToRemove = (Cookie)setPreferencesCookie.clone();
                cookieToRemove.setPath(req.getContextPath());
                HttpUtils.removeCookie(resp, cookieToRemove);
            }
            if (up.isChanged()) {
                PreferenceManager.setPreferences(up, req, resp);
                req.setAttribute(ATTRIBUTE_NAME, (Object)up);
            }
        }
    }

    public static void touchCookie(HttpServletRequest req, HttpServletResponse resp) {
        PreferenceManager.setPreferences(PreferenceManager.getPreferences(req), req, resp);
    }

    public static void clearVisualisationPrefs(FecruUser user, HttpServletRequest req, HttpServletResponse resp, CookiePreferences preferences) {
        preferences.removeVisualisationPrefs();
        if (user != null) {
            user.getUserProfile().setCookiePrefs(preferences.asCookieValue());
        }
        PreferenceManager.setPreferences(preferences, req, resp);
    }

    public static void clearBranchSelectorPrefs(FecruUser user, HttpServletRequest req, HttpServletResponse resp, CookiePreferences preferences) {
        preferences.removeBranchSelectorPrefs();
        if (user != null) {
            user.getUserProfile().setCookiePrefs(preferences.asCookieValue());
        }
        PreferenceManager.setPreferences(preferences, req, resp);
    }

    public static void setPreferenceInCookie(HttpServletRequest req, HttpServletResponse resp, CookiePreferences.Pref preference, String value) {
        CookiePreferences prefs = PreferenceManager.getPreferences(req);
        prefs.setValue(preference, value);
        PreferenceManager.setPreferencesInCookie(prefs, req, resp);
    }

    public static void setPreferences(CookiePreferences preferences, HttpServletRequest req, HttpServletResponse resp) {
        String val = PreferenceManager.setPreferencesInCookie(preferences, req, resp);
        PreferenceManager.setPreferencesInDb(preferences, req);
    }

    @Nonnull
    protected static String setPreferencesInCookie(CookiePreferences preferences, HttpServletRequest req, HttpServletResponse resp) {
        String val = preferences.asCookieValue();
        Cookie cookie = PreferenceManager.makeCookie(req, val);
        if (val.length() == 0) {
            cookie.setMaxAge(0);
        }
        resp.addCookie(cookie);
        return val;
    }

    protected static void setPreferencesInDb(CookiePreferences preferences, HttpServletRequest req) {
        String val = preferences.asCookieValue();
        UserManager um = AppConfig.getsConfig().getUserManager();
        UserLogin user = um.getCurrentUser(req);
        if (user != null) {
            try {
                UserProfile prof = AppConfig.getsConfig().getUserProfileManager().getProfile(user.getUsername());
                if (prof != null) {
                    prof.setCookiePrefs(val);
                    AppConfig.getsConfig().getUserProfileManager().setProfile(user.getUsername(), prof);
                }
            }
            catch (DbException e2) {
                Logs.APP_LOG.warn((Object)"error writing profile to database", (Throwable)e2);
            }
        }
    }

    private static Cookie makeCookie(HttpServletRequest req, String val) {
        Cookie cookie = new Cookie(PREF_COOKIE_NAME, val);
        String ctxPath = req.getContextPath();
        if (ctxPath.length() == 0) {
            ctxPath = "/";
        }
        cookie.setPath(ctxPath);
        cookie.setMaxAge(31536000);
        Logs.APP_LOG.debug((Object)("adding cookie " + ctxPath + " str=" + cookie.getValue()));
        return cookie;
    }

    public static BranchSelectorPref.Branch getLastSelectedBranch(HttpServletRequest req, HttpServletResponse resp, String repName) {
        FecruUser user;
        BranchSelectorPref.Branch branch = null;
        UserManager um = AppConfig.getsConfig().getUserManager();
        UserLogin userLogin = um.getCurrentUser(req);
        FecruUser fecruUser = user = userLogin == null ? null : um.getUser(userLogin.getUsername());
        if (user == null) {
            return null;
        }
        UserRepositoryPropertyManager propertyManager = (UserRepositoryPropertyManager)SpringContext.getComponent("userRepositoryPropertyManager");
        try {
            String lastSelected = propertyManager.loadProperty(user, repName, "branchSelector.lastSelected");
            if (lastSelected != null) {
                JSONObject json = new JSONObject(lastSelected);
                branch = new BranchSelectorPref.Branch(json);
            }
        }
        catch (JSONException e2) {
            Logs.APP_LOG.warn((Object)("Branch preference for " + repName + " was invalid: " + e2.getMessage()), (Throwable)e2);
        }
        return branch;
    }
}

