/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.fecru.utils.HttpUtils;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.csindex.ChangesetStatsCalculator;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import com.opensymphony.webwork.interceptor.ServletResponseAware;
import com.opensymphony.xwork.ActionSupport;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MostActiveCommittersAction
extends ActionSupport
implements ServletRequestAware,
ServletResponseAware {
    private HttpServletResponse response;
    private HttpServletRequest request;
    private Path path = Path.ROOT;
    private int numDays = 0;
    private String repname;
    private int maxCommitters = 9;
    private List<ChangesetStatsCalculator.VolumeData> activeCommitters = new ArrayList<ChangesetStatsCalculator.VolumeData>();
    @Resource
    private RepositoryManager repositoryManager;

    @RequireSecurityToken(value=false)
    public String execute() throws DbException {
        RepositoryHandle handle = this.repositoryManager.getRepository(this.repname);
        if (handle != null && handle.isRunning()) {
            try {
                this.activeCommitters = ChangesetStatsCalculator.calculateMostActiveCommitters(handle.acquireEngine(), this.path, AppConfig.getUserTimeZone(this.request), this.numDays, this.maxCommitters);
            }
            catch (RepositoryHandle.StateException e2) {
                Logs.APP_LOG.debug((Object)"Repository in incorrect state", (Throwable)((Object)e2));
            }
        }
        HttpUtils.addCacheHeadersOneHour(this.response);
        return "success";
    }

    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = new Path(path);
    }

    public int getNumDays() {
        return this.numDays;
    }

    public void setNumDays(int numDays) {
        this.numDays = numDays;
    }

    public void setRepname(String repname) {
        this.repname = repname;
    }

    public void setMaxCommitters(int maxCommitters) {
        this.maxCommitters = maxCommitters;
    }

    public List<ChangesetStatsCalculator.VolumeData> getActiveCommitters() {
        return this.activeCommitters;
    }

    public String getRepname() {
        return this.repname;
    }
}

