/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.analytics.AnalyticsEvent;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.PreferenceManager;
import com.cenqua.fisheye.web.ServletUtils;
import com.cenqua.fisheye.web.filters.JsonRewrite;
import com.cenqua.fisheye.web.parameterbeans.LoginServletParams;
import com.cenqua.fisheye.web.security.CaptchaManager;
import com.cenqua.fisheye.web.util.SafeRedirectChecker;
import com.google.common.base.Strings;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LoginServlet
extends HttpServlet {
    public static final String ORIG_URL_SESSION_KEY = LoginServlet.class.getName() + ".ORIG_URL";
    private static final String ORIG_URL_REQUEST_KEY = "origUrl";
    private SafeRedirectChecker safeRedirectChecker;
    @Resource
    private EventPublisher eventPublisher;

    public void init() throws ServletException {
        super.init();
        this.eventPublisher = SpringContext.getComponentByClass(EventPublisher.class);
    }

    public static void redirectToLogin(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (JsonRewrite.isAjaxRequest(req)) {
            req.getRequestDispatcher("/WEB-INF/jsp/login_json.jsp").forward((ServletRequest)req, (ServletResponse)resp);
        } else if ("true".equalsIgnoreCase(req.getParameter("RSS")) || "true".equalsIgnoreCase(req.getParameter("rss"))) {
            ServletUtils.send401(resp);
        } else {
            String origUrl = ServletUtils.getOriginalRequestURIAndQueryString(req);
            req.getSession().setAttribute(ORIG_URL_SESSION_KEY, (Object)origUrl);
            req.getRequestDispatcher("/WEB-INF/jsp/login.jsp").forward((ServletRequest)req, (ServletResponse)resp);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String captchaId = req.getParameter("captcha");
        if (!Strings.isNullOrEmpty((String)captchaId)) {
            this.sendCaptchaImage(req, resp, captchaId);
        } else {
            this.doLogin(req, resp);
        }
    }

    private void sendCaptchaImage(HttpServletRequest req, HttpServletResponse resp, String captchaId) throws IOException {
        BufferedImage challenge = CaptchaManager.getInstance().getImageChallengeForID(captchaId, req.getLocale());
        resp.setContentType("image/png");
        resp.setHeader("Cache-Control", "no-store");
        resp.setHeader("Pragma", "no-cache");
        resp.setDateHeader("Expires", 0L);
        ImageIO.write((RenderedImage)challenge, "PNG", (OutputStream)resp.getOutputStream());
    }

    private void doLogin(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (LoginServlet.login(req, resp)) {
            this.eventPublisher.publish((Object)new AnalyticsEvent("fecru.user.logged.in"));
            ServletUtils.sendRedirectFrom(resp, this.getOriginalUrl(req), "login");
        } else {
            req.getRequestDispatcher("/WEB-INF/jsp/login.jsp").forward((ServletRequest)req, (ServletResponse)resp);
        }
    }

    private String getOriginalUrl(HttpServletRequest req) {
        String destUrl = req.getParameter(ORIG_URL_REQUEST_KEY);
        if (Strings.isNullOrEmpty((String)destUrl)) {
            destUrl = (String)req.getSession().getAttribute(ORIG_URL_SESSION_KEY);
        }
        if (destUrl != null && destUrl.endsWith("/logout")) {
            destUrl = destUrl.substring(0, destUrl.length() - "/logout".length());
        }
        if (Strings.isNullOrEmpty((String)destUrl) || !this.getSafeRedirectChecker().canRedirectTo(destUrl)) {
            destUrl = req.getContextPath() + "/";
        }
        return destUrl;
    }

    public static boolean login(HttpServletRequest req, HttpServletResponse resp) {
        String username = req.getParameter("username");
        String password = req.getParameter("password");
        boolean rememberme = req.getParameter("rememberme") != null;
        LoginServletParams params = new LoginServletParams();
        req.setAttribute("p", (Object)params);
        if (username != null) {
            UserLogin userLogin = null;
            try {
                UserManager um = AppConfig.getsConfig().getUserManager();
                FecruUser specifiedUser = um.getLicensedUser(username);
                if (specifiedUser != null && !LoginServlet.validateCaptcha(req, username)) {
                    params.setErrormsg("Captcha incorrect.");
                }
                if ((userLogin = um.login(req, resp, username, password, rememberme)) != null) {
                    specifiedUser = um.getLicensedUser(userLogin.getUsername());
                }
                if (userLogin == null && specifiedUser != null && um.hasUserExceededLoginAttempts(username)) {
                    Logs.APP_LOG.info((Object)("Login attempt for " + username + " who has exceeded max failed login attempts"));
                    params.setCaptchaId(CaptchaManager.getInstance().makeCaptchaId());
                    return false;
                }
            }
            catch (DbException e2) {
                Logs.APP_LOG.warn((Object)"error checking password", (Throwable)e2);
                params.setErrormsg("Password incorrect or unknown user");
                return false;
            }
            catch (LicensePolicyException e3) {
                Logs.APP_LOG.warn((Object)"problem logging in user", (Throwable)e3);
                params.setErrormsg(e3.getMessage());
                return false;
            }
            if (userLogin == null) {
                params.setErrormsg("Password incorrect or unknown user");
                return false;
            }
        } else {
            return false;
        }
        PreferenceManager.loadUserPreference(req);
        PreferenceManager.touchCookie(req, resp);
        return true;
    }

    private static boolean validateCaptcha(HttpServletRequest req, String username) throws DbException {
        boolean isValid = false;
        String captchaId = req.getParameter("captchaId");
        String captchaResponse = req.getParameter("captchaResponse");
        if (!Strings.isNullOrEmpty((String)captchaId) && !Strings.isNullOrEmpty((String)captchaResponse) && CaptchaManager.getInstance().validateResponseForID(captchaId, captchaResponse).booleanValue()) {
            AppConfig.getsConfig().getUserManager().resetFailedLoginAttempts(username);
            isValid = true;
        }
        return isValid;
    }

    private SafeRedirectChecker getSafeRedirectChecker() {
        if (this.safeRedirectChecker == null) {
            this.safeRedirectChecker = SpringContext.getComponentByClass(SafeRedirectChecker.class);
        }
        return this.safeRedirectChecker;
    }
}

