/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fisheye.activity.RepositoryConstraints;
import com.atlassian.fisheye.bucket.BreakdownOption;
import com.atlassian.fisheye.bucket.BucketData;
import com.atlassian.fisheye.bucket.BucketDataCollectionTotalled;
import com.atlassian.fisheye.bucket.BucketDataExporter;
import com.atlassian.fisheye.bucket.BucketDataTotalled;
import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.CalculatedBucketGraph;
import com.atlassian.fisheye.bucket.CalculatedBucketGraphPie;
import com.atlassian.fisheye.bucket.CalculatedBucketGraphXY;
import com.atlassian.fisheye.bucket.ParameterSetQuery;
import com.atlassian.fisheye.bucket.PeriodUnit;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.tags.ProjectUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.csindex.Util;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.ISO8601DateHelper;
import com.cenqua.fisheye.vis.ChartLocation;
import com.cenqua.fisheye.vis.ColourScheme;
import com.cenqua.fisheye.vis.DefaultColourScheme;
import com.cenqua.fisheye.vis.KeyLockedColourScheme;
import com.cenqua.fisheye.vis.LineCountChart;
import com.cenqua.fisheye.vis.LineCountChartArea;
import com.cenqua.fisheye.vis.LineCountChartLine;
import com.cenqua.fisheye.vis.LineCountChartPie;
import com.cenqua.fisheye.vis.LineCountChartUtils;
import com.cenqua.fisheye.vis.LocChartParams;
import com.cenqua.fisheye.web.ServletUtils;
import com.cenqua.fisheye.web.WaybackSpecChart;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import com.opensymphony.webwork.interceptor.ServletResponseAware;
import com.opensymphony.xwork.ActionSupport;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.imagemap.ImageMapUtilities;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.XYDataset;

public class LocChartAction
extends ActionSupport
implements ServletRequestAware,
ServletResponseAware {
    private HttpServletResponse response;
    private WaybackSpecChart wb = new WaybackSpecChart();
    private Integer w;
    private Integer h;
    private String context;
    private String outputtype = "image";
    private String mapName;
    private String repname;
    private String username;
    private Path path = Path.ROOT;
    private Long markStart;
    private Long markEnd;
    private String projectkey;
    private Color imageBackgroundColour;
    private HttpServletRequest request;
    @Resource
    private CommitterUserMappingManager committerUserMappingManager;
    @Resource
    protected EffectiveUserProvider effectiveUserProvider;
    @Resource
    private ProjectManager projectManager;
    @Resource
    private UserManager userManager;
    @Resource
    private RepositoryManager repositoryManager;
    @Resource
    private PermissionManager permissionManager;
    private List<UserLegendEntry> userLegend;
    private static Map<String, ChartLocation> commandMap = new HashMap<String, ChartLocation>();
    private static final Color MARK_COLOUR = new Color(4, 255, 4, 96);
    private LocChartParams locParams;
    private ArrayList<ProjectLegendEntry> projectLegend;
    private boolean locEnabled = false;

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        ChartLocation chartLocation = commandMap.get(this.context);
        if (chartLocation == null) {
            Logs.APP_LOG.debug((Object)("Unknown context: " + this.context + ".  Known contexts: " + commandMap.keySet()));
            return "none";
        }
        this.locParams = chartLocation.getParams();
        this.locParams.setDimension(this.w, this.h);
        this.locParams.setBackgroundColor(this.imageBackgroundColour);
        this.locParams.setYAxisType(this.wb.getAxisType());
        this.locParams.setTimezone(AppConfig.getUserTimeZone(this.request));
        switch (chartLocation) {
            case MAIN: 
            case PREVIEW: {
                return this.doChartPageCharts();
            }
            case SIDEBAR: 
            case SPARKLINE: {
                return this.doSidebarChart();
            }
            case USER: 
            case SPARKLINE_USER: {
                return this.doUserChart();
            }
            case PROJECT: 
            case SPARKLINE_PROJECT: {
                return this.doProjectChart();
            }
        }
        return "none";
    }

    private String doProjectChart() throws IOException, DbException {
        Project project = this.projectManager.getProjectByKey(this.projectkey);
        boolean canViewProject = this.permissionManager.isProjectVisible(this.userManager.getCurrentUser(this.request), project);
        if (!canViewProject) {
            ServletUtils.send403(this.request, this.response, "You are not allowed to access the repository " + this.repname);
            return "none";
        }
        if ("htmlLegend".equals(this.outputtype)) {
            this.getLegendForProject(project);
            return "PROJECTLEGEND";
        }
        BucketDataCollectionTotalled data = this.getBucketDataForProject(project);
        ColourScheme colourScheme = new DefaultColourScheme(data.collectionCount(), this.imageBackgroundColour);
        if (data.collectionCount() > 1) {
            colourScheme = new KeyLockedColourScheme(new ArrayList<String>((Collection<String>)data.getKeySet()), this.imageBackgroundColour);
        }
        CalculatedBucketGraphXY graphs = new CalculatedBucketGraphXY(data, false, null, null, "", this.locParams, 20, false, null, BreakdownOption.NONE, true, true);
        this.locParams.setTimezone(AppConfig.getUserTimeZone(this.request));
        BufferedImage image = new LineCountChartLine().renderPathHistoryImage(graphs, this.locParams, colourScheme);
        this.sendOutput(graphs, image);
        return "none";
    }

    private void getLegendForProject(Project project) throws DbException {
        RepositoryConstraints repositoryConstraints = ProjectUtil.generateRepositoryConstraint(project);
        this.projectLegend = new ArrayList();
        UserLogin user = this.effectiveUserProvider.getEffectiveUserLogin();
        int i2 = 0;
        for (String rep : repositoryConstraints.getReps()) {
            RepositoryHandle repHandle = this.repositoryManager.getRepository(rep);
            if (repHandle == null || !repHandle.isRunning() || !this.userManager.hasPermissionToAccess(user, repHandle)) continue;
            if (repositoryConstraints.isIncludeWholeRepository(rep)) {
                this.projectLegend.add(new ProjectLegendEntry(repHandle.getName(), Path.ROOT, LineCountChartUtils.getXYColour(i2), repHandle.getCfg().isLocEnabled()));
                ++i2;
                continue;
            }
            ArrayList<Path> paths = new ArrayList<Path>(repositoryConstraints.getConstraintsForRep(rep).getPaths());
            Collections.sort(paths);
            for (Path path : paths) {
                this.projectLegend.add(new ProjectLegendEntry(repHandle.getName(), path, LineCountChartUtils.getXYColour(i2), repHandle.getCfg().isLocEnabled()));
                ++i2;
            }
        }
    }

    private BucketDataCollectionTotalled getBucketDataForProject(Project project) throws DbException {
        BucketDataCollectionTotalled data = new BucketDataCollectionTotalled(PeriodUnit.DAY, TimeZone.getDefault());
        RepositoryConstraints repositoryConstraints = ProjectUtil.generateRepositoryConstraint(project);
        UserLogin user = this.effectiveUserProvider.getEffectiveUserLogin();
        for (String rep : repositoryConstraints.getReps()) {
            RepositoryHandle repHandle = this.repositoryManager.getRepository(rep);
            if (repHandle == null || !repHandle.isRunning() || !this.userManager.hasPermissionToAccess(user, repHandle)) continue;
            if (repHandle.getCfg().isLocEnabled()) {
                this.locEnabled = true;
            }
            if (repositoryConstraints.isIncludeWholeRepository(rep)) {
                this.addData(Path.ROOT, repHandle, data);
                continue;
            }
            ArrayList<Path> paths = new ArrayList<Path>(repositoryConstraints.getConstraintsForRep(rep).getPaths());
            Collections.sort(paths);
            for (Path path : paths) {
                this.addData(path, repHandle, data);
            }
        }
        return data;
    }

    private void addData(Path path, RepositoryHandle repHandle, BucketDataCollectionTotalled data) throws DbException {
        try {
            BucketGraph bucketGraph = repHandle.acquireEngine().getBucketGraph();
            ParameterSetQuery queryParams = new ParameterSetQuery();
            queryParams.setPath(path);
            BucketDataCollectionTotalled repData = bucketGraph.getBuckets(queryParams);
            if (repData.getFirst() != null) {
                ((BucketDataTotalled)repData.getFirst()).setLabel("Path " + path.getPath() + " in " + repHandle.getName());
                data.add(repData.getFirst());
            }
        }
        catch (RepositoryHandle.StateException e2) {
            Logs.APP_LOG.warn((Object)"Problem getting bucket data", (Throwable)((Object)e2));
        }
    }

    private String doUserChart() throws DbException, IOException {
        TreeMultimap mappedCommitters = TreeMultimap.create();
        mappedCommitters.putAll(this.committerUserMappingManager.getAllCommittersForUser(this.username));
        if ("htmlLegend".equals(this.outputtype)) {
            this.getLegendForUser((Multimap<String, String>)mappedCommitters);
            return "USERLEGEND";
        }
        BucketDataCollectionTotalled data = this.getBucketDataForUser((Multimap<String, String>)mappedCommitters);
        CalculatedBucketGraphXY graphs = new CalculatedBucketGraphXY(data, false, null, null, "", this.locParams, 20, false, null, BreakdownOption.NONE, true, true);
        if ("json".equals(this.outputtype)) {
            try {
                this.response.setContentType("application/json");
                BucketDataExporter.writeRawDataJson(new OutputStreamWriter((OutputStream)this.response.getOutputStream()), graphs);
            }
            catch (Exception e2) {
                Logs.APP_LOG.debug((Object)"Error sending raw data as JSON", (Throwable)e2);
                this.response.sendError(500);
            }
        } else {
            ArrayList<String> repsAndCommitters = new ArrayList<String>();
            for (Map.Entry e3 : mappedCommitters.asMap().entrySet()) {
                repsAndCommitters.add("Committers " + e3.getValue() + " in " + (String)e3.getKey());
            }
            KeyLockedColourScheme colourSchemeChart = new KeyLockedColourScheme(repsAndCommitters, this.imageBackgroundColour);
            BufferedImage image = new LineCountChartLine().renderPathHistoryImage(graphs, this.locParams, colourSchemeChart);
            this.sendOutput(graphs, image);
        }
        return "none";
    }

    private void getLegendForUser(Multimap<String, String> mappedCommitters) throws DbException {
        UserLogin user = this.effectiveUserProvider.getEffectiveUserLogin();
        this.userLegend = new ArrayList<UserLegendEntry>();
        KeyLockedColourScheme colourSchemeLegend = new KeyLockedColourScheme(new ArrayList<String>(mappedCommitters.keySet()), this.imageBackgroundColour);
        int i2 = 0;
        for (Map.Entry e2 : mappedCommitters.asMap().entrySet()) {
            String rep = (String)e2.getKey();
            Collection committers = (Collection)e2.getValue();
            RepositoryHandle repHandle = this.repositoryManager.getRepository(rep);
            if (repHandle == null || !repHandle.isRunning() || !this.userManager.hasPermissionToAccess(user, repHandle)) continue;
            RepositoryConfig repConfig = repHandle.getCfg();
            if (repConfig.isLocEnabled()) {
                this.locEnabled = true;
            }
            this.userLegend.add(new UserLegendEntry(rep, (List<String>)ImmutableList.copyOf((Collection)committers), ((ColourScheme)colourSchemeLegend).getBarColour(i2, (Comparable)((Object)rep)), repConfig.isLocEnabled(), repConfig.isAuthorLocEnabled()));
            ++i2;
        }
    }

    private BucketDataCollectionTotalled getBucketDataForUser(Multimap<String, String> mappedCommitters) throws DbException {
        UserLogin user = this.effectiveUserProvider.getEffectiveUserLogin();
        BucketDataCollectionTotalled data = new BucketDataCollectionTotalled(PeriodUnit.DAY, TimeZone.getDefault());
        for (Map.Entry e2 : mappedCommitters.asMap().entrySet()) {
            String rep = (String)e2.getKey();
            Collection committers = (Collection)e2.getValue();
            RepositoryHandle repHandle = this.repositoryManager.getRepository(rep);
            if (repHandle == null || !repHandle.isRunning() || !this.userManager.hasPermissionToAccess(user, repHandle)) continue;
            try {
                RepositoryEngine engine = repHandle.acquireEngine();
                BucketGraph bucketGraph = engine.getBucketGraph();
                ParameterSetQuery queryParams = new ParameterSetQuery();
                queryParams.setAuthors((List<String>)ImmutableList.copyOf((Collection)committers));
                BucketDataCollectionTotalled repData = bucketGraph.getBuckets(queryParams);
                Object first = repData.getFirst();
                if (first != null) {
                    if (!engine.getCfg().isAuthorLocEnabled()) {
                        ((BucketData)first).zeroLinecount();
                    }
                    ((BucketData)first).setLabel("Committers " + committers + " in " + rep);
                    ((BucketData)first).setRepository(rep);
                    data.add(repData.getFirst());
                    continue;
                }
                Logs.APP_LOG.debug((Object)("No BucketData found for committers " + committers));
            }
            catch (RepositoryHandle.StateException e1) {
                Logs.APP_LOG.debug((Object)"Repository State Exception", (Throwable)((Object)e1));
            }
        }
        return data;
    }

    private String doSidebarChart() throws DbException, IOException, ServletException {
        RepositoryEngine engine = this.aquireEngine();
        if (engine == null) {
            return "none";
        }
        ParameterSetQuery params = this.constructParams(engine);
        BucketGraph bucketGraph = engine.getBucketGraph();
        CalculatedBucketGraphXY graphs = bucketGraph.getXYSeries(params);
        LineCountChart chart = engine.getCfg().getRepositoryType() == ScmType.HG ? new LineCountChartLine() : new LineCountChartArea();
        XYURLGenerator urlGenerator = null;
        if (this.markStart != null && this.markEnd != null) {
            if (!graphs.noGraphData()) {
                long minX = graphs.getLowestXValue();
                this.markStart = Math.max(minX, this.markStart);
            }
            chart.addDateRangeMarker(this.markStart, this.markEnd, MARK_COLOUR);
            urlGenerator = new XYURLGenerator(){

                public String generateURL(XYDataset dataset, int series, int item) {
                    boolean islast = dataset.getItemCount(series) - 1 == item;
                    return islast ? "?" : "?wbjump&endDate=" + ExpressionUtil.escapeString(ISO8601DateHelper.toIsoDate(dataset.getX(series, item).longValue()));
                }
            };
        }
        this.locParams.setUrlGenerator(urlGenerator);
        DefaultColourScheme colourScheme = new DefaultColourScheme(graphs.getSeriesCount(), this.imageBackgroundColour);
        BufferedImage image = chart.renderPathHistoryImage(graphs, this.locParams, colourScheme);
        this.sendOutput(graphs, image);
        return "none";
    }

    private String doChartPageCharts() throws DbException, IOException, ServletException {
        RepositoryEngine engine = this.aquireEngine();
        if (engine == null) {
            return "none";
        }
        ParameterSetQuery dataParams = this.constructParams(engine);
        if (this.outputtype.equals("json")) {
            try {
                this.response.setContentType("application/json");
                BucketDataExporter.writeRawDataJson((Writer)new OutputStreamWriter((OutputStream)this.response.getOutputStream()), dataParams, engine.getBucketGraph());
            }
            catch (Exception e2) {
                Logs.APP_LOG.debug((Object)"Error sending raw data as JSON", (Throwable)e2);
                this.response.sendError(500);
            }
        } else {
            this.renderChartPageCharts(dataParams, engine);
        }
        return "none";
    }

    private RepositoryEngine aquireEngine() throws IOException, ServletException {
        RepositoryHandle h2 = this.repositoryManager.getRepository(this.repname);
        if (h2 == null) {
            ServletUtils.send404(this.request, this.response, "Repository not found");
            return null;
        }
        if (!h2.isRunning()) {
            ServletUtils.sendRepositoryNotRunning(this.request, this.response, h2);
            return null;
        }
        UserLogin user = this.effectiveUserProvider.getEffectiveUserLogin();
        if (!this.userManager.hasPermissionToAccess(user, h2)) {
            ServletUtils.send403(this.request, this.response, "You are not allowed to access the repository " + this.repname);
            return null;
        }
        try {
            return h2.acquireEngine();
        }
        catch (RepositoryHandle.StateException e2) {
            ServletUtils.send404(this.request, this.response, "Repository is not running");
            return null;
        }
    }

    private void renderChartPageCharts(ParameterSetQuery params, RepositoryEngine engine) throws DbException, IOException {
        BucketGraph bucketGraph = engine.getBucketGraph();
        CalculatedBucketGraph graph = null;
        BufferedImage image = null;
        Multimap<String, String> displayNameMap = null;
        if (params.getBreakdown() == BreakdownOption.USER) {
            displayNameMap = this.committerUserMappingManager.getDisplayNameToCommitterMap(this.repname);
        }
        if (this.wb.isArea()) {
            CalculatedBucketGraphXY graphsXY = bucketGraph.getXYSeries(params, this.wb.getDate1(), this.wb.getDate2(), this.locParams, this.wb.getMaxItems(), false, displayNameMap);
            DefaultColourScheme colourScheme = new DefaultColourScheme(graphsXY.getSeriesCount(), this.imageBackgroundColour);
            image = new LineCountChartArea().renderPathHistoryImage(graphsXY, this.locParams, colourScheme);
            graph = graphsXY;
        } else if (this.wb.isLine()) {
            CalculatedBucketGraphXY graphsXY = bucketGraph.getXYSeries(params, this.wb.getDate1(), this.wb.getDate2(), this.locParams, this.wb.getMaxItems(), false, displayNameMap);
            DefaultColourScheme colourScheme = new DefaultColourScheme(graphsXY.getSeriesCount(), this.imageBackgroundColour);
            image = new LineCountChartLine().renderPathHistoryImage(graphsXY, this.locParams, colourScheme);
            graph = graphsXY;
        } else if (this.wb.isPie()) {
            CalculatedBucketGraphPie graphsPie = bucketGraph.getPieData(params, this.wb.getDate2(), this.wb.getMaxItems(), displayNameMap);
            image = new LineCountChartPie().renderPathHistoryImage(graphsPie, this.locParams);
            graph = graphsPie;
        } else if (this.wb.isChange()) {
            CalculatedBucketGraphXY graphsXY = bucketGraph.getXYSeries(params, this.wb.getDate1(), this.wb.getDate2(), this.locParams, this.wb.getMaxItems(), true, displayNameMap);
            DefaultColourScheme colourScheme = new DefaultColourScheme(graphsXY.getSeriesCount(), this.imageBackgroundColour);
            image = new LineCountChartLine().renderPathHistoryImage(graphsXY, this.locParams, colourScheme);
            graph = graphsXY;
        }
        this.sendOutput(graph, image);
    }

    private ParameterSetQuery constructParams(RepositoryEngine engine) throws DbException {
        if (!engine.getRevisionCache().isAuthorLocEnabled()) {
            this.wb.setAuthors(Arrays.asList("__ALL_AUTHORS__"));
        }
        if (this.wb.getBranch() == null && this.path != null) {
            this.wb.setBranch(engine.getRevisionCache().getImpliedBranch(this.path));
        }
        return new ParameterSetQuery(this.path, this.wb.getBranch(), this.wb.getExtns(), this.wb.getAuthors(), this.wb.getBreakdownOption());
    }

    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    private void sendOutput(CalculatedBucketGraph graph, BufferedImage image) throws IOException {
        if (this.outputtype.equals("image")) {
            this.response.setContentType(LineCountChartUtils.getImageContentType());
            ChartUtilities.writeBufferedImageAsPNG((OutputStream)this.response.getOutputStream(), (BufferedImage)image);
        } else if (this.outputtype.equals("imagemap") && graph.getChartRenderingInfo() != null) {
            String imageMap = ImageMapUtilities.getImageMap((String)this.mapName, (ChartRenderingInfo)graph.getChartRenderingInfo());
            this.response.getOutputStream().write(imageMap.getBytes());
            this.response.getOutputStream().flush();
        }
    }

    public void setW(Integer w2) {
        this.w = w2;
    }

    public void setH(Integer h2) {
        this.h = h2;
    }

    public void setYaxistype(String yaxistype) {
        this.wb.setAxisType(yaxistype);
    }

    public void setMaxitems(Integer maxitems) {
        this.wb.setMaxItems(maxitems);
    }

    public void setExtn(String[] extn) {
        this.wb.setExtns(extn);
    }

    public void setAuthor(String[] author) {
        this.wb.setAuthors(author);
    }

    public void setEndDate(String endDate) {
        this.wb.setDate2(endDate);
    }

    public void setStartDate(String startDate) {
        this.wb.setDate1(startDate);
    }

    public void setCharttype(String charttype) {
        this.wb.setChartType(charttype);
    }

    public void setStacktype(String stacktype) {
        this.wb.setStackType(stacktype);
    }

    public void setBr(String br) {
        this.wb.setBranch(br);
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setMapName(String mapName) {
        this.mapName = mapName;
    }

    public void setOutputtype(String outputtype) {
        this.outputtype = outputtype;
    }

    public void setRepname(String repname) {
        this.repname = repname;
    }

    public void setPath(String path) {
        this.path = new Path(path);
    }

    public void setMarkStart(String sstart) {
        this.markStart = Long.parseLong(sstart);
    }

    public void setMarkEnd(String send) {
        this.markEnd = Long.parseLong(send);
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setProjectkey(String projectkey) {
        this.projectkey = Project.upperCaseProjectKey(projectkey);
    }

    public List<UserLegendEntry> getUserLegend() {
        return this.userLegend;
    }

    public Color getImageBackgroundColour() {
        return this.imageBackgroundColour;
    }

    public ArrayList<ProjectLegendEntry> getProjectLegend() {
        return this.projectLegend;
    }

    public void setImageBackgroundColour(String hexColour) {
        this.imageBackgroundColour = Util.fromHexString(hexColour);
        if (this.imageBackgroundColour == null) {
            this.imageBackgroundColour = Color.white;
        }
    }

    public boolean isLocEnabled() {
        return this.locEnabled;
    }

    static {
        commandMap.put("main", ChartLocation.MAIN);
        commandMap.put("preview", ChartLocation.PREVIEW);
        commandMap.put("dropdown-sparkline", ChartLocation.SPARKLINE);
        commandMap.put("committerPage", ChartLocation.SIDEBAR);
        commandMap.put("viewfile", ChartLocation.SIDEBAR);
        commandMap.put("changelog", ChartLocation.SIDEBAR);
        commandMap.put("main-sparkline", ChartLocation.SPARKLINE);
        commandMap.put("committerPage-sparkline", ChartLocation.SPARKLINE);
        commandMap.put("viewfile-sparkline", ChartLocation.SPARKLINE);
        commandMap.put("changelog-sparkline", ChartLocation.SPARKLINE);
        commandMap.put("user", ChartLocation.USER);
        commandMap.put("user-sparkline", ChartLocation.SPARKLINE_USER);
        commandMap.put("project", ChartLocation.PROJECT);
        commandMap.put("project-sparkline", ChartLocation.SPARKLINE_PROJECT);
    }

    public static class ProjectLegendEntry {
        private final String rep;
        private final Path path;
        private final String colour;
        private boolean locEnabled;

        public ProjectLegendEntry(String rep, Path path, Color colour, boolean locEnabled) {
            this.rep = rep;
            this.path = path;
            this.colour = Util.toHexString(colour);
            this.locEnabled = locEnabled;
        }

        public String getRep() {
            return this.rep;
        }

        public Path getPath() {
            return this.path;
        }

        public String getColour() {
            return this.colour;
        }

        public boolean isLocEnabled() {
            return this.locEnabled;
        }
    }

    public static class UserLegendEntry {
        private final String rep;
        private final List<String> committers;
        private final String colour;
        private final boolean locEnabled;
        private final boolean authorLocEnabled;

        public UserLegendEntry(String rep, List<String> committers, Color colour, boolean isLocEnabled, boolean isAuthorLocEnabled) {
            this.rep = rep;
            this.committers = committers;
            this.colour = Util.toHexString(colour);
            this.locEnabled = isLocEnabled;
            this.authorLocEnabled = isAuthorLocEnabled;
        }

        public String getRep() {
            return this.rep;
        }

        public List<String> getCommitters() {
            return this.committers;
        }

        public String getColour() {
            return this.colour;
        }

        public int getCommitterCount() {
            return this.committers.size();
        }

        public String toString() {
            return this.rep + ": " + this.committers + " " + this.colour;
        }

        public boolean isLocEnabled() {
            return this.locEnabled;
        }

        public boolean isAuthorLocEnabled() {
            return this.authorLocEnabled;
        }
    }
}

