/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.crucible.actions.AjaxResponse;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.web.PreferenceManager;
import com.cenqua.fisheye.web.RepositoryAction;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.changeset.ChangeSetPageData;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import javax.servlet.http.HttpServletRequest;

public class LoadChangesetPageAjaxAction
extends RepositoryAction
implements AjaxResponse,
ServletRequestAware {
    private HttpServletRequest request;
    private String href;
    private String csid;
    private String errorMsg;
    private Integer revPageNum;
    private Integer index;

    @RequireSecurityToken(value=false)
    public String execute() {
        String repName = null;
        try {
            String prefix = this.request.getContextPath() + "/changelog";
            if (!this.href.contains(prefix)) {
                throw new RuntimeException("The URL " + this.href + " doesn't contain " + prefix);
            }
            String pathIncludingRepName = this.href.substring(this.href.indexOf(prefix) + prefix.length() + 1);
            repName = pathIncludingRepName.substring(0, pathIncludingRepName.indexOf(47));
            RepositoryHandle rep = super.getRepositoryHandle(repName);
            RevisionCache<? extends ChangeSet> revCache = rep.acquireEngine().getRevisionCache();
            Object changeSet = revCache.getChangeSet(this.csid);
            if (changeSet != null) {
                String pagePath = this.revPageNum == null ? pathIncludingRepName.substring(repName.length() + 1) : null;
                ChangeSetPageData pageData = new ChangeSetPageData(new WaybackSpec(), (ChangeSet)changeSet, pagePath, this.revPageNum == null ? 1 : this.revPageNum, this.index == null ? 0 : this.index, revCache, PreferenceManager.getPreferences(this.request));
                this.request.setAttribute("p", (Object)pageData);
                return "success";
            }
            this.errorMsg = "Changeset " + this.csid + " not found for repository '" + repName + "'";
            return "error";
        }
        catch (RepositoryAction.RepositoryPermissionException rpe) {
            this.errorMsg = "You do not have permission to access the repository '" + repName + "'";
            return "error";
        }
        catch (Throwable e2) {
            Logs.APP_LOG.error((Object)"Exception", e2);
            this.errorMsg = e2.getMessage();
            return "error";
        }
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public boolean isWorked() {
        return this.errorMsg == null;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public void setCsid(String csid) {
        this.csid = csid;
    }

    public void setPageNum(Integer revPageNum) {
        this.revPageNum = revPageNum;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }
}

