/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.crucible.maintenance.MaintenanceManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class JspUtils {
    public static final Function<Map.Entry<String, String>, String> ENTRY_TO_XML_ATTRIBUTE = new Function<Map.Entry<String, String>, String>(){

        public String apply(@Nonnull Map.Entry<String, String> input) {
            return ExpressionUtil.escapeHtmlIdOrName(input.getKey()) + "=\"" + ExpressionUtil.escapeString(input.getValue()) + "\"";
        }
    };
    private static Pattern rgxCommitterEmail = Pattern.compile("\\s*<\\S+@\\S+>\\s*$");

    public String formatDate(long aDate, String format) {
        SimpleDateFormat fmt = new SimpleDateFormat(format, Locale.US);
        return fmt.format(new Date(aDate));
    }

    public long getNow() {
        return System.currentTimeMillis();
    }

    public Date getNowValue() {
        return new Date(this.getNow());
    }

    public String getServerTimeZone() {
        return TimeZone.getDefault().getID();
    }

    public List range(int start, int end) {
        int len = end - start;
        ArrayList<Integer> list = new ArrayList<Integer>(len);
        for (int i2 = 0; i2 < len; ++i2) {
            list.add(i2 + start);
        }
        return list;
    }

    public String age(long birth, long now) {
        return DateHelper.age(birth, now);
    }

    public String formatPercentage(double p2) {
        return NumberFormat.getPercentInstance().format(p2);
    }

    public boolean isLoginPossible() {
        UserManager um = AppConfig.getsConfig().getUserManager();
        try {
            return um.isLoginPossible();
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)"problem", (Throwable)e2);
            return true;
        }
    }

    public boolean isSignupAllowed() {
        SecurityType securityConfig = AppConfig.getsConfig().getConfig().getSecurity();
        return securityConfig.getBuiltIn().getSignup().getEnabled();
    }

    public boolean isCrucibleOnly() {
        return AppConfig.isCrucibleOnly();
    }

    public boolean isFisheyeOnly() {
        return AppConfig.isFishEyeOnly();
    }

    public boolean isCrucible() {
        return AppConfig.isCrucible();
    }

    public boolean isAdminPasswordSet() {
        return AppConfig.getsConfig().getAdminConfig().haveDoneInitialSetup();
    }

    public String getAppName() {
        return AppConfig.getProductName();
    }

    public boolean getRequiresLogin() {
        RootConfig root = AppConfig.getsConfig();
        return !root.getConfig().getSecurity().getAllowAnon();
    }

    private MaintenanceManager getMaintenanceManager() {
        return (MaintenanceManager)SpringContext.getComponent("maintenanceManager");
    }

    public boolean isDownForMaintenance() {
        return this.getMaintenanceManager().isDownForMaintenance();
    }

    public String getMaintenanceMessage() {
        return this.getMaintenanceManager().getMessage();
    }

    public static String stripEmailFromCommitter(String committer) {
        if (null == committer) {
            return "";
        }
        return rgxCommitterEmail.matcher(committer).replaceFirst("");
    }

    public static Map<String, String> extractMapEntriesWithKeyPrefix(Map<String, String> map, String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            result.put(entry.getKey().substring(prefix.length()), entry.getValue());
        }
        return result;
    }

    public static Map<String, String> extractMapEntriesWithAttrKeyPrefix(Map<String, String> map) {
        return JspUtils.extractMapEntriesWithKeyPrefix(map, "html-");
    }

    public static String mapToXMLAttributes(Map<String, String> map) {
        return Joiner.on((String)" ").join(Iterables.transform(map.entrySet(), ENTRY_TO_XML_ATTRIBUTE));
    }
}

