/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.web.Watch;
import com.cenqua.fisheye.web.WatchDAO;
import com.cenqua.fisheye.web.WaybackSpec;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class HibernateWatchDAO
implements WatchDAO {
    private CurrentSessionProvider currentSessionProvider;

    @Autowired
    public void setCurrentSessionProvider(CurrentSessionProvider currentSessionProvider) {
        this.currentSessionProvider = currentSessionProvider;
    }

    private Session session() {
        return this.currentSessionProvider.currentSession();
    }

    @Override
    public Long add(Watch watch) {
        this.session().save((Object)watch);
        return watch.getId();
    }

    @Override
    public boolean delete(Long watchId) {
        Watch watch = (Watch)this.session().get(Watch.class, (Serializable)watchId);
        if (watch != null) {
            this.session().delete((Object)watch);
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteByKey(String watchKey) {
        return this.session().createQuery("delete from Watch w where w.watchKey = :watchKey").setParameter("watchKey", (Object)watchKey).executeUpdate() > 0;
    }

    public List<Watch> getWatches() {
        return this.session().createCriteria(Watch.class).list();
    }

    public List<Watch> getWatchesForRep(String rep) {
        return this.session().createCriteria(Watch.class).add((Criterion)Restrictions.eq((String)"rep", (Object)rep)).list();
    }

    public List<Watch> getWatchesForUser(FecruUser user) {
        return this.session().createCriteria(Watch.class).add((Criterion)Restrictions.eq((String)"user", (Object)user)).list();
    }

    @Override
    public Watch getWatchForUserRepPath(FecruUser user, String rep, Path path) {
        return this.getWatchForUserRepPathConstraint(user, rep, path, null);
    }

    @Override
    public Watch getWatchForUserRepPathConstraint(FecruUser user, String rep, Path path, WaybackSpec constraint) {
        String watchKey = Watch.watchKey(user, rep, path, constraint);
        return this.getWatchForKey(watchKey);
    }

    public Watch getWatchForKey(String watchKey) {
        return (Watch)this.session().createCriteria(Watch.class).add((Criterion)Restrictions.eq((String)"watchKey", (Object)watchKey)).uniqueResult();
    }

    @Override
    public void removeWatchesForUser(FecruUser user) {
        this.session().createQuery("delete from Watch w where w.user.id = :id").setParameter("id", (Object)user.getId()).executeUpdate();
    }

    @Override
    public Watch load(Long watchId) {
        return (Watch)this.session().load(Watch.class, (Serializable)watchId);
    }

    @Override
    public void update(Watch watch) {
        Watch existing = (Watch)this.session().get(Watch.class, (Serializable)watch.getId());
        if (existing != null) {
            existing.setCacheSerialOfLastRevisionSent(watch.getCacheSerialOfLastRevisionSent());
            existing.setLastRevisionSent(watch.getLastRevisionSent());
            existing.setLastChecked(watch.getLastChecked());
        }
    }
}

