/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.fisheye.Visitor;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.web.CookiePreferences;
import com.cenqua.fisheye.web.WaybackSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class FisheyeRepositoryExplorer {
    public final RepositoryEngine engine;
    public final RevisionCache cRep;
    private final Path lPath;
    public final WaybackSpec wb;
    public final LuceneConnection<LuceneIndexes> conn;
    public final CookiePreferences up;
    private final boolean hideDeletedFiles;
    private List<FisheyeFileExplorerInfo> mCachedFiles = null;

    public FisheyeRepositoryExplorer(RepositoryEngine eng, Path aLocalPath, WaybackSpec wb, CookiePreferences up) throws DbException {
        this.engine = eng;
        this.lPath = aLocalPath;
        this.cRep = this.engine.getRevisionCache();
        this.conn = eng.getIndexConnection();
        this.wb = wb;
        this.up = up;
        this.hideDeletedFiles = this.up.isHideDeletedFiles();
    }

    public String getName() {
        return this.engine.getName();
    }

    public String getRepName() {
        return this.engine.getName();
    }

    public RepositoryEngine getEngine() {
        return this.engine;
    }

    public FileRevision getDirRevision() throws DbException {
        return this.cRep.getLatestFileRevision(this.lPath);
    }

    public boolean isHideDeletedFiles() {
        return this.hideDeletedFiles;
    }

    public List<FisheyeFileExplorerInfo> getFiles() throws DbException {
        if (this.mCachedFiles == null) {
            final ArrayList<FisheyeFileExplorerInfo> files = new ArrayList<FisheyeFileExplorerInfo>();
            Visitor<FileRevision> revCollector = new Visitor<FileRevision>(){

                @Override
                public void visit(FileRevision revInfo) {
                    if (revInfo.isFile()) {
                        files.add(new FisheyeFileExplorerInfo(revInfo.getPath(), revInfo));
                    }
                }
            };
            this.getDirectoryContents(this.lPath, revCollector);
            this.mCachedFiles = files;
        }
        return this.mCachedFiles;
    }

    public List<Path> listFilePaths(Path directory) throws DbException {
        final ArrayList<Path> paths = new ArrayList<Path>();
        Visitor<FileRevision> revCollector = new Visitor<FileRevision>(){

            @Override
            public void visit(FileRevision revInfo) {
                if (revInfo.isFile()) {
                    paths.add(revInfo.getPath());
                }
            }
        };
        if (this.wb == null || StringUtils.isBlank((String)this.wb.getBranch()) && StringUtils.isBlank((String)this.wb.getTag())) {
            Path[] files = this.cRep.listFiles(directory);
            Collections.addAll(paths, files);
        } else {
            this.getDirectoryContents(directory, revCollector);
        }
        Collections.sort(paths);
        return paths;
    }

    public List<FileRevision> listHeadRevisions(Path path) throws DbException {
        final ArrayList<FileRevision> files = new ArrayList<FileRevision>();
        Visitor<FileRevision> revCollector = new Visitor<FileRevision>(){

            @Override
            public void visit(FileRevision revInfo) {
                files.add(revInfo);
            }
        };
        this.visitFilesAtPath(path, revCollector);
        return files;
    }

    private void getDirectoryContents(Path directory, Visitor<FileRevision> revCollector) throws DbException {
        if (this.wb != null && !StringUtils.isBlank((String)this.wb.getBranch())) {
            this.cRep.visitHeadRevisionsOnBranchInDirectory(directory, this.wb.getBranch(), revCollector);
        } else if (this.wb != null && !StringUtils.isBlank((String)this.wb.getTag())) {
            this.cRep.visitRevisionsForTagInDirectory(directory, this.wb.getTag(), revCollector);
        } else {
            this.cRep.visitHeadRevisionsInDirectory(directory, revCollector);
        }
    }

    private void visitFilesAtPath(Path path, Visitor<FileRevision> revCollector) throws DbException {
        if (this.wb != null && !StringUtils.isBlank((String)this.wb.getBranch())) {
            this.cRep.visitHeadRevisionsOnBranchAtPath(path, this.wb.getBranch(), revCollector);
        } else if (this.wb != null && !StringUtils.isBlank((String)this.wb.getTag())) {
            this.cRep.visitHeadRevisionsOnTagAtPath(path, this.wb.getTag(), revCollector);
        } else {
            this.cRep.visitHeadRevisionsAtPath(path, revCollector);
        }
    }

    public Path getLocalPath() {
        return this.lPath;
    }

    public String toString() {
        return "FisheyeRepositoryExplorer[" + this.getName() + "/" + this.getLocalPath() + "]";
    }

    static class BestMatch {
        final RevInfoKey rkey;
        final long date;

        public BestMatch(RevInfoKey rkey, long date) {
            this.rkey = rkey;
            this.date = date;
        }
    }

    public static class FisheyeFileExplorerInfo {
        private final Path mPath;
        private final FileRevision mLatestRevision;

        public FisheyeFileExplorerInfo(Path path) {
            this.mPath = path;
            this.mLatestRevision = null;
        }

        public FisheyeFileExplorerInfo(Path path, FileRevision latestRevision) {
            this.mPath = path;
            this.mLatestRevision = latestRevision;
        }

        public Path getPath() {
            return this.mPath;
        }

        public FileRevision getLatestRevision() {
            return this.mLatestRevision;
        }
    }
}

