/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.web.CookiePreferences;
import com.cenqua.fisheye.web.WaybackSpec;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class FisheyeFileHistoryExplorer {
    private final Multimap<String, FileRevision> mBranchMap = ArrayListMultimap.create();
    private final List<FileRevision> nonBranchRevisions = new ArrayList<FileRevision>();
    private int mWbSkippedCount = 0;
    private String mMainBranchName;

    public FisheyeFileHistoryExplorer(FileHistory history, WaybackSpec wb) {
        this(history, wb, null);
    }

    public FisheyeFileHistoryExplorer(FileHistory history, WaybackSpec wb, CookiePreferences userPreferences) {
        this.mMainBranchName = history.getMainBranch();
        boolean ignoreBranchAndTagConstraints = userPreferences != null && "l".equals(userPreferences.getPreference("viewMode"));
        for (String br : history.getBranches()) {
            List<String> revs = history.getRevisions(br);
            Collections.reverse(revs);
            for (String rev : revs) {
                List<FileRevision> histRevs = history.getRevisionsForRev(rev);
                for (FileRevision info : histRevs) {
                    if (wb != null) {
                        if (wb.matchesRevision(info, ignoreBranchAndTagConstraints)) {
                            this.mBranchMap.put((Object)br, (Object)info);
                            continue;
                        }
                        ++this.mWbSkippedCount;
                        continue;
                    }
                    this.mBranchMap.put((Object)br, (Object)info);
                }
            }
        }
        for (FileRevision nonBranchRevision : history.getNonBranchRevisions()) {
            if (wb != null && !wb.matchesRevision(nonBranchRevision, ignoreBranchAndTagConstraints)) continue;
            this.nonBranchRevisions.add(nonBranchRevision);
        }
    }

    public Map<String, Collection<FileRevision>> getInfoMap() {
        return this.mBranchMap.asMap();
    }

    public Collection<FileRevision> getNonBranchRevisions() {
        return this.nonBranchRevisions;
    }

    public List<String> getBranchNames() {
        int i2;
        ArrayList<String> sortedList = new ArrayList<String>(this.mBranchMap.keySet());
        Collections.sort(sortedList);
        if (this.mMainBranchName != null && (i2 = sortedList.indexOf(this.mMainBranchName)) > 0) {
            sortedList.add(0, (String)sortedList.remove(i2));
        }
        return sortedList;
    }
}

