/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.fisheye.StoppableVisitor;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RecentChangesParams2;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DirInfo;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.util.MinMaxLongRange;
import com.cenqua.fisheye.web.WaybackSpec;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FisheyeChangelogExplorer {
    private final MinMaxLongRange dirDateRange;
    private final MinMaxLongRange pageDateRange = new MinMaxLongRange();
    private final RevisionCache revisionCache;
    private final WaybackSpec waybackSpec;
    private final Path lPath;
    private List<ChangeSet> changeSets;
    private List<String> committers;
    private String fromChangeSetId = null;
    private boolean fromChangeSetIdInc = false;
    private String toChangeSetId = null;
    private boolean toChangeSetIdInc = false;
    private String showChangeSetId = null;
    private Long toDate = null;
    private String nextInPast;
    private boolean nextInPastIsInc = false;
    private String nextInFuture;
    private boolean nextInFutureIsInc = false;

    public FisheyeChangelogExplorer(Path lpath, RevisionCache crep, WaybackSpec wb) throws DbException {
        this.revisionCache = crep;
        this.lPath = lpath;
        this.waybackSpec = wb;
        DirInfo dirInfo = this.revisionCache.findDirInfo(lpath);
        if (dirInfo == null || dirInfo.getSubTreeDateRange() == null || !dirInfo.getSubTreeDateRange().hasMinMax()) {
            this.dirDateRange = new MinMaxLongRange();
            this.dirDateRange.add(System.currentTimeMillis());
        } else {
            this.dirDateRange = dirInfo.getSubTreeDateRange().toMinMaxLongRange();
        }
    }

    public long getStartDate() {
        return this.dirDateRange.getMin();
    }

    public long getEndDate() {
        return this.dirDateRange.getMax();
    }

    public long getThisPageStartDate() {
        if (this.pageDateRange.isSet()) {
            return this.pageDateRange.getMin();
        }
        return this.getStartDate();
    }

    public long getThisPageEndDate() {
        if (this.pageDateRange.isSet()) {
            return this.pageDateRange.getMax();
        }
        return this.getEndDate();
    }

    public Path getPath() {
        return this.lPath;
    }

    public List<ChangeSet> getChangesets() {
        return this.changeSets;
    }

    public List<String> getCommitters() {
        return this.committers;
    }

    public String getNextInPast() {
        return this.nextInPast;
    }

    public String getNextInFuture() {
        return this.nextInFuture;
    }

    public boolean isNextInFutureIsInc() {
        return this.nextInFutureIsInc;
    }

    public boolean isNextInPastIsInc() {
        return this.nextInPastIsInc;
    }

    public void computeData(int perPage) throws DbException {
        if (this.committers != null && this.committers.isEmpty()) {
            this.changeSets = Collections.emptyList();
            return;
        }
        RecentChangesParams2 params = new RecentChangesParams2();
        params.setBasePath(this.lPath);
        params.setMaxReturn(perPage);
        params.setMinDate(this.getStartDate());
        params.setMaxDate(this.getEndDate());
        if (this.waybackSpec != null) {
            params.setWbFilter(this.waybackSpec);
        }
        this.setupParams(params);
        this.changeSets = this.revisionCache.findRecentChangeSets(params);
        if (1 == params.getSearchDirection()) {
            this.changeSets = Lists.reverse(this.changeSets);
        }
        if (this.changeSets.isEmpty()) {
            this.nextInFuture = this.toChangeSetId;
            this.nextInFutureIsInc = true;
            this.nextInPast = this.fromChangeSetId;
            this.nextInPastIsInc = true;
        } else {
            ChangeSet csYoungest = this.changeSets.get(0);
            this.pageDateRange.add(csYoungest.getDate());
            ChangeSet csOldest = this.changeSets.get(this.changeSets.size() - 1);
            this.pageDateRange.add(csOldest.getDate());
            if (this.getEndDate() > this.getThisPageEndDate()) {
                this.nextInFuture = csYoungest.getId();
            }
            if (this.getStartDate() < this.getThisPageStartDate()) {
                this.nextInPast = csOldest.getId();
            }
        }
    }

    private void setupParams(RecentChangesParams2 params) throws DbException {
        Object showChangeSet;
        if (this.fromChangeSetId != null) {
            Object fromChangeSet = this.revisionCache.getChangeSet(this.fromChangeSetId);
            if (fromChangeSet != null) {
                params.setMinDate(fromChangeSet.getDate());
                params.setMaxDate(this.getEndDate());
                params.setSearchDirection(1);
                params.setMinChangeset((ChangeSet)fromChangeSet, this.fromChangeSetIdInc);
            }
        } else if (this.toChangeSetId != null) {
            Object toChangeSet = this.revisionCache.getChangeSet(this.toChangeSetId);
            if (toChangeSet != null) {
                params.setMinDate(this.getStartDate());
                params.setMaxDate(toChangeSet.getDate());
                params.setSearchDirection(0);
                params.setMaxChangeset((ChangeSet)toChangeSet, this.toChangeSetIdInc);
            }
        } else if (this.showChangeSetId != null && (showChangeSet = this.revisionCache.getChangeSet(this.showChangeSetId)) != null) {
            params.setMinDate(this.getStartDate());
            params.setMaxDate(showChangeSet.getDate());
            params.setSearchDirection(0);
            params.setMaxChangeset((ChangeSet)showChangeSet, true);
        }
        if (this.committers != null) {
            for (String committer : this.committers) {
                params.addAnyCommiter(committer);
            }
        }
        if (this.toDate != null) {
            params.setMaxDate(this.toDate);
        }
    }

    public RecentChangesParams2 generateParams() throws DbException {
        Object showChangeSet;
        RecentChangesParams2 params = new RecentChangesParams2();
        if (this.fromChangeSetId != null) {
            Object fromChangeSet = this.revisionCache.getChangeSet(this.fromChangeSetId);
            if (fromChangeSet != null) {
                params.setSearchDirection(1);
                params.setMinChangeset((ChangeSet)fromChangeSet, this.fromChangeSetIdInc);
            }
        } else if (this.toChangeSetId != null) {
            Object toChangeSet = this.revisionCache.getChangeSet(this.toChangeSetId);
            if (toChangeSet != null) {
                params.setSearchDirection(0);
                params.setMaxChangeset((ChangeSet)toChangeSet, this.toChangeSetIdInc);
            }
        } else if (this.showChangeSetId != null && (showChangeSet = this.revisionCache.getChangeSet(this.showChangeSetId)) != null) {
            params.setSearchDirection(0);
            params.setMaxChangeset((ChangeSet)showChangeSet, true);
            params.setMaxDate(showChangeSet.getDate());
        }
        return params;
    }

    public void setFromChangeSetId(String fromChangeSetId) {
        this.fromChangeSetId = fromChangeSetId;
    }

    public void setFromChangeSetIdInc(boolean fromChangeSetIdInc) {
        this.fromChangeSetIdInc = fromChangeSetIdInc;
    }

    public void setToChangeSetId(String toChangeSetId) {
        this.toChangeSetId = toChangeSetId;
    }

    public void setToChangeSetIdInc(boolean toChangeSetIdInc) {
        this.toChangeSetIdInc = toChangeSetIdInc;
    }

    public void setShowChangeSetId(String showChangeSetId) {
        this.showChangeSetId = showChangeSetId.trim();
    }

    public void setToDate(long toDate) {
        this.toDate = toDate;
    }

    public void setCommitters(List<String> committers) {
        this.committers = committers;
    }

    public static List<FileRevision> pertinentRevInfosInChangeset(final ChangeSet cs, final int max, final Path relTo, final boolean caseSensitive) throws DbException {
        if (cs == null) {
            return Collections.emptyList();
        }
        final ArrayList<FileRevision> result = new ArrayList<FileRevision>();
        cs.visitRevisions(new StoppableVisitor<FileRevision>(){
            boolean shouldTruncate;
            {
                this.shouldTruncate = max >= 0 && cs.getRevisionInfosCount() - max > 2;
            }

            @Override
            public boolean visit(FileRevision revision) {
                if (this.shouldTruncate && result.size() >= max) {
                    return false;
                }
                RevInfoKey key = revision.getRevInfoKey();
                if (relTo == null || key.getPath().hasPrefix(relTo, caseSensitive)) {
                    result.add(revision);
                }
                return true;
            }
        });
        return result;
    }
}

