/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.google.common.base.Strings;
import javax.servlet.http.HttpServletRequest;

public class FishEyePathInfoFactory {
    public static FishEyePathInfo createPathInfo(Path path, HttpServletRequest req) throws RepositoryHandle.StateException {
        return FishEyePathInfoFactory.createPathInfoFromLocalUrl(path.getPath(), req);
    }

    public static FishEyePathInfo createPathInfoFromFullUrl(String fullUrl, HttpServletRequest req) throws RepositoryHandle.StateException {
        if (Strings.isNullOrEmpty((String)fullUrl)) {
            return null;
        }
        String serverUrl = req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort() + req.getContextPath() + "/";
        String servletUrl = fullUrl.substring(serverUrl.length());
        int indexOfQueryString = servletUrl.indexOf("?");
        int indexOfStartOfPathInfo = servletUrl.indexOf("/") + 1;
        if (indexOfQueryString != -1 && indexOfQueryString < indexOfStartOfPathInfo || indexOfStartOfPathInfo == 0) {
            return null;
        }
        String pathUrl = servletUrl.substring(indexOfStartOfPathInfo, indexOfQueryString != -1 ? indexOfQueryString : servletUrl.length());
        return FishEyePathInfoFactory.createPathInfoFromLocalUrl(pathUrl, req);
    }

    public static FishEyePathInfo createPathInfoFromLocalUrl(String localUrl, HttpServletRequest req) throws RepositoryHandle.StateException {
        UserLogin user;
        FishEyePathInfo pi = new FishEyePathInfo(localUrl);
        RepositoryHandle h2 = AppConfig.getsConfig().getRepositoryManager().getRepository(pi.getRepname());
        if (h2 == null) {
            return null;
        }
        RootConfig rootConfig = AppConfig.getsConfig();
        UserManager um = rootConfig.getUserManager();
        if (!um.hasPermissionToAccess(user = um.getCurrentUser(req), h2)) {
            return null;
        }
        if (!h2.getCfg().isEnabled()) {
            return null;
        }
        if (!h2.isRunning()) {
            return null;
        }
        pi.initEngine(h2);
        return pi;
    }
}

