/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.web.CommandString;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.util.URIUtil;

public class FishEyePathInfo {
    public static final String COMMAND_PREFIX = "~";
    private final String repname;
    private final Path fullpath;
    private final Path localpath;
    private final CommandString commandString;
    private final boolean empty;
    private RepositoryHandle handle;
    private RepositoryEngine engine;

    public FishEyePathInfo(HttpServletRequest req) {
        this(FishEyePathInfo.pathFromRequest(req).simplify());
    }

    private static Path pathFromRequest(HttpServletRequest req) {
        try {
            URI uri = new URI(req.getRequestURI());
            String rawPath = uri.getRawPath().substring(req.getContextPath().length() + req.getServletPath().length());
            Iterable pathComponents = Iterables.transform((Iterable)Splitter.on((char)'/').omitEmptyStrings().split((CharSequence)rawPath), (Function)new Function<String, String>(){

                public String apply(String pathComponent) {
                    return URIUtil.decodePath((String)pathComponent);
                }
            });
            if (Iterables.isEmpty((Iterable)pathComponents)) {
                return Path.ROOT;
            }
            return new Path((List<String>)ImmutableList.copyOf((Iterable)pathComponents));
        }
        catch (URISyntaxException e2) {
            throw Throwables.propagate((Throwable)e2);
        }
    }

    public FishEyePathInfo(String pi) {
        this(pi == null ? Path.ROOT : new Path(pi.indexOf(63) == -1 ? pi : pi.substring(0, pi.indexOf(63))).simplify());
    }

    private FishEyePathInfo(Path path) {
        if (path != null && path.numComponents() > 0 && path.getComponent(0).startsWith(COMMAND_PREFIX)) {
            String cmdStr = path.getComponent(0);
            this.commandString = new CommandString(cmdStr.substring(COMMAND_PREFIX.length()));
            path = path.trimFirst();
        } else {
            this.commandString = null;
        }
        List<String> allParts = null;
        if (path != null) {
            allParts = Arrays.asList(path.getComponents());
        }
        if (allParts == null || allParts.size() == 0) {
            this.fullpath = Path.ROOT;
            this.localpath = Path.ROOT;
            this.repname = null;
            this.empty = true;
        } else {
            this.repname = this.computeRepositoryName(path);
            this.fullpath = path;
            this.localpath = path.trimFirst();
            this.empty = false;
        }
    }

    public FishEyePathInfo(CommandString cs, String repname, Path lpath) {
        this.commandString = cs;
        this.repname = repname;
        this.localpath = lpath;
        this.fullpath = new Path(repname, lpath);
        this.empty = false;
    }

    private String computeRepositoryName(Path path) {
        String renName = path.getComponent(0);
        if (renName.contains(":")) {
            int seperatorIndex = renName.indexOf(":");
            return renName.substring(seperatorIndex + 1);
        }
        return renName;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isEmptyPath() {
        return this.isEmpty();
    }

    public CommandString getCommandString() {
        return this.commandString;
    }

    public String getCommandWord() {
        return this.commandString == null ? null : this.commandString.getCommandWord();
    }

    public String getCommandParam(String key) {
        return this.commandString == null ? null : this.commandString.getCommandParam(key);
    }

    public RepositoryConfig getRepository() {
        return this.handle.getCfg();
    }

    public RepositoryHandle getHandle() {
        return this.handle;
    }

    public String getRepname() {
        return this.repname;
    }

    public void initEngine(RepositoryHandle handle) throws RepositoryHandle.StateException {
        this.handle = handle;
        this.engine = this.handle.acquireEngine();
    }

    public RepositoryEngine getEngine() {
        return this.engine;
    }

    public Path getFullPath() {
        return this.fullpath;
    }

    public Path getLocalPath() {
        return this.localpath;
    }

    public boolean pathExists() throws DbException {
        return this.isDir() || this.isFile();
    }

    public boolean isFile() throws DbException {
        RevisionCache<? extends ChangeSet> cache = this.engine.getRevisionCache();
        return cache.isFile(this.localpath);
    }

    public boolean isDir() throws DbException {
        RevisionCache<? extends ChangeSet> cache = this.engine.getRevisionCache();
        return cache.isDir(this.localpath);
    }

    public boolean isPipelined() {
        return this.getHandle().isPipelined();
    }

    public boolean isBinary() throws DbException {
        RevisionCache<? extends ChangeSet> cache = this.engine.getRevisionCache();
        FileRevision latestFileRevision = cache.getLatestFileRevision(this.localpath);
        return latestFileRevision == null || latestFileRevision.isBinary();
    }

    public boolean isSupportsRepositoryGraph() {
        return this.getRepository().isSupportsCommitGraph();
    }

    public boolean isOversize() throws DbException {
        RevisionCache<? extends ChangeSet> cache = this.engine.getRevisionCache();
        FileRevision latestFileRevision = cache.getLatestFileRevision(this.localpath);
        return latestFileRevision == null || latestFileRevision.isOversize();
    }
}

