/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.template.TemplateManager;
import com.atlassian.fecru.user.EffectiveUserProviderImpl;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.atlassian.fecru.user.UserProfile;
import com.atlassian.fisheye.activity.ActivityItem;
import com.atlassian.fisheye.activity.ActivityItemList;
import com.atlassian.fisheye.activity.ActivityItemManager;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.event.RepositoryUpdatedEvent;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.spi.data.MailMessageData;
import com.atlassian.fisheye.web.NavBuilder;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.notification.batch.creators.EmailTemplateRender;
import com.cenqua.crucible.util.FreemarkerUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.ConfigUtil;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.mail.Mailer;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.IndexableFileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.web.ChangeSetHolder;
import com.cenqua.fisheye.web.Watch;
import com.cenqua.fisheye.web.WatchDAO;
import com.cenqua.fisheye.web.WatchManager;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import com.cenqua.fisheye.web.util.CheckinCommentFormatter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;

@Component(value="watchManager")
public class DefaultWatchManager
implements WatchManager,
InitializingBean {
    private long ACTIVITY_SEARCH_TIMEOUT = 1000L;
    private int MAX_ITEMS = 100;
    private ActivitySearchMonitor activitySearchMonitor;
    private final ActivityItemManager activityManager;
    private final TxTemplate txTemplate;
    private final WatchDAO watchDAO;
    private final FecruUserDAO userDAO;
    private final EventPublisher eventPublisher;
    private final WatchChecker watchChecker;
    private final RepositoryManager repositoryManager;
    private final CommitterUserMappingManager committerUserMappingManager;
    private final TemplateManager templateManager;
    private final Mailer mailer;
    private final Timer dailyWatchCheckTrigger;
    private boolean stopped = false;
    private static final long ONE_DAY_MILLIS = 86400000L;
    private static final String WATCH_TEMPLATE = "changeset-mail.ftl";
    private EffectiveUserProviderImpl effectiveUserProvider;

    @Autowired
    public DefaultWatchManager(TxTemplate txTemplate, WatchDAO watchDAO, FecruUserDAO userDAO, EventPublisher eventPublisher, @Qualifier(value="defaultActivityItemManager") ActivityItemManager activityManager, RepositoryManager repositoryManager, CommitterUserMappingManager committerUserMappingManager, TemplateManager templateManager, Mailer mailer, EffectiveUserProviderImpl effectiveUserProvider) {
        this.txTemplate = txTemplate;
        this.watchDAO = watchDAO;
        this.userDAO = userDAO;
        this.eventPublisher = eventPublisher;
        this.activityManager = activityManager;
        this.repositoryManager = repositoryManager;
        this.committerUserMappingManager = committerUserMappingManager;
        this.templateManager = templateManager;
        this.mailer = mailer;
        this.effectiveUserProvider = effectiveUserProvider;
        this.watchChecker = new WatchChecker();
        this.dailyWatchCheckTrigger = new Timer("FE-WatchDaily", true);
    }

    public void afterPropertiesSet() throws Exception {
        Thread watchCheckerThread = new Thread((Runnable)this.watchChecker, "FE-WatchChecker");
        watchCheckerThread.setDaemon(true);
        watchCheckerThread.start();
        this.dailyWatchCheckTrigger.schedule(new TimerTask(){

            @Override
            public void run() {
                Logs.APP_LOG.debug((Object)"checking daily watches");
                DefaultWatchManager.this.watchChecker.triggerCheckDailyWatches();
            }
        }, DateHelper.getEndOfDay(new Date(), AppConfig.getsConfig().getTimezone()), 86400000L);
    }

    @Override
    public void stop() {
        this.stopped = true;
        this.watchChecker.cancel();
        this.dailyWatchCheckTrigger.cancel();
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @PostConstruct
    public void init() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void release() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void repositoryUpdated(RepositoryUpdatedEvent repositoryUpdatedEvent) {
        String repname = repositoryUpdatedEvent.getRepositoryName();
        Logs.APP_LOG.debug((Object)("Notifying watch thread about a change in [" + repname + "] repository "));
        this.watchChecker.repositoryChanged(repname);
    }

    @Override
    public List<Watch> getWatchesForUser(String username) throws DbException {
        FecruUser user = this.userDAO.getByUsername(username);
        return ImmutableList.copyOf(this.watchDAO.getWatchesForUser(user));
    }

    @Override
    public Watch getWatch(String username, String rep, Path path) throws DbException {
        FecruUser user = this.userDAO.getByUsername(username);
        return this.watchDAO.getWatchForUserRepPath(user, rep, path);
    }

    @Override
    public Watch getWatch(String username, String rep, Path path, WaybackSpec constraint) throws DbException {
        FecruUser user = this.userDAO.getByUsername(username);
        return this.watchDAO.getWatchForUserRepPathConstraint(user, rep, path, constraint);
    }

    public List<Watch> getWatchesForUser(FecruUser user) throws DbException {
        return ImmutableList.copyOf(this.watchDAO.getWatchesForUser(user));
    }

    @Override
    public List<Watch> getWatchesForRep(String rep) throws DbException {
        return ImmutableList.copyOf(this.watchDAO.getWatchesForRep(rep));
    }

    @Override
    public Watch addWatch(String username, String rep, Path path) throws DbException {
        return this.addWatch(username, rep, path, null);
    }

    @Override
    public Watch addWatch(final String username, final String rep, final Path path, final WaybackSpec constraint) throws DbException {
        return this.txTemplate.execute(new TxCallback<Watch>(){

            @Override
            public Watch doInTransaction(TransactionStatus status) throws Exception {
                FecruUser user = DefaultWatchManager.this.userDAO.getByUsername(username);
                Watch watch = new Watch(user, rep, path, constraint);
                DefaultWatchManager.this.watchDAO.deleteByKey(watch.getWatchKey());
                watch.setLastChecked(System.currentTimeMillis());
                DefaultWatchManager.this.watchDAO.add(watch);
                return watch;
            }
        });
    }

    @Override
    public void updateWatch(final Watch watch) throws DbException {
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) throws Exception {
                DefaultWatchManager.this.watchDAO.update(watch);
                return null;
            }
        });
    }

    @Override
    public boolean deleteWatch(final long id) throws DbException {
        return this.txTemplate.execute(new TxCallback<Boolean>(){

            @Override
            public Boolean doInTransaction(TransactionStatus status) throws Exception {
                return DefaultWatchManager.this.watchDAO.delete(id);
            }
        });
    }

    @Override
    public boolean deleteWatch(final String username, final String rep, final Path path, final WaybackSpec constraint) throws DbException {
        return this.txTemplate.execute(new TxCallback<Boolean>(){

            @Override
            public Boolean doInTransaction(TransactionStatus status) throws Exception {
                FecruUser user = DefaultWatchManager.this.userDAO.getByUsername(username);
                String watchKey = Watch.watchKey(user, rep, path, constraint);
                return DefaultWatchManager.this.watchDAO.deleteByKey(watchKey);
            }
        });
    }

    private ActivitySearchMonitor getActivitySearchMonitor() {
        if (this.activitySearchMonitor == null) {
            this.activitySearchMonitor = new ActivitySearchMonitor(this.ACTIVITY_SEARCH_TIMEOUT);
        }
        return this.activitySearchMonitor;
    }

    private List<ChangeSet> checkWatch(FecruUser user, Watch watch, RepositoryEngine rep, Principal principal) throws DbException {
        Logs.APP_LOG.debug((Object)("checking watch " + watch));
        ArrayList<ChangeSet> changesets = new ArrayList<ChangeSet>();
        RevisionCache<? extends ChangeSet> revCache = rep.getRevisionCache();
        long revLastMod = revCache.getLastModifiedDate();
        long currentCSN = revCache.getCacheSerialNumber();
        long lastChecked = watch.getLastChecked();
        Logs.APP_LOG.debug((Object)("revLastMod = " + revLastMod));
        Logs.APP_LOG.debug((Object)("currentCSN = " + currentCSN));
        Logs.APP_LOG.debug((Object)("lastChecked = " + lastChecked));
        if (revLastMod > lastChecked) {
            RevInfoKey lastRevisionSent = watch.getLastRevisionSent();
            IndexableFileRevision rev = null;
            if (lastRevisionSent != null) {
                long lastCSN = watch.getCacheSerialOfLastRevisionSent();
                if (lastCSN != currentCSN) {
                    Logs.APP_LOG.debug((Object)"CSN changed, skipping lastRevisionSent");
                } else {
                    rev = revCache.getFileRevision(lastRevisionSent);
                }
            }
            Date minDate = new Date((rev != null ? rev.getDate() : lastChecked) + 1L);
            Date maxDate = new Date(revLastMod);
            ActivityItemSearchParams.Builder builder = new ActivityItemSearchParams.Builder();
            WaybackSpec wb = watch.getConstraint();
            if (wb == null) {
                wb = new WaybackSpec();
            }
            builder.excludeCrucible().excludeExternals().includeFisheye().setWbFilter(wb).repository(rep.getName()).minDate(minDate).maxDate(maxDate).path(rep.getName(), watch.getPath()).timeZone(TimeZone.getTimeZone(this.getEffectiveTimezone(user))).maxItems(this.MAX_ITEMS);
            ActivitySearchMonitor activitySearchMonitor = this.getActivitySearchMonitor();
            ActivityItemSearchParams params = builder.build();
            ActivityItemList itemList = this.activityManager.findActivityItems(params, principal, activitySearchMonitor);
            if (!itemList.getExceptions().isEmpty()) {
                Logs.APP_LOG.warn((Object)("Errors retrieving activity for watch " + watch.toString()));
                for (Exception e2 : itemList.getExceptions()) {
                    Logs.APP_LOG.debug((Object)"", (Throwable)e2);
                }
                return changesets;
            }
            try {
                long lastRevDate = -1L;
                if (itemList.getItems().size() > 0) {
                    for (ActivityItem item : itemList.getItems()) {
                        FileRevision fileRevision;
                        long frDate;
                        ChangeSet cs;
                        if (!(item instanceof ChangeSetHolder) || (cs = ((ChangeSetHolder)item).getChangeset()) == null) continue;
                        changesets.add(cs);
                        Iterator<? extends FileRevision> it = cs.getRevisionsIterable().iterator();
                        if (!it.hasNext() || (frDate = (fileRevision = it.next()).getDate()) <= lastRevDate) continue;
                        lastRevDate = frDate;
                        lastRevisionSent = fileRevision.getRevInfoKey();
                    }
                    watch.setLastRevisionSent(lastRevisionSent);
                    watch.setCacheSerialOfLastRevisionSent(currentCSN);
                }
            }
            catch (Exception e3) {
                Logs.APP_LOG.error((Object)"Exception running watch search", (Throwable)e3);
            }
        }
        watch.setLastChecked(revLastMod);
        Logs.APP_LOG.debug((Object)("updating watch " + watch));
        this.updateWatch(watch);
        return changesets;
    }

    private String getEffectiveTimezone(FecruUser user) {
        return Optional.ofNullable(user.getUserProfile().getTimezone()).orElse(ConfigUtil.getDefaultTimezone());
    }

    private void sendEmailForChangesets(FecruUser user, RepositoryEngine rep, String watchpath, List<ChangeSet> changesets, boolean individual, WaybackSpec wbSpec) {
        try {
            if (wbSpec == null) {
                wbSpec = new WaybackSpec();
            }
            if (user == null || user.getEmail() == null) {
                Logs.APP_LOG.debug((Object)("Could not sent watch mail for " + watchpath + ": no email address set."));
                return;
            }
            boolean isHtml = user.getUserProfile().getEmailFormat() == 1;
            String contentType = isHtml ? "text/html; charset=UTF-8" : "text/plain; charset=UTF-8";
            Template csTmpl = this.templateManager.getFishEyeTemplate(WATCH_TEMPLATE, isHtml);
            BeansWrapper wrapper = BeansWrapper.getDefaultInstance();
            TemplateHashModel commentFormatter = (TemplateHashModel)wrapper.getStaticModels().get(CheckinCommentFormatter.class.getName());
            Map<String, Object> root = FreemarkerUtil.init();
            root.put("repname", rep.getName());
            root.put("repcfg", rep.getCfg());
            root.put("commentFormatter", commentFormatter);
            root.put("siteurl", AppConfig.getsConfig().getSiteURL());
            root.put("timezone", this.getEffectiveTimezone(user));
            root.put("watchpath", watchpath);
            root.put("appnametag", "FishEye");
            root.put("wbspec", wbSpec);
            if (individual) {
                for (ChangeSet cs : changesets) {
                    ArrayList<ChangeSetData> oneCs = new ArrayList<ChangeSetData>();
                    FecruUser mappedUser = this.getMappedUserForChangeset(cs);
                    oneCs.add(new ChangeSetData(cs, rep, mappedUser));
                    root.put("changesets", oneCs);
                    root.put("size", 1);
                    StringWriter msg = new StringWriter();
                    csTmpl.process(root, (Writer)msg);
                    msg.flush();
                    String fromDisplayName = this.getFromDisplayName(mappedUser != null ? mappedUser.getDisplayName() : cs.getAuthor());
                    String from = !this.mailer.getUseFrom() && mappedUser != null ? mappedUser.getEmail() : null;
                    String subject = rep.getName() + ":/" + watchpath + " " + cs.getDisplayId() + ": " + CheckinCommentFormatter.format(rep.getCfg(), cs.getComment(), cs.getDateValue(), 80, false, false);
                    this.sendWatchEmail(contentType, user.getEmail(), new EmailTemplateRender(this.templateManager).renderSubject(subject), fromDisplayName, from, msg.toString());
                }
            } else {
                LinkedHashSet<String> authors = new LinkedHashSet<String>();
                ArrayList<ChangeSetData> csDatas = new ArrayList<ChangeSetData>();
                for (ChangeSet cs : changesets) {
                    FecruUser mappedUser = this.getMappedUserForChangeset(cs);
                    csDatas.add(new ChangeSetData(cs, rep, mappedUser));
                    authors.add(mappedUser != null ? mappedUser.getDisplayName() : cs.getAuthor());
                }
                root.put("changesets", csDatas);
                root.put("size", changesets.size());
                StringWriter msg = new StringWriter();
                csTmpl.process(root, (Writer)msg);
                msg.flush();
                String fromDisplayName = this.getFromDisplayName(authors.toArray(new String[authors.size()]));
                String subject = rep.getName() + ":/" + watchpath + " " + changesets.size() + ExpressionUtil.pluralise(" change", " changes", changesets.size());
                this.sendWatchEmail(contentType, user.getEmail(), new EmailTemplateRender(this.templateManager).renderSubject(subject), fromDisplayName, null, msg.toString());
            }
        }
        catch (DbException e2) {
            Logs.APP_LOG.error((Object)("Exception loading info for user '" + user.getUsername() + "'"), (Throwable)e2);
        }
        catch (IOException e3) {
            Logs.APP_LOG.error((Object)"Exception processing watch email template", (Throwable)e3);
        }
        catch (TemplateException e4) {
            Logs.APP_LOG.error((Object)"Exception processing watch email template", (Throwable)e4);
        }
    }

    protected String getFromDisplayName(String ... authors) {
        int totalAuthors = authors.length;
        if (totalAuthors == 1) {
            return authors[0];
        }
        if (totalAuthors > 1) {
            return authors[0] + " + " + (totalAuthors - 1) + ExpressionUtil.pluralise(" other", " others", totalAuthors - 1);
        }
        return null;
    }

    private FecruUser getMappedUserForChangeset(ChangeSet cs) {
        try {
            return this.committerUserMappingManager.getUserForCommitter(cs.getRepName(), cs.getAuthor());
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)"Could not retrieve user mapping for changeset author", (Throwable)e2);
            return null;
        }
    }

    private void sendWatchEmail(String contentType, String email, String subject, String fromDisplayName, String fromEmail, String body) {
        MailMessageData msg = new MailMessageData();
        msg.addRecipient(email);
        msg.setSubject(subject);
        msg.setBodyText(contentType, body);
        if (!Strings.isNullOrEmpty((String)fromEmail)) {
            msg.setFrom(fromEmail);
        }
        if (!Strings.isNullOrEmpty((String)fromDisplayName)) {
            msg.setFromDisplayName(fromDisplayName);
        }
        this.mailer.sendMessage(msg);
    }

    class WatchChecker
    implements Runnable {
        private final Set<String> repQueue = new LinkedHashSet<String>();
        private boolean doDailyWatchCheck = false;
        private volatile boolean stopping = false;

        WatchChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void repositoryChanged(String repname) {
            Set<String> set = this.repQueue;
            synchronized (set) {
                if (!this.repQueue.contains(repname)) {
                    this.repQueue.add(repname);
                    this.repQueue.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void triggerCheckDailyWatches() {
            Set<String> set = this.repQueue;
            synchronized (set) {
                this.doDailyWatchCheck = true;
                this.repQueue.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Set<String> set = this.repQueue;
            synchronized (set) {
                this.stopping = true;
                this.repQueue.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int numExceptionsCaught = 0;
            block7: while (!this.stopping) {
                try {
                    String rep = null;
                    Set<String> set = this.repQueue;
                    synchronized (set) {
                        while (!this.doDailyWatchCheck && this.repQueue.isEmpty()) {
                            try {
                                this.repQueue.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (!this.stopping) continue;
                            break block7;
                        }
                        if (!this.repQueue.isEmpty()) {
                            rep = this.repQueue.iterator().next();
                            this.repQueue.remove(rep);
                        }
                    }
                    if (this.doDailyWatchCheck) {
                        this.checkDailyWatches();
                        this.doDailyWatchCheck = false;
                    }
                    if (rep != null) {
                        Logs.APP_LOG.debug((Object)("watch check triggered for '" + rep + "'"));
                        this.checkWatchesForRep(rep, true);
                    }
                    numExceptionsCaught = 0;
                }
                catch (Throwable e2) {
                    Logs.APP_LOG.error((Object)("Exception caught while processing watches: " + e2.getMessage()), e2);
                    if (++numExceptionsCaught <= 50) continue;
                    Logs.APP_LOG.error((Object)"Too many consecutive exceptions encountered in watch processing. Watches will be stopped. Please report this problem by raising a Support Request in the Atlassian Support system");
                    break;
                }
            }
            Logs.APP_LOG.debug((Object)"Leaving watch thread");
        }

        private void checkDailyWatches() {
            for (RepositoryHandle rep : DefaultWatchManager.this.repositoryManager.getHandles()) {
                if (this.stopping) break;
                this.checkWatchesForRep(rep, false);
            }
        }

        private void checkWatchesForRep(String rep, boolean instant) {
            this.checkWatchesForRep(DefaultWatchManager.this.repositoryManager.getRepository(rep), instant);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkWatchesForRep(RepositoryHandle repHandle, boolean instant) {
            Logs.APP_LOG.debug((Object)("checkWatchesForRep [" + repHandle + "] instant [" + instant + "]"));
            if (!DefaultWatchManager.this.mailer.isConfigured()) {
                return;
            }
            if (!repHandle.getCfg().isWatchesEnabled()) {
                return;
            }
            if (!repHandle.isRunning()) {
                return;
            }
            Disposer.pushThreadInstance();
            try {
                RepositoryEngine repEngine = repHandle.acquireEngine();
                if (!repEngine.getStatus().isInitialCrucibleIndexingComplete()) {
                    Logs.APP_LOG.debug((Object)("not checking watches on [" + repHandle.getName() + "]: still indexing."));
                    return;
                }
                List<Watch> repWatches = DefaultWatchManager.this.getWatchesForRep(repHandle.getName());
                UserManager um = AppConfig.getsConfig().getUserManager();
                Logs.APP_LOG.debug((Object)("checking " + repWatches.size() + " watches on '" + repHandle.getName() + "'"));
                for (Watch watch : repWatches) {
                    if (this.stopping) {
                        break;
                    }
                    Logs.APP_LOG.debug((Object)("Processing watch [" + watch.toString() + "]"));
                    UserLogin userLogin = um.createTrustedUserLogin(watch.getUser().getUsername(), true, false);
                    if (userLogin == null) {
                        Logs.APP_LOG.debug((Object)("Found watch for effectively inactive user:" + watch.getUser() + "]. BaseReviewNotification skipped for this user."));
                        continue;
                    }
                    if (!um.hasPermissionToAccess(userLogin, repHandle)) {
                        Logs.APP_LOG.debug((Object)("user '" + userLogin.getUsername() + "' doesn't have perms to check watch on '" + repHandle.getName() + "'"));
                        continue;
                    }
                    FecruUser user = um.getLicensedUser(userLogin.getUsername());
                    try {
                        DefaultWatchManager.this.effectiveUserProvider.pushEffectivePrincipal(userLogin, user);
                        UserProfile profile = user.getUserProfile();
                        Logs.APP_LOG.debug((Object)("User profile [" + profile + "]"));
                        if (profile != null) {
                            if (instant == (profile.getWatchMode() == 0)) {
                                List changesets = DefaultWatchManager.this.checkWatch(user, watch, repEngine, userLogin);
                                Collections.sort(changesets);
                                Logs.APP_LOG.debug((Object)("sending " + changesets.size() + " changesets"));
                                if (changesets.size() <= 0) continue;
                                DefaultWatchManager.this.sendEmailForChangesets(user, repEngine, watch.getPath().toString(), changesets, instant, watch.getConstraint());
                                continue;
                            }
                            Logs.APP_LOG.debug((Object)("Not checking watch of wrong type (at this time) " + profile.getWatchMode()));
                            continue;
                        }
                        Logs.APP_LOG.warn((Object)("unable to load profile for user [" + user.getUsername() + "]"));
                    }
                    finally {
                        DefaultWatchManager.this.effectiveUserProvider.popEffectivePrincipal();
                    }
                }
            }
            catch (RepositoryHandle.StateException e2) {
                Logs.APP_LOG.warn((Object)("Not checking watches for repository [" + repHandle.getName() + "] at this time. Repository not running."));
            }
            catch (Exception e3) {
                Logs.APP_LOG.error((Object)("Exception processing watches for repository [" + repHandle.getName() + "]"), (Throwable)e3);
            }
            finally {
                try {
                    HibernateUtil.closeSession();
                }
                finally {
                    Disposer.popThreadInstance();
                }
            }
        }
    }

    public static class ChangeSetData
    implements WatchManager.ChangeSetData {
        private ChangeSet changeset;
        private final FecruUser mappedUser;
        private String commentUrlAbs;
        private String createReviewUrlAbs;

        public ChangeSetData(ChangeSet changeset, RepositoryEngine rep, FecruUser user) {
            this.changeset = changeset;
            this.mappedUser = user;
            this.commentUrlAbs = null;
            if (AppConfig.isCrucible() && rep.getCfg().isAllowChangesetDiscussions()) {
                this.commentUrlAbs = NavBuilder.changesetDiscussionAbs(null, changeset.getRepName(), changeset.getId());
            }
            if (AppConfig.isCrucible()) {
                this.createReviewUrlAbs = NavBuilder.createReviewAbs(null, changeset.getRepName(), changeset.getId());
            }
        }

        @Override
        public ChangeSet getCs() {
            return this.changeset;
        }

        public Iterator<? extends FileRevision> getRevisionsIterator() {
            return this.changeset.getRevisionsIterable().iterator();
        }

        @Override
        public String getCommentUrlAbs() {
            return this.commentUrlAbs;
        }

        @Override
        public boolean getCanComment() {
            return this.commentUrlAbs != null;
        }

        public String getCreateReviewUrlAbs() {
            return this.createReviewUrlAbs;
        }

        public boolean getCanCreateReview() {
            return this.createReviewUrlAbs != null;
        }

        @Override
        public FecruUser getMappedUser() {
            return this.mappedUser;
        }
    }
}

