/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.util.CollectionsUtil;
import com.cenqua.fisheye.vis.VisualisationPref;
import com.cenqua.fisheye.web.BranchSelectorPref;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class CookiePreferences {
    private static final String LAST_MODIFIED_KEY = "D";
    private static final String COOKIE_PREF_DELIM = ";";
    private static final String DIFFMODE_UNIFIED = "u";
    private static final String DIFFMODE_SIDEBYSIDE = "y";
    private static final String DIFFWRAP_HARD = "h";
    private static final String DIFFWRAP_SOFT = "s";
    private static final String DIFFCONTEXTBAR_SHOW = "s";
    private static final String DIFFCONTEXTBAR_HIDE = "h";
    private static final Map<String, String> CNAME_TO_PNAME = new HashMap<String, String>();
    private static final Map<String, Pref> PREF_MAP = new HashMap<String, Pref>();
    private static final Map<String, String> DEFAULT_PREFS = new HashMap<String, String>();
    private boolean mChanged = false;
    private final Map<String, String> defaultPrefs = DEFAULT_PREFS;
    private Map<String, String> mCustomPrefs = null;
    private Map<String, String> mMapValue = null;
    private Long mLastModified = null;
    private int maxPerRepoPrefs = 20;

    private CookiePreferences(Cookie cookie) {
        this(cookie.getValue());
    }

    private CookiePreferences(String cookieStr) {
        if (StringUtils.isBlank((String)cookieStr)) {
            return;
        }
        try {
            cookieStr = URLDecoder.decode(cookieStr, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            Logs.APP_LOG.debug((Object)("UTF-8 not supported. " + e2));
        }
        StringTokenizer toks = new StringTokenizer(cookieStr, COOKIE_PREF_DELIM, false);
        while (toks.hasMoreTokens()) {
            String tok = toks.nextToken();
            int i2 = tok.indexOf(61);
            if (i2 < 1) {
                this.mChanged = true;
                continue;
            }
            String cname = tok.substring(0, i2);
            int j2 = Math.min(i2 + 1, tok.length() - 1);
            String val = tok.substring(j2, tok.length());
            if (cname.equals(LAST_MODIFIED_KEY)) {
                try {
                    this.mLastModified = Long.valueOf(val);
                }
                catch (NumberFormatException e3) {
                    Logs.APP_LOG.warn((Object)("funny date value: " + val));
                }
                continue;
            }
            String pname = CookiePreferences.cnameToPname(cname);
            if (pname == null) {
                this.mChanged = true;
                continue;
            }
            if (!this.setValueImpl(pname, val, false)) continue;
            this.mChanged = true;
        }
        if (this.mChanged) {
            this.mLastModified = System.currentTimeMillis();
        }
    }

    public static CookiePreferences fromCookie(Cookie cookie) {
        return new CookiePreferences(cookie);
    }

    public static CookiePreferences fromString(String cookieStr) {
        return new CookiePreferences(cookieStr);
    }

    public static void toDb(UserLogin user, CookiePreferences up) {
    }

    public static String getCookieNameForPrefName(String prefName) {
        return CookiePreferences.PREF_MAP.get((Object)prefName).cookieName;
    }

    public Long getLastModified() {
        return this.mLastModified;
    }

    public CookiePreferences() {
    }

    protected CookiePreferences(int maxPerRepoPrefs) {
        this.maxPerRepoPrefs = maxPerRepoPrefs;
    }

    public String asCookieValue() {
        StringBuffer buf = new StringBuffer();
        buf.append(LAST_MODIFIED_KEY).append("=").append(System.currentTimeMillis());
        if (this.mCustomPrefs != null) {
            String sep = COOKIE_PREF_DELIM;
            for (Map.Entry<String, String> pref : this.mCustomPrefs.entrySet()) {
                String pname = pref.getKey();
                String val = pref.getValue();
                String cname = this.pnameToCname(pname);
                buf.append(sep);
                buf.append(cname).append("=").append(val);
                sep = COOKIE_PREF_DELIM;
            }
        }
        return FishEyeURLEncoder.pathEncode(buf.toString());
    }

    public Map<String, String> getMap() {
        if (this.mMapValue == null) {
            this.mMapValue = new HashMap<String, String>(this.defaultPrefs);
            if (this.mCustomPrefs != null) {
                this.mMapValue.putAll(this.mCustomPrefs);
            }
        }
        return this.mMapValue;
    }

    public String getPreference(String name) {
        return this.getMap().get(name);
    }

    private boolean setValueImpl(String pname, String val, boolean putValue) {
        Pref pref;
        String oldVal = this.getPreference(pname);
        this.mMapValue = null;
        this.mLastModified = System.currentTimeMillis();
        String def = CookiePreferences.getDefault(pname);
        if (val.equals(def)) {
            if (this.mCustomPrefs != null) {
                this.mCustomPrefs.remove(pname);
            }
            return true;
        }
        if (this.mCustomPrefs == null) {
            this.mCustomPrefs = new HashMap<String, String>();
        }
        if ((pref = PREF_MAP.get(pname)) == null) {
            return false;
        }
        if (pref.isValidValue(val)) {
            if (putValue && pref.isJson) {
                try {
                    this.putValueImpl(pname, oldVal, val);
                }
                catch (JSONException e2) {
                    Logs.APP_LOG.warn((Object)("Failed to append cookie: " + oldVal + " @+ " + val));
                }
            } else {
                this.mCustomPrefs.put(pname, val);
            }
        }
        return false;
    }

    private void putValueImpl(String pname, String oldVal, String newVal) throws JSONException {
        String key;
        JSONObject newJson;
        JSONObject oldJson;
        if (Strings.isNullOrEmpty((String)newVal)) {
            return;
        }
        try {
            oldJson = this.getJsonValue(oldVal);
        }
        catch (JSONException e2) {
            Logs.APP_LOG.warn((Object)("Existing branch cookie was invalid: " + oldVal + ". Removing old cookie."));
            oldJson = new JSONObject();
        }
        try {
            newJson = this.getJsonValue(newVal);
        }
        catch (JSONException e3) {
            Logs.APP_LOG.warn((Object)("New branch cookie was invalid: " + newVal + ". Ignoring."));
            this.mCustomPrefs.put(pname, oldJson.toString());
            return;
        }
        String[] innerKeys = new String[oldJson.length()];
        try {
            Iterator it = oldJson.keys();
            while (it.hasNext()) {
                String key2 = it.next().toString();
                JSONObject innerObject = (JSONObject)oldJson.get(key2);
                innerKeys[innerObject.getInt((String)"i")] = key2;
            }
        }
        catch (Exception e4) {
            this.putValueImpl(pname, null, newVal);
            return;
        }
        JSONObject returnedJson = new JSONObject();
        int startingIndex = newJson.length() + oldJson.length() - this.maxPerRepoPrefs;
        if (startingIndex < 0) {
            startingIndex = 0;
        }
        for (int i2 = startingIndex; i2 < oldJson.length(); ++i2) {
            key = innerKeys[i2];
            JSONObject innerObject = (JSONObject)oldJson.get(key);
            innerObject.put("i", i2 - startingIndex);
            returnedJson.put(key, (Object)innerObject);
        }
        Iterator it = newJson.keys();
        while (it.hasNext()) {
            key = it.next().toString();
            int i3 = returnedJson.length();
            if (returnedJson.has(key)) {
                JSONObject existing = (JSONObject)returnedJson.get(key);
                i3 = existing.getInt("i");
            }
            JSONObject innerObject = (JSONObject)newJson.get(key);
            innerObject.put("i", i3);
            returnedJson.put(key, (Object)innerObject);
        }
        this.mCustomPrefs.put(pname, returnedJson.toString());
    }

    private JSONObject getJsonValue(String val) throws JSONException {
        JSONObject json = !Strings.isNullOrEmpty((String)val) ? new JSONObject(val) : new JSONObject();
        return json;
    }

    public void setValue(String param, String val) {
        this.setValueImpl(param, val, false);
        this.mChanged = true;
    }

    public void putValue(String param, String val) {
        this.setValueImpl(param, val, true);
        this.mChanged = true;
    }

    public void setValueUsingCookieName(String cookieName, String val) {
        this.setValue(CNAME_TO_PNAME.get(cookieName), val);
    }

    public void putValueUsingCookieName(String cookieName, String val) {
        this.putValue(CNAME_TO_PNAME.get(cookieName), val);
    }

    public void setValue(Pref pref, String val) {
        this.setValue(pref.name, val);
    }

    public boolean isChanged() {
        return this.mChanged;
    }

    public boolean isSideBySide() {
        return DIFFMODE_SIDEBYSIDE.equals(this.getPreference(Pref.DIFF_MODE));
    }

    public boolean isSoftWrap() {
        return "s".equals(this.getPreference(Pref.DIFF_WRAP));
    }

    public boolean isHideDeletedFiles() {
        return "Y".equals(this.getPreference(Pref.HIDE_DELETED));
    }

    public boolean isAlwaysExpandChangesets() {
        return "Y".equals(this.getPreference(Pref.ALWAYS_EXPAND_CHANGESETS));
    }

    public boolean isIncludeUserOnHome() {
        return "Y".equals(this.getPreference(Pref.INCLUDE_USER_ON_HOME));
    }

    public boolean isShowEditModeHelp() {
        return "Y".equals(this.getPreference(Pref.SHOW_EDIT_MODE_HELP));
    }

    public String getImplicitLines() {
        return this.getPreference(Pref.IMPLICIT_LINES);
    }

    public boolean isExpandChangesetHeader() {
        return "Y".equals(this.getPreference(Pref.EXPAND_CHANGESET_HEADER));
    }

    public VisualisationPref getVisualisationPref(String repName) {
        try {
            JSONObject branchPref = this.getJsonValue(this.getPreference(Pref.VIS_BRANCHSET));
            Set<String> branches = VisualisationPref.getVisualisationBranches(branchPref, repName);
            VisualisationPref.Mode mode = VisualisationPref.getVisualisationMode(branchPref, repName);
            JSONObject highlighterPref = this.getJsonValue(this.getPreference(Pref.VIS_HIGHLIGHTER));
            String highlighterName = VisualisationPref.getVisualisationHighlight(highlighterPref, repName);
            return VisualisationPref.newVisualisationPref(repName, branches, highlighterName, mode);
        }
        catch (Exception e2) {
            Logs.APP_LOG.debug((Object)String.format("Invalid branchset cookie found for repo '%s': vbs=[%s],vhl=[%s]", repName, this.getPreference(Pref.VIS_BRANCHSET), this.getPreference(Pref.VIS_HIGHLIGHTER)), (Throwable)e2);
            return VisualisationPref.defaultVisualisationPref();
        }
    }

    public void removeBranchSelectorPrefs() {
        this.removeValue(Pref.LAST_SELECTED_BRANCH_OR_TAG.name);
    }

    public void removeVisualisationPrefs() {
        this.removeValue(Pref.VIS_BRANCHSET.name);
        this.removeValue(Pref.VIS_HIGHLIGHTER.name);
    }

    public void removeValue(String pname) {
        if (this.mCustomPrefs != null && this.mCustomPrefs.remove(pname) != null) {
            this.mMapValue = null;
            this.mLastModified = System.currentTimeMillis();
            this.mChanged = true;
        }
    }

    public BranchSelectorPref getLastBranchPref() {
        try {
            String val = this.getPreference(Pref.LAST_SELECTED_BRANCH_OR_TAG);
            return new BranchSelectorPref(this.getJsonValue(val));
        }
        catch (JSONException e2) {
            Logs.APP_LOG.debug((Object)"Invalid cookie found getting lastBranch cookie", (Throwable)e2);
            return null;
        }
    }

    public Set<String> getVisualisationRepositories() {
        HashSet<String> keys = new HashSet<String>();
        try {
            JSONObject branchPref = this.getJsonValue(this.getPreference(Pref.VIS_BRANCHSET));
            Iterator it = branchPref.keys();
            while (it.hasNext()) {
                keys.add(it.next().toString());
            }
        }
        catch (JSONException e2) {
            Logs.APP_LOG.debug((Object)"Invalid cookie found getting list of repositories from visualisation cookie", (Throwable)e2);
        }
        return keys;
    }

    public BranchSelectorPref.Branch getLastSelectedBranch(String repName) throws JSONException {
        String val = this.getPreference(Pref.LAST_SELECTED_BRANCH_OR_TAG);
        BranchSelectorPref pref = new BranchSelectorPref(this.getJsonValue(val));
        return pref.getSelectedBranchForRepository(repName);
    }

    public String getReviewHistoryTab() {
        return this.getPreference(Pref.REVIEW_HISTORY_TAB);
    }

    public String getSnippetSyntax() {
        return this.getPreference(Pref.SNIPPET_SYNTAX);
    }

    public Integer getSnippetProjectId() {
        String pref = this.getPreference(Pref.SNIPPET_PROJECT);
        if (Strings.isNullOrEmpty((String)pref) || !pref.matches("^[\\d]+$")) {
            return null;
        }
        return Integer.parseInt(pref, 10);
    }

    public String getPreference(Pref p2) {
        return this.getPreference(p2.name);
    }

    public boolean isDiffContextBarVisible() {
        return "s".equals(this.getPreference(Pref.DIFF_CONTEXT_BAR));
    }

    private static String getDefault(String pname) {
        Pref pref = PREF_MAP.get(pname);
        if (pref != null) {
            return pref.defaultValue;
        }
        return "";
    }

    private static String cnameToPname(String cname) {
        return CNAME_TO_PNAME.get(cname);
    }

    private String pnameToCname(String pname) {
        Pref pref = PREF_MAP.get(pname);
        if (pref != null) {
            return pref.cookieName;
        }
        return "UNKNOWN";
    }

    static {
        for (Pref pref : Pref.values()) {
            CNAME_TO_PNAME.put(pref.cookieName, pref.name);
            PREF_MAP.put(pref.name, pref);
            DEFAULT_PREFS.put(pref.name, pref.defaultValue);
        }
    }

    public static enum Pref {
        SHOW_PANEL("showPanel", "shp", "Y", "N"),
        KOPTS("kOpts", "k", "kv", "k", "v", "o"),
        SELECTED_PANEL("selectedPanel", "slp", "a", "t", "o"),
        HIDE_HIDDEN("hideHiddenDirectories", "hhd", "Y", "N"),
        HIDE_DELETED("hideDeletedFiles", "hdf", "N", "Y"),
        HIDE_EMPTY("hideEmptyDirectories", "hed", "N", "Y"),
        LONG_TAG_LIST("longTagList", "ltl", "M", "L", "H"),
        SHOW_FILE_HISTORY_IMAGE("showFileHistImage", "sfhi", "Y", new String[0]),
        SHOW_AUTHOR_CHART("showAuthorChart", "sac", "Y", new String[0]),
        SHOW_QUICK_RECENT("showQuickRecent", "sqr", "Y", new String[0]),
        DIR_LIST_ORDER("dirListOrder", "dlo", "p", "l", "f"),
        CS_SHOW_DIFFS("csShowDiffs", "csSD", "false", "true"),
        CS_TRUNCATE_DIFFS("csTruncateDiffs", "csTD", "true", "false"),
        INCLUDE_USER_ON_HOME("includeUserOnHome", "iuh", "Y", "N"),
        ALWAYS_EXPAND_CHANGESETS("alwaysExpandChangesets", "aec", "N", "Y"),
        VIEW_MODE("viewMode", "hvm", "p", "l"),
        DIFF_MODE("diffMode", "dm", "u", "y"),
        DIFF_WRAP("diffWrap", "dw", "h", "s"),
        DIFF_CONTEXT_BAR("diffContextBar", "dcbt", "s", "h"),
        SHOW_EDIT_MODE_HELP("showEditModeHelp", "semh", "Y", "N"),
        REVIEW_HISTORY_TAB("reviewHistoryTab", "rht", "details", "timeline"),
        ACTIVITY_STREAM_VIEW("activityStreamView", "asv", "all", "fe", "cru", "jira"),
        IMPLICIT_LINES("implicitLines", "impllines", "all", "auth", "none"),
        SNIPPET_SYNTAX("snippetSyntax", "ssyn", "txt", new String[0]),
        SNIPPET_PROJECT("snippetProject", "sprj", "", new String[0]),
        EXPAND_CHANGESET_HEADER("expCsHeader", "xcsh", "N", "Y"),
        LAST_SELECTED_BRANCH_OR_TAG("lastbr", "lsbr", true, "", new String[0]),
        VIS_BRANCHSET("visBranchSet", "vbs", true, "", new String[0]),
        VIS_HIGHLIGHTER("visHighlighter", "vhl", true, "", new String[0]);

        public final String name;
        public final String cookieName;
        public final String defaultValue;
        private final Set<String> possibleValues;
        final boolean isJson;

        private Pref(String name, String cookieName, boolean isJson, String defaultValue, String ... possibleValues) {
            this.name = name;
            this.cookieName = cookieName;
            this.isJson = isJson;
            this.defaultValue = defaultValue;
            if (possibleValues != null && possibleValues.length > 0) {
                Set<String> vals = CollectionsUtil.asSet(possibleValues);
                vals.add(defaultValue);
                this.possibleValues = Collections.unmodifiableSet(vals);
            } else {
                this.possibleValues = null;
            }
        }

        private Pref(String name, String cookieName, String defaultValue, String ... possibleValues) {
            this(name, cookieName, false, defaultValue, possibleValues);
        }

        public boolean isBounded() {
            return this.possibleValues != null;
        }

        public boolean isValidValue(String val) {
            return !this.isBounded() || this.possibleValues.contains(val);
        }
    }
}

