/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.crucible.spi.services.GlobalPermissionService;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.UserProfile;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivityStreamHandler;
import com.atlassian.fisheye.bucket.BucketDataCollectionTotalled;
import com.atlassian.fisheye.bucket.BucketDataElementTotalled;
import com.atlassian.fisheye.bucket.BucketDataTotalled;
import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.ParameterSetQuery;
import com.atlassian.fisheye.bucket.PeriodUnit;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.web.BaseAction;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.ServletUtils;
import com.cenqua.fisheye.web.parameterbeans.BaseActionParams;
import com.cenqua.fisheye.web.parameterbeans.CommitterPageParams;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CommitterPageAction
extends BaseAction {
    @Resource
    private RepositoryManager repositoryManager;
    @Resource
    private GlobalPermissionService globalPermissionService;

    @Override
    public BaseAction handleRequest(BaseActionParams baseParams) throws ServletException, IOException, DbException {
        CommitterPageParams params = new CommitterPageParams(baseParams);
        params.setRSS("true".equals(this.getRequest().getParameter("RSS")));
        this.getRequest().setAttribute("p", (Object)params);
        Path path = this.getPathInfo().getLocalPath();
        if (path.isRoot()) {
            ServletUtils.send404(this.getRequest(), this.getResponse(), "no user name specified");
            return null;
        }
        String committer = path.getComponent(0);
        params.setCommitter(committer);
        RepositoryHandle repository = this.repositoryManager.getRepository(baseParams.getRepname());
        FecruUser feuser = this.committerUserMappingManager.getUserForCommitter(baseParams.getRepname(), committer);
        params.setImplicitlyMapped(this.committerUserMappingManager.explicitMappingExists(baseParams.getRepname(), committer));
        params.setUser(feuser);
        UserLogin currentUser = this.userManager.getCurrentUser(this.getRequest());
        params.setIsThisPageTheCurrentUser(currentUser != null && feuser != null && feuser.getUsername().equals(currentUser.getName()));
        HttpServletRequest request = this.getRequest();
        HttpServletResponse response = this.getResponse();
        if (!this.isAjax(this.getRequest())) {
            ActivityStreamHandler activityHandler = new ActivityStreamHandler(this.globalPermissionService, this.repositoryManager, null, null, null, false, false, this.committerUserMappingManager);
            params.setActivityStreamHandler(activityHandler);
            String view = "fe";
            UserProfile profile = currentUser != null ? this.userProfileManager.getProfile(currentUser.getUserName()) : this.userProfileManager.getDefaultProfile();
            int numItems = profile.getChangesetsPerPage();
            ActivityItemSearchParams activityParams = ActivityItemSearchParams.Builder.fromParams(ActivityStreamHandler.constructGeneralSearchParams(this.getRequest(), numItems, AppConfig.getUserTimeZone(request), view)).anyCommitter(repository.getName(), committer).build();
            activityHandler.handleActivityStream(this.getRequest(), this.getResponse(), activityParams, currentUser, numItems, view, false);
            this.accumulateStats(params, committer);
            if (params.isRSS()) {
                this.getRequest().setAttribute("activityStreamHandler", (Object)params.getActivityStreamHandler());
                this.getRequest().getRequestDispatcher("/WEB-INF/jsp/activityStreamRSS.jsp").forward((ServletRequest)request, (ServletResponse)response);
            } else {
                this.getRequest().getRequestDispatcher("/WEB-INF/jsp/committer/committer.jsp").forward((ServletRequest)request, (ServletResponse)response);
            }
        } else {
            if (feuser != null) {
                Multimap<String, String> otherImplicitCommitters = this.committerUserMappingManager.getImplicitCommittersForUser(feuser);
                Multimap<String, String> otherExplicitCommitters = this.committerUserMappingManager.getExplicitCommittersForUser(feuser);
                params.setPopupSummaryData(new PopupSummaryData(feuser, otherImplicitCommitters, otherExplicitCommitters));
            }
            this.getRequest().getRequestDispatcher("/WEB-INF/jsp/committer/committerSummaryAjax.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        return null;
    }

    @Override
    public boolean requiresValidPath(FishEyePathInfo pi) {
        return false;
    }

    private boolean isAjax(HttpServletRequest request) {
        return "true".equalsIgnoreCase(request.getParameter("ajax"));
    }

    private void accumulateStats(CommitterPageParams params, String committer) throws DbException {
        String br = this.getBranchConstraint(Path.ROOT);
        String extn = "__ALL_EXTENSIONS__";
        int revisionsThisWeek = 0;
        int totalRevisions = 0;
        int loc = 0;
        int locThisWeek = 0;
        RepositoryEngine engine = this.getPathInfo().getEngine();
        BucketGraph graph = engine.getBucketGraph();
        String searchForAuthor = "no_author".equals(committer) ? "__NO_AUTHOR__" : committer;
        BucketDataCollectionTotalled data = graph.getBuckets(new ParameterSetQuery(Path.ROOT, br, extn, searchForAuthor));
        TimeZone tz = graph.getTimeZone();
        BucketDataTotalled bucketData = (BucketDataTotalled)data.getFirst();
        Int2ObjectSortedMap subBranchData = null;
        long subBranchId = 0L;
        if (bucketData != null && !bucketData.getData().isEmpty()) {
            subBranchId = bucketData.getSubBranches().firstLong();
            subBranchData = bucketData.getData(subBranchId);
        }
        if (subBranchData != null) {
            int today = PeriodUnit.DAY.dateToBucket(System.currentTimeMillis(), tz);
            for (Int2ObjectMap.Entry e2 : subBranchData.int2ObjectEntrySet()) {
                BucketDataElementTotalled bde = (BucketDataElementTotalled)e2.getValue();
                int bucket = e2.getIntKey();
                if (bucket > today - 7) {
                    revisionsThisWeek += bde.getRevcount();
                }
                totalRevisions += bde.getRevcount();
            }
            totalRevisions += bucketData.getCumulativeRevsAtBucket(subBranchId, today);
            loc = bucketData.getCumulativeLocAtBucket(subBranchId, today);
            locThisWeek = loc - bucketData.getCumulativeLocAtBucket(subBranchId, today - 7);
        }
        this.calculateCommitDates(params, engine, committer);
        params.setLoc(loc);
        params.setTotalFileRevisions(totalRevisions);
        params.setFileRevisionsThisWeek(revisionsThisWeek);
        params.setLocThisWeek(locThisWeek);
        this.accumulateChangesetStats(params, committer, tz);
    }

    private void calculateCommitDates(CommitterPageParams pageParams, RepositoryEngine engine, String committer) throws DbException {
        ChangeSet changeset = engine.getRevisionCache().findEarliestChangesetForCommitter(committer);
        pageParams.setDateFirstCommitted(changeset == null ? null : changeset.getDateValue());
        changeset = engine.getRevisionCache().findLatestChangesetForCommitter(committer);
        pageParams.setDateLastCommitted(changeset == null ? null : changeset.getDateValue());
    }

    private void accumulateChangesetStats(CommitterPageParams params, String committer, TimeZone tz) throws DbException {
        Calendar calendar = Calendar.getInstance(tz);
        calendar.add(3, -1);
        ActivityItemSearchParams lastWeekItems = ActivityItemSearchParams.Builder.fromParams(this.constructParams(params.getRepname(), committer, tz, params.getPath())).minDate(calendar.getTime()).build();
        params.setTotalCommits(this.getRepositoryCache().countChangeSets(params.getPath(), committer));
        params.setTotalCommitsThisWeek(this.getRepositoryCache().countChangeSets(lastWeekItems));
    }

    private ActivityItemSearchParams constructParams(String rep, String committer, TimeZone tz, Path path) {
        ActivityItemSearchParams.Builder builder = ActivityItemSearchParams.builder();
        builder.maxItems(1).includeFisheye().timeZone(tz);
        builder.repository(rep).setCompulsoryCommitter(committer).path(rep, path);
        return builder.build();
    }

    public static class PopupSummaryData {
        private final FecruUser user;
        private final Multimap<String, String> otherImplicitCommitters;
        private final Multimap<String, String> otherExplicitCommitters;

        public PopupSummaryData(FecruUser user, Multimap<String, String> otherImplicitCommitters, Multimap<String, String> otherExplicitCommitters) {
            this.user = user;
            this.otherExplicitCommitters = otherExplicitCommitters;
            this.otherImplicitCommitters = otherImplicitCommitters;
        }

        public FecruUser getUser() {
            return this.user;
        }

        public Map<String, Collection<String>> getOtherImplicitCommitters() {
            return this.otherImplicitCommitters.asMap();
        }

        public Map<String, Collection<String>> getOtherExplicitCommitters() {
            return this.otherExplicitCommitters.asMap();
        }
    }
}

