/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.fecru.utils.HttpUtils;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.RepositoryConstraints;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.csindex.ActivityCalendar;
import com.cenqua.fisheye.csindex.Util;
import com.cenqua.fisheye.histogram.FisheyeChartFactory;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.vis.ChartDimension;
import com.cenqua.fisheye.vis.ColourScheme;
import com.cenqua.fisheye.vis.DefaultColourScheme;
import com.cenqua.fisheye.vis.KeyLockedColourScheme;
import com.cenqua.fisheye.vis.LineCountChartUtils;
import com.cenqua.fisheye.vis.SidebarChartData;
import com.cenqua.fisheye.vis.SidebarChartDataCalculator;
import com.cenqua.fisheye.web.util.RepositoryUtil;
import com.google.common.collect.Multimap;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import com.opensymphony.webwork.interceptor.ServletResponseAware;
import com.opensymphony.xwork.ActionSupport;
import com.sun.istack.Nullable;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.imagemap.ImageMapUtilities;
import org.json.JSONException;

public class CommitActivityChartAction
extends ActionSupport
implements ServletRequestAware,
ServletResponseAware {
    private HttpServletResponse response;
    private HttpServletRequest request;
    @Resource
    private CommitterUserMappingManager committerUserMappingManager;
    @Resource
    protected TxTemplate txTemplate;
    private int w = 200;
    private int h = 200;
    private String extn;
    private String committer;
    private Date startDate = null;
    private Date endDate = null;
    private String br;
    private String context;
    private String repname;
    private Path path;
    private String username;
    private String projectkey;
    private String outputtype;
    private String mapName;
    @Resource
    private ProjectManager projectManager;
    private Color imageBackgroundColour;
    private ActivityCalendar activityCalendar;

    private TimeZone getTimeZoneForAction() {
        return AppConfig.getUserTimeZone(this.request);
    }

    @RequireSecurityToken(value=false)
    public String doCommitChartDay() throws Exception {
        TimeZone tz = this.getTimeZoneForAction();
        ActivityItemSearchParams params = this.constructParams(tz);
        HttpUtils.addCacheHeadersOneHour(this.response);
        if ("json".equals(this.outputtype)) {
            this.response.setContentType("application/json");
            FisheyeChartFactory.outputDailyCommitJson(new OutputStreamWriter((OutputStream)this.response.getOutputStream()), params, this.txTemplate.getEffectivePrincipal(), "project".equals(this.context), this.getColourScheme());
        } else {
            JFreeChart chart = FisheyeChartFactory.createDailyCommitChart(params, this.txTemplate.getEffectivePrincipal(), this.getColourScheme(), "project".equals(this.context));
            this.processChart(chart);
        }
        return "none";
    }

    private ColourScheme getColourScheme() throws DbException {
        if ("globaluserlist".equals(this.context) || "repository".equals(this.context)) {
            TreeSet<String> reps = new TreeSet<String>();
            for (RepositoryHandle rep : RepositoryUtil.repositories(this.txTemplate.getEffectivePrincipal())) {
                reps.add(rep.getName());
            }
            return new KeyLockedColourScheme(new ArrayList<String>(reps), this.imageBackgroundColour);
        }
        if ("changelog".equals(this.context)) {
            return new DefaultColourScheme(true, this.imageBackgroundColour);
        }
        if ("user".equals(this.context)) {
            return new DefaultColourScheme(this.imageBackgroundColour);
        }
        if (this.repname == null && !this.context.equals("project")) {
            return new DefaultColourScheme(this.imageBackgroundColour);
        }
        return new DefaultColourScheme(this.imageBackgroundColour);
    }

    @RequireSecurityToken(value=false)
    public String doCommitChartHour() throws Exception {
        TimeZone tz = this.getTimeZoneForAction();
        ActivityItemSearchParams params = this.constructParams(tz);
        HttpUtils.addCacheHeadersOneHour(this.response);
        if ("json".equals(this.outputtype)) {
            this.response.setContentType("application/json");
            FisheyeChartFactory.outputHourlyCommitJson(new OutputStreamWriter((OutputStream)this.response.getOutputStream()), params, this.txTemplate.getEffectivePrincipal(), "project".equals(this.context), this.getColourScheme());
        } else {
            JFreeChart chart = FisheyeChartFactory.createHourlyCommitChart(params, this.txTemplate.getEffectivePrincipal(), this.getColourScheme(), "project".equals(this.context));
            this.processChart(chart);
        }
        return "none";
    }

    @RequireSecurityToken(value=false)
    public String doSparkline() throws Exception {
        TimeZone tz = this.getTimeZoneForAction();
        ActivityItemSearchParams params = this.constructParams(tz);
        HttpUtils.addCacheHeadersOneHour(this.response);
        if ("json".equals(this.outputtype)) {
            this.response.setContentType("application/json");
            FisheyeChartFactory.outputCommitSparklineJson(new OutputStreamWriter((OutputStream)this.response.getOutputStream()), params, this.txTemplate.getEffectivePrincipal(), "project".equals(this.context));
        } else {
            JFreeChart chart = FisheyeChartFactory.createCommitSparkline(params, this.txTemplate.getEffectivePrincipal(), this.getColourScheme(), "project".equals(this.context));
            this.processChart(chart);
        }
        return "none";
    }

    @RequireSecurityToken(value=false)
    public String doActivityCalendar() throws Exception {
        TimeZone tz = this.getTimeZoneForAction();
        ActivityItemSearchParams params = this.constructParams(tz);
        HttpUtils.addCacheHeadersOneHour(this.response);
        if ("json".equals(this.outputtype)) {
            this.response.setContentType("application/json");
            FisheyeChartFactory.outputActivityCalendarJson(new OutputStreamWriter((OutputStream)this.response.getOutputStream()), params, this.txTemplate.getEffectivePrincipal(), "project".equals(this.context));
            return "none";
        }
        this.activityCalendar = FisheyeChartFactory.createActivityCalendar(params, this.txTemplate.getEffectivePrincipal());
        return "success";
    }

    private String processChart(JFreeChart chart) throws Exception {
        if (chart != null) {
            ChartRenderingInfo info = new ChartRenderingInfo();
            BufferedImage image = chart.createBufferedImage(this.w, this.h, info);
            if (this.outputtype.equals("image")) {
                this.response.setContentType(LineCountChartUtils.getImageContentType());
                ChartUtilities.writeBufferedImageAsPNG((OutputStream)this.response.getOutputStream(), (BufferedImage)image);
            } else if (this.outputtype.equals("imagemap")) {
                String imageMap = ImageMapUtilities.getImageMap((String)this.mapName, (ChartRenderingInfo)info);
                this.response.getOutputStream().write(imageMap.getBytes());
                this.response.getOutputStream().flush();
            }
        }
        return "success";
    }

    @Nullable
    protected ActivityItemSearchParams constructParams(TimeZone tz) throws DbException {
        ActivityItemSearchParams.Builder builder = new ActivityItemSearchParams.Builder();
        builder.maxItems(1).timeZone(tz).includeCrucible();
        if (this.context.equals("user") || "globaluserlist".equals(this.context)) {
            RepositoryConstraints repConstraints = new RepositoryConstraints();
            if (this.repname == null) {
                Multimap<String, String> committerMap = this.committerUserMappingManager.getAllCommittersForUser(this.username);
                for (Map.Entry entry : committerMap.entries()) {
                    repConstraints.addCommitter((String)entry.getKey(), (String)entry.getValue());
                }
            } else {
                List<String> committers = this.committerUserMappingManager.getAllCommittersForUserInRep(this.repname, this.username);
                for (String committer : committers) {
                    repConstraints.addCommitter(this.repname, committer);
                }
                if (repConstraints.getConstraintsForRep(this.repname) == null) {
                    return null;
                }
                if (this.path != null) {
                    repConstraints.addPath(this.repname, this.path.getPath());
                }
                if (this.br != null) {
                    builder.setBranch(this.br);
                }
            }
            builder.crossRepositoryConstraint(repConstraints);
        } else if (this.context.equals("committer")) {
            builder.repository(this.repname).setCompulsoryCommitter(this.committer);
            if (this.br != null) {
                builder.setBranch(this.br);
            }
        } else if (this.context.equals("project")) {
            Project project = this.projectManager.getProjectByKey(this.projectkey);
            builder.project(project);
        } else if (this.context.equals("repository")) {
            builder.repository(this.repname);
            if (this.br != null) {
                builder.setBranch(this.br);
            }
        } else if (this.context.equals("changelog")) {
            if (this.path == null) {
                builder.repository(this.repname);
            } else {
                builder.path(this.repname, this.path);
            }
            if (this.startDate != null) {
                builder.minDate(this.startDate);
            }
            if (this.endDate != null) {
                builder.maxDate(this.endDate);
            }
            if (this.br != null) {
                builder.setBranch(this.br);
            }
            if (this.extn != null) {
                builder.setFileExtension(this.extn);
            }
        }
        return builder.build();
    }

    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setW(String w2) {
        try {
            this.w = ChartDimension.restrictDimension(Integer.parseInt(w2));
        }
        catch (NumberFormatException e2) {
            Logs.APP_LOG.warn((Object)"Chart width passed that isn't an integer ", (Throwable)e2);
        }
    }

    public void setH(String h2) {
        try {
            this.h = ChartDimension.restrictDimension(Integer.parseInt(h2));
        }
        catch (NumberFormatException e2) {
            Logs.APP_LOG.warn((Object)"Chart height passed that isn't an integer ", (Throwable)e2);
        }
    }

    public void setExtn(String extn) {
        this.extn = extn;
    }

    public void setCommitter(String committer) {
        this.committer = committer;
    }

    public void setBr(String br) {
        this.br = br;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setRepname(String repname) {
        this.repname = repname;
    }

    public void setPath(String path) {
        this.path = new Path(path);
    }

    public void setOutputtype(String outputtype) {
        this.outputtype = outputtype;
    }

    public void setMapName(String mapName) {
        this.mapName = mapName;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setImageBackgroundColour(String hexColour) {
        this.imageBackgroundColour = Util.fromHexString(hexColour);
        if (this.imageBackgroundColour == null) {
            this.imageBackgroundColour = Color.white;
        }
    }

    public Color getImageBackgroundColour() {
        return this.imageBackgroundColour;
    }

    public void setProjectkey(String projectkey) {
        this.projectkey = Project.upperCaseProjectKey(projectkey);
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        Long l2 = Long.parseLong(startDate);
        this.startDate = l2 != null ? new Date(l2) : null;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        Long l2 = Long.parseLong(endDate);
        this.endDate = l2 != null ? new Date(l2) : null;
    }

    public ActivityCalendar getActivityCalendar() {
        return this.activityCalendar;
    }

    @RequireSecurityToken(value=false)
    public String doSidebarChartsJson() throws DbException, IOException, JSONException {
        SidebarChartDataCalculator sidebarChartDataCalculator = new SidebarChartDataCalculator();
        this.response.setContentType("application/json");
        HttpUtils.addCacheHeadersOneHour(this.response);
        if ("user".equals(this.context)) {
            SidebarChartData data = sidebarChartDataCalculator.getUserData(this.request, this.txTemplate.getEffectivePrincipal(), this.w, this.username);
            data.writeJson(new OutputStreamWriter((OutputStream)this.response.getOutputStream()));
        } else if ("committer".equals(this.context)) {
            SidebarChartData data = sidebarChartDataCalculator.getCommitterData(this.request, this.txTemplate.getEffectivePrincipal(), this.w, this.repname, this.committer);
            data.writeJson(new OutputStreamWriter((OutputStream)this.response.getOutputStream()));
        }
        return "none";
    }
}

