/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.web.util.WayBackUrlEncoder;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class CommandString {
    private String commandWord;
    private ListMultimap<String, String> commandParams;

    public CommandString(String cmdStr) {
        StringTokenizer tok = new StringTokenizer(cmdStr, ",", false);
        if (tok.hasMoreTokens()) {
            this.parseCommandComponent(WayBackUrlEncoder.commandUrlDecode(tok.nextToken()), true);
            while (tok.hasMoreTokens()) {
                String str = WayBackUrlEncoder.commandUrlDecode(tok.nextToken());
                this.parseCommandComponent(str, false);
            }
        }
    }

    public CommandString(String commandWord, ListMultimap<String, String> commandParams) {
        this.commandWord = commandWord;
        this.commandParams = commandParams;
    }

    public String getCommandWord() {
        return this.commandWord;
    }

    public void setCommandWord(String commandWord) {
        this.commandWord = commandWord;
    }

    public String getCommandParam(String key) {
        if (this.commandParams == null) {
            return null;
        }
        List valsForKey = this.commandParams.get((Object)key);
        return valsForKey == null || valsForKey.isEmpty() ? null : (String)valsForKey.iterator().next();
    }

    public List<String> getCommandParams(String key) {
        if (this.commandParams == null) {
            return null;
        }
        return this.commandParams.get((Object)key);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.commandWord != null) {
            buf.append(this.commandWord);
        }
        if (this.commandParams != null && this.commandParams.size() > 0) {
            if (this.commandWord != null) {
                buf.append(",");
            }
            String sep = "";
            for (Map.Entry entry : this.commandParams.entries()) {
                buf.append(sep).append((String)entry.getKey()).append("=").append((String)entry.getValue());
                sep = ",";
            }
        }
        return buf.toString();
    }

    public String toUrlString() {
        StringBuilder buf = new StringBuilder();
        if (this.commandWord != null) {
            buf.append(this.commandWord);
        }
        if (this.commandParams != null && this.commandParams.size() > 0) {
            if (this.commandWord != null) {
                buf.append(",");
            }
            String sep = "";
            for (Map.Entry entry : this.commandParams.entries()) {
                buf.append(sep).append((String)entry.getKey()).append("=").append(WayBackUrlEncoder.commandUrlEncode((String)entry.getValue()));
                sep = ",";
            }
        }
        return buf.toString();
    }

    private void parseCommandComponent(String str, boolean isFirst) {
        if (str.length() == 0) {
            return;
        }
        int i2 = str.indexOf(61);
        if (i2 != -1) {
            String key = str.substring(0, i2);
            String value = str.substring(i2 + 1, str.length());
            this.addCommandParam(key, value);
        } else if (isFirst) {
            this.commandWord = str;
        } else {
            this.addCommandParam(str, str);
        }
    }

    private void addCommandParam(String key, String value) {
        if (this.commandParams == null) {
            this.commandParams = ArrayListMultimap.create();
        }
        this.commandParams.put((Object)key, (Object)value);
    }
}

