/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.web.BaseAction;
import com.cenqua.fisheye.web.FisheyeRepositoryExplorer;
import com.cenqua.fisheye.web.ServletUtils;
import com.cenqua.fisheye.web.UrlHelper;
import com.cenqua.fisheye.web.WaybackSpecChart;
import com.cenqua.fisheye.web.parameterbeans.BaseActionParams;
import com.cenqua.fisheye.web.parameterbeans.ChartPageActionParams;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ChartPageAction
extends BaseAction {
    private RepositoryEngine engine;
    private WaybackSpecChart wb = new WaybackSpecChart();

    @Override
    public void setup() {
        this.engine = this.getPathInfo().getEngine();
    }

    private void parseWaybackSpecFromRequest(HttpServletRequest req) {
        WaybackSpecChart wbSpec = WaybackSpecChart.fromRequest(req);
        if (wbSpec != null) {
            this.wb = wbSpec;
        }
    }

    @Override
    public BaseAction handleRequest(BaseActionParams baseParams) throws ServletException, IOException, DbException {
        Path localPath = this.getPathInfo().getLocalPath();
        HttpServletRequest req = this.getRequest();
        if (this.handleWaybackJump("/chart", baseParams.getUserPrefs())) {
            return null;
        }
        this.parseWaybackSpecFromRequest(req);
        if (this.handleSvnConflictingBranches("/chart", this.engine)) {
            return null;
        }
        if (req.getParameter("renderChart") != null) {
            UrlHelper url = new UrlHelper();
            url.setUrl(req.getContextPath() + "/fe/locChart.do");
            url.putParam("w", req.getParameter("w"));
            url.putParam("h", req.getParameter("h"));
            if (this.wb != null) {
                url.putParam("yaxistype", this.wb.getAxisType());
                url.putParam("maxitems", this.wb.getMaxItems());
                if (this.wb.getExtns() != null) {
                    url.putParam("extn", this.wb.getExtns().toArray());
                }
                if (this.wb.getAuthors() != null) {
                    url.putParam("author", this.wb.getAuthors().toArray());
                }
                url.putParam("endDate", this.wb.getDate2Str());
                url.putParam("startDate", this.wb.getDate1Str());
                url.putParam("charttype", this.wb.getChartType());
                url.putParam("stacktype", this.wb.getStackType());
                url.putParam("br", this.wb.getBranch());
                url.putParam("tag", this.wb.getTag());
            }
            if (req.getParameter("context") != null) {
                url.putParam("context", req.getParameter("context"));
            } else {
                url.putParam("context", "preivew");
            }
            url.putParam("repname", baseParams.getRepname());
            url.putParam("path", localPath);
            this.getResponse().sendRedirect(url.toString());
            return null;
        }
        ChartPageActionParams params = new ChartPageActionParams(baseParams);
        this.getRequest().setAttribute("p", (Object)params);
        params.setWbSpecChart(this.wb);
        params.setupChartDropdowns(localPath, this.engine);
        params.setFpath(this.getPathInfo().getFullPath());
        params.setPath(this.getPathInfo().getLocalPath());
        params.setPathInfo(this.getPathInfo());
        params.setRepositoryExplorer(new FisheyeRepositoryExplorer(this.engine, this.getPathInfo().getLocalPath(), this.wb, this.getUserPreferences()));
        params.setShowAuthorLinecount(this.engine.getRevisionCache().isAuthorLocEnabled());
        this.getRequest().getRequestDispatcher("/WEB-INF/jsp/chart.jsp").forward((ServletRequest)this.getRequest(), (ServletResponse)this.getResponse());
        return null;
    }

    @Override
    public void handleNoRepository(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        ServletUtils.forward("/WEB-INF/jsp/reportList.jsp", req, resp);
    }
}

