/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.fisheye.Visitor;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.web.ChangeSetHolder;
import com.cenqua.fisheye.web.WaybackSpec;
import com.opensymphony.xwork.ActionSupport;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class ChangesetTooltipAction
extends ActionSupport {
    private static int MAX_REVISIONS = 10;
    private String csid;
    private ChangeSet changeset;
    private String repname;
    private List<FileRevision> fileRevisions = new ArrayList<FileRevision>();
    private int moreRevisionsCount = 0;
    private ChangeSetHolder changeSetHolder;
    private boolean supportsRepositoryGraph = false;
    @Autowired
    private RepositoryManager repositoryManager;
    @Autowired
    private UserManager userManager;
    @Autowired
    private TxTemplate txTemplate;
    @Autowired
    private CommitterUserMappingManager committerUserMappingManager;

    public String getRepname() {
        return this.repname;
    }

    public void setRepname(String repname) {
        this.repname = repname;
    }

    public String getCsid() {
        return this.csid;
    }

    public void setCsid(String csid) {
        this.csid = csid;
    }

    public boolean isChangesetFound() {
        return this.changeset != null;
    }

    public String getChangesetComment() {
        return this.changeset.getComment();
    }

    public String getChangesetDisplayId() {
        return this.changeset.getDisplayId();
    }

    public String getChangesetAuthor() {
        return this.changeset.getAuthor();
    }

    public Date getChangesetDate() {
        return this.changeset.getDateValue();
    }

    public String getChangesetBranch() {
        return this.changeset.getBranch();
    }

    public String getChangesetPrimaryBranch() {
        return this.changeSetHolder.getMostRelevantBranch();
    }

    public List<FileRevision> getFirstRevisions() {
        return this.fileRevisions;
    }

    public int getMoreRevisionsCount() {
        return this.moreRevisionsCount;
    }

    public boolean isSupportsRepositoryGraph() {
        return this.supportsRepositoryGraph;
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        Disposer.pushThreadInstance();
        try {
            RepositoryHandle handle = this.repositoryManager.getRepository(this.repname);
            if (handle != null && this.userManager.hasPermissionToAccess(this.txTemplate.getEffectivePrincipal(), handle)) {
                this.supportsRepositoryGraph = handle.getCfg().isSupportsCommitGraph();
                RevisionCache<? extends ChangeSet> revCache = handle.acquireEngine().getRevisionCache();
                this.changeset = revCache.getChangeSet(this.csid);
                if (this.changeset != null) {
                    this.changeset.visitRevisions(new Visitor<FileRevision>(){

                        @Override
                        public void visit(FileRevision rev) {
                            if (ChangesetTooltipAction.this.fileRevisions.size() < MAX_REVISIONS) {
                                ChangesetTooltipAction.this.fileRevisions.add(rev);
                            } else {
                                ChangesetTooltipAction.this.moreRevisionsCount++;
                            }
                        }
                    });
                    this.changeSetHolder = new ChangeSetHolder(this.changeset, new ChangeSetHolder.Context(new WaybackSpec(), revCache.isCaseSensitive(), MAX_REVISIONS, Path.ROOT, handle.getName(), revCache.getRepositoryType(), revCache.getDefaultBranch()), handle.getCfg().isSupportsBranchFilter(), this.committerUserMappingManager);
                }
            }
        }
        catch (Exception e2) {
            Logs.APP_LOG.warn((Object)("Unable to retrieve changeset " + this.csid + " in rep " + this.repname), (Throwable)e2);
            this.addActionError("Unable to retrieve changeset " + this.csid + ". " + e2.getMessage());
            String string = "error";
            return string;
        }
        finally {
            Disposer.popThreadInstance();
        }
        return "success";
    }
}

