/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.crucible.spi.services.GlobalPermissionService;
import com.atlassian.fecru.user.UserProfile;
import com.atlassian.fecru.user.UserProfileManager;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivityStreamHandler;
import com.atlassian.fisheye.activity.RssFeedUrlBuilder;
import com.atlassian.fisheye.bucket.BucketDataCollectionTotalled;
import com.atlassian.fisheye.bucket.BucketDataTotalled;
import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.ParameterSetQuery;
import com.atlassian.fisheye.bucket.PeriodUnit;
import com.atlassian.fisheye.spi.services.CommitterDataService;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.csindex.ChangesetStatsCalculator;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.BaseAction;
import com.cenqua.fisheye.web.CommandString;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.FisheyeChangelogExplorer;
import com.cenqua.fisheye.web.FisheyeRepositoryExplorer;
import com.cenqua.fisheye.web.PreferenceManager;
import com.cenqua.fisheye.web.ServletUtils;
import com.cenqua.fisheye.web.parameterbeans.BaseActionParams;
import com.cenqua.fisheye.web.parameterbeans.ChangelogServletParams;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class ChangelogServlet
extends BaseAction {
    public static final String CHANGELOG_SERVLET_PATH = "changelog";
    private static final String SLASH_CHANGELOG_SERVLET_PATH = "/changelog";
    @Resource
    private RepositoryManager repositoryManager;
    @Resource
    private GlobalPermissionService globalPermissionService;
    @Resource
    protected CommitterDataService committerDataService;
    public static final int NUM_ACTIVE_COMMITTERS = 9;
    public static final int RECENT = -90;

    @Override
    public BaseAction handleRequest(BaseActionParams baseParams) throws ServletException, IOException, DbException {
        HttpServletRequest req = this.getRequest();
        ChangelogServletParams params = new ChangelogServletParams(baseParams);
        this.getRequest().setAttribute("p", (Object)params);
        params.setRequiresAuth(this.requiresAuth());
        this.parseWaybackSpec();
        this.parseActivityItemSearchParams(AppConfig.getUserTimeZone(req), baseParams.getRepname());
        params.setWbSpec(this.waybackSpec);
        params.setActivityStreamParams(this.activityStreamParams);
        params.setExpand(this.getUserPreferences().isAlwaysExpandChangesets());
        if (this.handleWaybackJump(SLASH_CHANGELOG_SERVLET_PATH, params.getUserPrefs())) {
            return null;
        }
        FishEyePathInfo pi = this.getPathInfo();
        if (this.handleSvnConflictingBranches(SLASH_CHANGELOG_SERVLET_PATH, pi.getEngine())) {
            return null;
        }
        if ("rss".equals(pi.getCommandWord())) {
            this.doRssRequest();
            return null;
        }
        String csidStr = req.getParameter("cs");
        if (StringUtils.isNotBlank((String)csidStr)) {
            this.doViewChangeset(params);
        } else {
            this.doViewDir(params);
        }
        return null;
    }

    @Override
    public boolean requiresValidPath(FishEyePathInfo pi) {
        return !"rss".equals(pi.getCommandWord());
    }

    private void doRssRequest() throws DbException, IOException {
        Path lpath;
        HttpServletRequest req = this.getRequest();
        FishEyePathInfo pi = this.getPathInfo();
        CommandString cs = pi.getCommandString();
        if (cs != null) {
            cs.setCommandWord(null);
        }
        if ("rss.xml".equals((lpath = pi.getLocalPath()).getName())) {
            lpath = lpath.trimLast();
        }
        pi = new FishEyePathInfo(cs, pi.getRepname(), lpath);
        RssFeedUrlBuilder builder = new RssFeedUrlBuilder(req, SLASH_CHANGELOG_SERVLET_PATH);
        builder.addRssQueryParameters(req.getParameterMap());
        builder.setAuthenticationRequired(this.requiresAuth());
        builder.setPathInfo(pi);
        builder.setView("fe");
        this.getResponse().sendRedirect(req.getContextPath() + builder.build().toString());
    }

    private void doViewDir(ChangelogServletParams params) throws IOException, ServletException, DbException {
        boolean isShowIdMode;
        Long[] d2;
        String jumpToId;
        long t0 = System.currentTimeMillis();
        if (this.handleWatches(SLASH_CHANGELOG_SERVLET_PATH, params.getWatchParams())) {
            return;
        }
        RevisionCache<? extends ChangeSet> crep = this.getRepositoryCache();
        RepositoryEngine engine = this.getPathInfo().getEngine();
        Path lpath = this.getPathInfo().getLocalPath();
        TimeZone tz = AppConfig.getUserTimeZone(this.getRequest());
        Calendar cal = Calendar.getInstance(tz);
        cal.add(3, -1);
        ActivityItemSearchParams.Builder searchParamsBuilder = ActivityItemSearchParams.builder();
        searchParamsBuilder.includeFisheye().minDate(cal.getTime()).maxItems(1).timeZone(tz).path(params.getRepname(), lpath);
        ChangesetStatsCalculator calculator = new ChangesetStatsCalculator(searchParamsBuilder.build());
        params.setCommitsThisWeek(calculator.count(engine.getCrossRepLuceneConnection()));
        this.accumulateStats(params, lpath, engine);
        int changesetsPerPage = 30;
        int filesPerChangeset = UserProfileManager.DEFAULT_PROFILE.getMaxFilesPerChangeset();
        UserLogin user = this.getUserManager().getCurrentUser(this.getRequest());
        if (user != null) {
            try {
                UserProfile profile = this.getUserProfileManager().getProfile(user.getUsername());
                changesetsPerPage = profile.getChangesetsPerPage();
                filesPerChangeset = profile.getMaxFilesPerChangeset();
            }
            catch (DbException e2) {
                Logs.APP_LOG.warn((Object)("Database exception thrown when access user profile for " + user.getUsername()), (Throwable)e2);
            }
        }
        if (this.getRequest().getParameter("max") != null) {
            changesetsPerPage = Math.min(Integer.parseInt(this.getRequest().getParameter("max"), 10), 100);
        }
        FisheyeChangelogExplorer clogExplorer = new FisheyeChangelogExplorer(lpath, crep, this.waybackSpec);
        String fromId = this.getRequest().getParameter("fromid");
        String toId = this.getRequest().getParameter("toid");
        boolean idBoundInclusive = ServletUtils.parseBooleanFromRequest("inc", false, this.getRequest());
        String showId = this.getRequest().getParameter("showid");
        if (showId == null && (jumpToId = this.getRequest().getParameter("jumptoid")) != null) {
            showId = jumpToId;
        }
        if (showId != null) {
            idBoundInclusive = true;
            toId = showId;
        }
        if (fromId != null) {
            clogExplorer.setFromChangeSetId(fromId);
            clogExplorer.setFromChangeSetIdInc(idBoundInclusive);
        } else if (toId != null) {
            clogExplorer.setToChangeSetId(toId);
            clogExplorer.setToChangeSetIdInc(idBoundInclusive);
        } else if (showId != null) {
            clogExplorer.setShowChangeSetId(showId);
        }
        Long toDate = ServletUtils.parseLongFromRequest("todate", this.getRequest());
        String toFromDate = this.getRequest().getParameter("tofromdate");
        if (toFromDate != null && (d2 = this.parseTwoLongs(toFromDate))[1] != null) {
            toDate = d2[1];
        }
        if (toDate != null) {
            clogExplorer.setToDate(toDate);
        }
        params.setLastCommit(this.calculateLastCommit(engine, lpath));
        params.setRepositoryExplorer(new FisheyeRepositoryExplorer(engine, lpath, this.waybackSpec, this.getUserPreferences()));
        params.setPathInfo(this.getPathInfo());
        params.setPath(lpath);
        params.setMaxFilesPerChangeset(filesPerChangeset);
        params.setFpath(this.getPathInfo().getFullPath());
        params.setRSS("true".equals(this.getRequest().getParameter("RSS")));
        params.setNumCommitters(this.committerDataService.countCommitters(this.getPathInfo().getRepname(), this.getPathInfo().getLocalPath()));
        params.setChangelog(clogExplorer);
        HttpServletRequest req = this.getRequest();
        ActivityStreamHandler handler = new ActivityStreamHandler(this.globalPermissionService, this.getRepositoryManager(), "/WEB-INF/jsp/changelogdir.jsp", "/WEB-INF/jsp/activityStreamRSS.jsp", "/WEB-INF/jsp/activitystreamAjax.jsp", false, true, this.committerUserMappingManager);
        boolean bl = isShowIdMode = showId != null;
        String view = isShowIdMode ? "fe" : (req.getParameter("view") == null ? PreferenceManager.getPreference(req, "activityStreamView") : req.getParameter("view"));
        params.setView(view);
        this.activityStreamParams = ActivityStreamHandler.constructSearchParams(req, changesetsPerPage, AppConfig.getUserTimeZone(req), view);
        ActivityItemSearchParams.Builder builder = ActivityItemSearchParams.Builder.fromParams(this.activityStreamParams).maxItems(changesetsPerPage).timeZone(AppConfig.getUserTimeZone(req)).changelogExplorer(clogExplorer);
        if (isShowIdMode) {
            List<String> similarCsIds;
            Object maybeChangeSet = crep.getChangeSet(showId);
            if (maybeChangeSet == null && (similarCsIds = crep.findSimilarPartialChangeSetIds(showId)).size() > 0) {
                maybeChangeSet = crep.getChangeSet(similarCsIds.get(0));
            }
            builder.maxDate(maybeChangeSet == null ? new Date() : maybeChangeSet.getDateValue());
        }
        ActivityItemSearchParams activityParams = builder.build();
        long t1 = System.currentTimeMillis();
        handler.handleActivityStream(req, this.getResponse(), activityParams, user, changesetsPerPage, view, isShowIdMode);
        long t2 = System.currentTimeMillis();
        if (Logs.APP_LOG.isDebugEnabled()) {
            Logs.APP_LOG.debug((Object)("changelogViewDir-page for /" + lpath + " in " + (t1 - t0) + "ms then " + (t2 - t1) + "ms for render"));
        }
    }

    private Date calculateLastCommit(RepositoryEngine engine, Path lpath) throws DbException {
        FileRevision latestFileRevision = engine.getRevisionCache().getLatestFileRevision(lpath);
        return latestFileRevision == null ? null : latestFileRevision.getDateValue();
    }

    private Long[] parseTwoLongs(String s2) {
        Long a2 = null;
        Long b2 = null;
        int idx = s2.indexOf(45);
        if (idx != -1) {
            try {
                a2 = Long.valueOf(s2.substring(0, idx));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                b2 = Long.valueOf(s2.substring(idx + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new Long[]{a2, b2};
    }

    private void accumulateStats(ChangelogServletParams params, Path lpath, RepositoryEngine engine) throws DbException {
        BucketGraph graph = engine.getBucketGraph();
        BucketDataCollectionTotalled data = graph.getBuckets(new ParameterSetQuery(lpath, this.getBranchConstraint(Path.ROOT), null, null, null));
        TimeZone tz = graph.getTimeZone();
        BucketDataTotalled bucketData = (BucketDataTotalled)data.getFirst();
        Int2ObjectSortedMap subBranchData = null;
        long subBranchId = 0L;
        if (bucketData != null && !bucketData.getData().isEmpty()) {
            subBranchId = bucketData.getSubBranches().firstLong();
            subBranchData = bucketData.getData(subBranchId);
        }
        if (subBranchData != null) {
            int today = PeriodUnit.DAY.dateToBucket(System.currentTimeMillis(), tz);
            int loc = bucketData.getCumulativeLocAtBucket(subBranchId, today);
            int locThisWeek = loc - bucketData.getCumulativeLocAtBucket(subBranchId, today - 7);
            params.setLinesAddedThisWeek(locThisWeek);
            params.setTotalLoc(loc);
        }
    }

    private void doViewChangeset(ChangelogServletParams params) throws ServletException, IOException, DbException {
        HttpServletRequest req = this.getRequest();
        UserLogin user = this.getUserManager().getCurrentUser(this.getRequest());
        ActivityStreamHandler handler = new ActivityStreamHandler(this.globalPermissionService, this.getRepositoryManager(), "/WEB-INF/jsp/changeset.jsp", "/WEB-INF/jsp/activityStreamRSS.jsp", "/WEB-INF/jsp/activitystreamAjax.jsp", false, true, this.committerUserMappingManager);
        String view = req.getParameter("view") == null ? PreferenceManager.getPreference(req, "activityStreamView") : req.getParameter("view");
        this.activityStreamParams = ActivityStreamHandler.constructSearchParams(req, 1, AppConfig.getUserTimeZone(req), view);
        ActivityItemSearchParams.Builder builder = ActivityItemSearchParams.Builder.fromParams(this.activityStreamParams).maxItems(1).timeZone(AppConfig.getUserTimeZone(req));
        params.setView(view);
        ActivityItemSearchParams activityParams = builder.build();
        handler.handleActivityStream(req, this.getResponse(), activityParams, user, 1, view, false);
    }

    protected UserManager getUserManager() {
        return this.userManager;
    }

    protected UserProfileManager getUserProfileManager() {
        return this.userProfileManager;
    }

    protected RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }
}

