/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.crucible.actions.search.ajax.AjaxAutocompleter;
import com.atlassian.fisheye.spi.services.CommitterDataService;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.CommitterDisplayDetails;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DefaultCrossRepositorySearcher;
import com.cenqua.fisheye.rep.Tag;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.web.BaseAction;
import com.cenqua.fisheye.web.parameterbeans.BaseActionParams;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class ChangelogAjaxServlet
extends BaseAction
implements AjaxAutocompleter<ConstraintsMatch> {
    private Pattern pattern;
    private String query;
    private int limit = 10;
    private boolean showType = true;
    private List<ConstraintsMatch> matches = new ArrayList<ConstraintsMatch>();
    private List<String> tags = new ArrayList<String>();
    private List<CommitterDisplayDetails> committers = new ArrayList<CommitterDisplayDetails>();
    @Resource
    private DefaultCrossRepositorySearcher crossRepositorySearcher;
    @Resource
    private CommitterDataService committerDataService;
    private int numberOfMatches;

    public ChangelogAjaxServlet() {
    }

    @VisibleForTesting
    protected ChangelogAjaxServlet(DefaultCrossRepositorySearcher crossRepositorySearcher) {
        this.crossRepositorySearcher = crossRepositorySearcher;
    }

    @Override
    public BaseAction handleRequest(BaseActionParams baseParams) throws ServletException, IOException, DbException {
        String command;
        HttpServletRequest req = this.getRequest();
        String limitValue = req.getParameter("limit");
        try {
            this.setLimit(Integer.parseInt(limitValue));
        }
        catch (NumberFormatException e2) {
            Logs.APP_LOG.debug((Object)("Bad value for limit parameter: '" + limitValue + "'"));
        }
        this.setQ(req.getParameter("q"));
        String showType = req.getParameter("showType");
        if (showType != null) {
            this.setShowType(Boolean.valueOf(showType));
        }
        if (!Strings.isNullOrEmpty((String)(command = req.getParameter("command")))) {
            if (command.contains("branches")) {
                Pair<Integer, List<String>> results = this.getBranches();
                for (String branch : results.getSecond()) {
                    this.matches.add(new ConstraintsMatch(branch, "Branch", branch, ConstraintType.BRANCH));
                }
                this.numberOfMatches = results.getFirst();
            } else if (command.contains("tags")) {
                this.tags.addAll(this.getTags());
                this.matchTags();
                this.numberOfMatches = this.matches.size();
            } else if (command.contains("committers")) {
                this.committers.addAll(this.getCommiterDetails());
                this.matchCommitters();
                this.numberOfMatches = this.matches.size();
            }
        }
        req.setAttribute("this", (Object)this);
        req.getRequestDispatcher("/WEB-INF/jsp/ajax/changelog/constraintsFinderResp.jsp").forward((ServletRequest)req, (ServletResponse)this.getResponse());
        return null;
    }

    protected List<CommitterDisplayDetails> getCommiterDetails() throws DbException {
        List<String> authors = this.committerDataService.listCommitters(this.getPathInfo().getRepname(), this.getPathInfo().getLocalPath());
        if (this.activityStreamParams != null && this.activityStreamParams.getCompulsoryCommitter() != null && !authors.contains(this.activityStreamParams.getCompulsoryCommitter())) {
            authors.add(0, this.activityStreamParams.getCompulsoryCommitter());
        }
        return this.getCommitterUserMappingManager().constructUserListFromCommitters(this.getPathInfo().getRepname(), authors);
    }

    private void matchTags() {
        for (String tag : this.tags) {
            if (!this.matches(tag)) continue;
            this.matches.add(new ConstraintsMatch(tag, "Tag", tag, ConstraintType.TAG));
        }
        Collections.sort(this.matches, new ConstraintComparator(this.query));
    }

    private void matchCommitters() {
        for (CommitterDisplayDetails detail : this.committers) {
            if (!this.matches(detail.getUser()) && !this.matches(detail.getCommitter())) continue;
            this.matches.add(new ConstraintsMatch(detail.getUser(), detail.getCommitter(), detail.getCommitter(), ConstraintType.COMMITTER));
        }
        Collections.sort(this.matches, new ConstraintComparator(this.query));
    }

    private boolean matches(String s2) {
        return this.pattern.matcher(s2).find();
    }

    @Override
    public void setQ(String q2) {
        this.query = q2;
        this.pattern = Pattern.compile("\\b" + Pattern.quote(q2) + ".*", 2);
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    public boolean isShowType() {
        return this.showType;
    }

    public void setShowType(boolean showType) {
        this.showType = showType;
    }

    @Override
    public Collection<ConstraintsMatch> getMatches() throws Exception {
        if (this.limit < this.matches.size()) {
            return this.matches.subList(0, this.limit);
        }
        return this.matches;
    }

    public boolean isQuerySpecified() {
        return !this.query.isEmpty();
    }

    public int getTotalItems() {
        return this.numberOfMatches;
    }

    @Override
    public String getErrorMsg() {
        return "";
    }

    @Override
    public boolean isWorked() {
        return true;
    }

    protected Pair<Integer, List<String>> getBranches() throws DbException {
        Pair<Integer, List<String>> result = this.crossRepositorySearcher.findRecentlyModifiedBranches(this.getPathInfo().getRepname(), this.query, this.limit);
        List<String> branches = result.getSecond();
        String defaultBranch = this.getRepositoryCache().getDefaultBranch();
        if (defaultBranch != null && StringUtils.isBlank((String)this.query) || defaultBranch != null && defaultBranch.toLowerCase().startsWith(this.query.toLowerCase())) {
            branches = this.addExplicitItem(branches, defaultBranch);
        }
        return Pair.newInstance(result.getFirst(), branches);
    }

    private List<String> addExplicitItem(List<String> items, final String item) {
        items = new ArrayList<String>(Collections2.filter(items, (Predicate)new Predicate<String>(){

            public boolean apply(@Nonnull String input) {
                return !input.equals(item);
            }
        }));
        items.add(0, item);
        return items;
    }

    protected List<String> getTags() throws DbException {
        ArrayList<String> tags = new ArrayList<String>();
        for (Tag tag : this.getRepositoryCache().getAllTags()) {
            tags.add(tag.getName());
        }
        return tags;
    }

    public static class ConstraintsMatch {
        final String primary;
        final String secondary;
        final String id;
        private final ConstraintType type;

        public ConstraintsMatch(String primary, String secondary, String id, ConstraintType type) {
            this.primary = primary;
            this.secondary = secondary;
            this.id = id;
            this.type = type;
        }

        public String getPrimary() {
            return this.primary;
        }

        public String getSecondary() {
            return this.secondary;
        }

        public String getId() {
            return this.id;
        }

        public boolean isBranch() {
            return this.type == ConstraintType.BRANCH;
        }

        public boolean isTag() {
            return this.type == ConstraintType.TAG;
        }

        public boolean isCommitter() {
            return this.type == ConstraintType.COMMITTER;
        }

        public boolean isPrimaryAndSecondaryDifferent() {
            return !this.getPrimary().equals(this.getSecondary());
        }
    }

    public static final class ConstraintComparator
    implements Comparator<ConstraintsMatch> {
        private final String query;

        public ConstraintComparator(String query) {
            this.query = query;
        }

        @Override
        public int compare(ConstraintsMatch o1, ConstraintsMatch o2) {
            boolean o2StartsWith;
            boolean o2Exact;
            boolean o1Exact = this.query.equalsIgnoreCase(o1.primary);
            if (o1Exact ^ (o2Exact = this.query.equalsIgnoreCase(o2.primary))) {
                return o1Exact ? -1 : 1;
            }
            boolean o1StartsWith = o1.primary.startsWith(this.query);
            if (o1StartsWith ^ (o2StartsWith = o2.primary.startsWith(this.query))) {
                return o1StartsWith ? -1 : 1;
            }
            int alphaCompare = o1.primary.compareToIgnoreCase(o2.primary);
            if (alphaCompare != 0) {
                return alphaCompare;
            }
            return 0;
        }
    }

    public static enum ConstraintType {
        BRANCH,
        TAG,
        COMMITTER;

    }
}

