/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.crucible.explorers.ChangeSetPair;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.activity.BaseActivityItem;
import com.atlassian.fisheye.model.ChangesetComment;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.web.WaybackSpec;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class ChangeSetHolder
extends BaseActivityItem {
    private static final int MAX_BRANCH_TO_DISPLAY = 2;
    public static final String TYPE = "changeset";
    public static final String PERMID_RX = "//[^/]+/[^/]+";
    private ChangeSet changeset;
    private List<ChangeSet> children;
    private List<ChangeSet> parents;
    private Set<String> sortedBranches;
    private Context context;
    private final boolean supportsBranchFilter;
    private final String key;
    private List<ChangesetComment> comments = new ArrayList<ChangesetComment>();
    private boolean isOnlyComment = false;
    private final String actor;
    private final String actorDisplayName;
    public static final Comparator<ChangeSetHolder> COMPARE_TOWARDS_FUTURE = new Comparator<ChangeSetHolder>(){

        @Override
        public int compare(ChangeSetHolder a2, ChangeSetHolder b2) {
            if (a2 == null) {
                return b2 == null ? 0 : 1;
            }
            return ChangeSet.COMPARE_TOWARDS_FUTURE.compare(a2.changeset, b2.changeset);
        }
    };
    public static final Comparator<ChangeSetHolder> COMPARE_TOWARDS_PAST = new Comparator<ChangeSetHolder>(){

        @Override
        public int compare(ChangeSetHolder a2, ChangeSetHolder b2) {
            if (a2 == null) {
                return b2 == null ? 0 : 1;
            }
            return ChangeSet.COMPARE_TOWARDS_PAST.compare(a2.changeset, b2.changeset);
        }
    };

    public static Comparator<ChangeSetHolder> getChangesetComparator(boolean isTowardsFuture) {
        if (isTowardsFuture) {
            return COMPARE_TOWARDS_FUTURE;
        }
        return COMPARE_TOWARDS_PAST;
    }

    public ChangeSetHolder(ChangeSet changeset, Context context, boolean supportsBranchFilter, CommitterUserMappingManager committerUserMappingManager) {
        this.changeset = changeset;
        this.context = context;
        this.supportsBranchFilter = supportsBranchFilter;
        this.key = ChangeSetHolder.createOpaqueId(changeset.getId(), context);
        FecruUser user = committerUserMappingManager.getUserForCommitter(changeset.getRepName(), changeset.getAuthor());
        this.actor = user == null ? changeset.getAuthor() : user.getUsername();
        this.actorDisplayName = user == null ? changeset.getAuthor() : user.getDisplayName();
    }

    public boolean isSupportsBranchFilter() {
        return this.supportsBranchFilter;
    }

    public String getPermId() {
        return ChangeSetPair.newInstance(this.context.getRepoName(), this.changeset.getId()).toString();
    }

    public ChangeSet getChangeset() {
        return this.changeset;
    }

    public Context getContext() {
        return this.context;
    }

    public int getParentCount() {
        return this.changeset.getParents().size();
    }

    public Iterable<ChangeSet> getParents() {
        if (this.parents == null) {
            this.parents = this.getChangesetsFromIds(this.changeset.getParents());
        }
        return this.parents;
    }

    public int getChildCount() {
        return this.changeset.getChildren().size();
    }

    public Iterable<ChangeSet> getChildren() {
        if (this.children == null) {
            this.children = this.getChangesetsFromIds(this.changeset.getChildren());
        }
        return this.children;
    }

    private List<ChangeSet> getChangesetsFromIds(Iterable<String> changesetIds) {
        RevisionCache<? extends ChangeSet> revisionCache;
        ArrayList changeSetHolders = Lists.newArrayList();
        RepositoryHandle rep = AppConfig.getsConfig().getRepositoryManager().getRepository(this.changeset.getRepName());
        try {
            RepositoryEngine eng = rep.acquireEngine();
            revisionCache = eng.getRevisionCache();
        }
        catch (RepositoryHandle.StateException e2) {
            Logs.APP_LOG.warn((Object)("Could not get repository handle for " + this.changeset.getRepName()), (Throwable)((Object)e2));
            return changeSetHolders;
        }
        for (String changesetId : changesetIds) {
            Object cs = revisionCache.getChangeSet(changesetId);
            if (cs != null) {
                changeSetHolders.add(cs);
                continue;
            }
            Logs.APP_LOG.warn((Object)("Couldn't find changeset " + changesetId + " in " + this.changeset.getRepName()));
        }
        return changeSetHolders;
    }

    public int getTagCount() {
        return this.changeset.getTags().size();
    }

    public Iterable<String> getSortedTags() {
        TreeSet<String> sortedTags = new TreeSet<String>();
        this.addNonNull(this.changeset.getTags(), sortedTags);
        return sortedTags;
    }

    public int getBranchCount() {
        return this.changeset.getBranches().size();
    }

    public Iterable<String> getSortedBranches() {
        if (this.sortedBranches == null) {
            this.sortedBranches = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String left, String right) {
                    if (left == null || right == null) {
                        throw new NullPointerException("Branch is not allowed to be null");
                    }
                    if (left.equals(ChangeSetHolder.this.getContext().getDefaultBranch())) {
                        return -1;
                    }
                    if (right.equals(ChangeSetHolder.this.getContext().getDefaultBranch())) {
                        return 1;
                    }
                    return left.compareTo(right);
                }
            });
            this.addNonNull(this.changeset.getBranches(), this.sortedBranches);
        }
        return this.sortedBranches;
    }

    public Iterable<String> getRelevantBranches() {
        List relevantBranches = Lists.newArrayList(this.getSortedBranches());
        if (relevantBranches.size() > 3) {
            relevantBranches = relevantBranches.subList(0, 2);
        }
        return relevantBranches;
    }

    public String getMostRelevantBranch() {
        Iterator<String> iterator = this.getSortedBranches().iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public int getNonRelevantBranchCount() {
        int totalBranchCount = this.getBranchCount();
        if (totalBranchCount > 3) {
            return totalBranchCount - 2;
        }
        return 0;
    }

    private void addNonNull(Iterable<String> source, Collection<String> target) {
        for (String s2 : source) {
            if (StringUtils.isBlank((String)s2)) continue;
            target.add(s2);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDate()).append('\t');
        sb.append(this.context == null ? null : this.context.getRepoName()).append(" - ").append(this.changeset == null ? null : this.changeset.getId());
        sb.append(": ").append(this.comments.size()).append(" comment(s) ");
        for (ChangesetComment c2 : this.comments) {
            sb.append(" [").append(c2.toString()).append("]");
        }
        return sb.toString();
    }

    @Override
    public Date getDate() {
        if (this.isOnlyComment && !this.comments.isEmpty()) {
            return this.comments.get(0).getCreateDate();
        }
        return this.changeset.getDateValue();
    }

    @Override
    public String getType() {
        if (this.isOnlyComment) {
            return "changeset-comment";
        }
        return TYPE;
    }

    @Override
    public String getOpaqueId() {
        return this.key;
    }

    public String getUserDisplayName() {
        return this.changeset.getAuthor();
    }

    private static String createOpaqueId(String csid, Context context) {
        return "changeset:" + csid + ":" + context.getRepoName();
    }

    public boolean getHasComments() {
        return !this.comments.isEmpty();
    }

    public int getNumComments() {
        return this.comments.size();
    }

    public String getFirstChangesetCommentId() {
        if (this.comments.isEmpty()) {
            return null;
        }
        return String.valueOf(this.comments.get(0).getId());
    }

    public List<ChangesetComment> getComments() {
        return this.comments;
    }

    public void setComments(List<ChangesetComment> comments) {
        this.comments = comments;
    }

    public ChangesetComment getComment() {
        return this.comments.get(0);
    }

    public String getActor() {
        return this.actor;
    }

    public String getActorDisplayName() {
        return this.actorDisplayName;
    }

    public static class Context {
        private final WaybackSpec wbSpec;
        private final boolean repoCaseSensitive;
        private final int maxFilesPerChangeset;
        private final Path path;
        private final String repoName;
        private final ScmType repoType;
        @Nullable
        private final String defaultBranch;

        public Context(WaybackSpec wbSpec, boolean repoCaseSensitive, int maxFilesPerChangeset, Path path, String repoName, ScmType repoType, @Nullable String defaultBranch) {
            this.wbSpec = wbSpec;
            this.repoCaseSensitive = repoCaseSensitive;
            this.maxFilesPerChangeset = maxFilesPerChangeset;
            this.path = path;
            this.repoName = repoName;
            this.repoType = repoType;
            this.defaultBranch = defaultBranch;
        }

        public WaybackSpec getWbSpec() {
            return this.wbSpec;
        }

        public boolean isRepoCaseSensitive() {
            return this.repoCaseSensitive;
        }

        public int getMaxFilesPerChangeset() {
            return this.maxFilesPerChangeset;
        }

        public Path getPath() {
            return this.path;
        }

        public String getRepoName() {
            return this.repoName;
        }

        public String getRepoType() {
            return this.repoType.id;
        }

        @Nullable
        public String getDefaultBranch() {
            return this.defaultBranch;
        }
    }
}

