/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.fisheye.svn.Svn2Cache;
import com.atlassian.fisheye.svn.Svn2RepositoryEngine;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.web.CommandString;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class BranchSelectorUtil {
    public Set<Path> getPhysicalPathsAtBranch(String branch, Path otherPhysicalPath, Svn2RepositoryEngine engine) throws DbException, IOException {
        SvnLogicalPathMatcher matcher = engine.getPathMatcher();
        Path logicalPath = matcher.getLogicalPath(otherPhysicalPath);
        if (logicalPath != null) {
            return this.getSvnCache(engine).getPhysicalPathsAtBranch(branch, logicalPath);
        }
        return Collections.singleton(otherPhysicalPath);
    }

    public Path getPhysicalPathAtTag(String tag, Path otherPhysicalPath, Svn2RepositoryEngine engine) throws DbException, IOException {
        SvnLogicalPathMatcher matcher = engine.getPathMatcher();
        Path logicalPath = matcher.getLogicalPath(otherPhysicalPath);
        if (logicalPath != null) {
            Path physicalPathAtTag = this.getSvnCache(engine).getPhysicalPathAtTag(logicalPath, tag, -1, matcher);
            if (physicalPathAtTag != null) {
                if (matcher.getLogicalTail(physicalPathAtTag).equals(matcher.getLogicalTail(otherPhysicalPath))) {
                    return physicalPathAtTag;
                }
                return new Path(physicalPathAtTag, matcher.getLogicalTail(otherPhysicalPath));
            }
            return null;
        }
        return otherPhysicalPath;
    }

    private Svn2Cache getSvnCache(Svn2RepositoryEngine engine) {
        return (Svn2Cache)engine.getInternalRevisionCache();
    }

    private Svn2RepositoryEngine getEngineForBrJump(WaybackSpec waybackSpec, RepositoryEngine engine) {
        if (waybackSpec != null && !Strings.isNullOrEmpty((String)waybackSpec.getBranchOrTag()) && engine instanceof Svn2RepositoryEngine) {
            return (Svn2RepositoryEngine)engine;
        }
        return null;
    }

    public Pair<Path, Integer> getPhysicalPath(Path localPath, WaybackSpec waybackSpec, RepositoryEngine engine) throws IOException, DbException {
        Set<Path> paths = this.getPhysicalPaths(localPath, waybackSpec, engine);
        Path newPhysicalPath = localPath;
        int resultCount = 1;
        if (paths.isEmpty()) {
            newPhysicalPath = null;
        } else {
            Svn2RepositoryEngine svnEngine = this.getEngineForBrJump(waybackSpec, engine);
            if (svnEngine != null) {
                SvnLogicalPathMatcher matcher = svnEngine.getPathMatcher();
                int numComponents = -1;
                for (Path p2 : paths) {
                    if (numComponents != -1 && matcher.getLogicalPath(p2).numComponents() >= numComponents) continue;
                    numComponents = matcher.getLogicalPath(p2).numComponents();
                    newPhysicalPath = p2;
                }
            }
            resultCount = paths.size();
        }
        return newPhysicalPath == null ? null : Pair.newInstance(newPhysicalPath, resultCount);
    }

    public Set<Path> getPhysicalPaths(Path localPath, WaybackSpec waybackSpec, RepositoryEngine engine) throws IOException, DbException {
        Svn2RepositoryEngine svnEngine = this.getEngineForBrJump(waybackSpec, engine);
        Set<Path> paths = new HashSet<Path>();
        if (svnEngine != null) {
            SvnLogicalPathMatcher matcher = svnEngine.getPathMatcher();
            if (matcher.getLogicalPath(localPath) != null) {
                boolean isTag;
                boolean isBranch = !Strings.isNullOrEmpty((String)waybackSpec.getBranch());
                boolean bl = isTag = !Strings.isNullOrEmpty((String)waybackSpec.getTag());
                if (isBranch && !waybackSpec.getBranch().equals(matcher.getBranchOrTrunk(localPath))) {
                    paths = this.getPhysicalPathsAtBranch(waybackSpec.getBranch(), localPath, (Svn2RepositoryEngine)engine);
                } else if (isTag && !waybackSpec.getTag().equals(matcher.getTag(localPath))) {
                    Path newPath = this.getPhysicalPathAtTag(waybackSpec.getTag(), localPath, (Svn2RepositoryEngine)engine);
                    if (newPath != null) {
                        paths.add(newPath);
                    }
                } else {
                    paths.add(localPath);
                }
            }
        } else {
            paths.add(localPath);
        }
        return paths;
    }

    public String getPhysicalPathUrl(Path localPath, WaybackSpec waybackSpec, RepositoryEngine engine, String repname, String queryString) throws IOException, DbException {
        Pair<Path, Integer> path = this.getPhysicalPath(localPath, waybackSpec, engine);
        Path newPhysicalPath = null;
        if (path != null) {
            newPhysicalPath = path.getFirst();
            if (path.getSecond() > 1) {
                waybackSpec.setMultipleBranches(true);
            }
        } else if (!localPath.isRoot()) {
            waybackSpec.setDirectedToRoot(true);
        }
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(waybackSpec == null ? "" : waybackSpec.getUrlCommandWithVolatileParams()).append("/").append(FishEyeURLEncoder.uriEncode(repname)).append("/").append(newPhysicalPath == null ? "" : newPhysicalPath.getAsUrl());
        if (waybackSpec != null && (waybackSpec.isDirectedToRoot() || waybackSpec.isMultipleBranches())) {
            queryString = !Strings.isNullOrEmpty((String)queryString) ? queryString + "&" : "";
            queryString = queryString + "origPath=" + localPath.getAsUrl();
            queryString = queryString + "&origCmdStr=" + waybackSpec.getUrlCommandParams();
        }
        if (!Strings.isNullOrEmpty((String)queryString)) {
            urlBuilder.append("?").append(queryString);
        }
        return urlBuilder.toString();
    }

    public static FishEyePathInfo createPathInfoForOrigPath(String repname, String commandString, HttpServletRequest req) throws RepositoryHandle.StateException {
        Path lpath = new Path(req.getParameter("origPath"));
        CommandString cs = new CommandString(commandString);
        return new FishEyePathInfo(cs, repname, lpath);
    }
}

